/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.util;

import com.ecc.emp.core.Context;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DuplicatedDataNameException;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.dbmodel.PageInfo;
import com.ecc.emp.dbmodel.TableModel;
import com.ecc.emp.dbmodel.TableModelField;
import com.ecc.emp.dbmodel.service.TableModelLoader;

public class TableModelUtil {
    public static String SYS_CUSTOM_CONDI_AHEAD = "SYS_CUSTOM_CONDI_A";
    public static String SYS_CUSTOM_CONDI_BEHIND = "SYS_CUSTOM_CONDI_B";
    public static final String SEARCH_TYPE_START_WITH = "10";
    public static final String SEARCH_TYPE_CONTAIN = "20";
    public static final String SEARCH_TYPE_EQUALS = "30";
    public static final String SEARCH_TYPE_END_WITH = "40";
    public static final String SEARCH_TYPE_GREATER_THAN = "50";
    public static final String SEARCH_TYPE_LESS_THAN = "60";
    public static final String SEARCH_TYPE_BETWEEN = "70";
    public static final String SEARCH_TYPE_SPLIT_FLAG = "_";

    public static PageInfo createPageInfo(Context context, String countType, String maxLine) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageSize(maxLine);
        try {
            String pageSize = (String)context.getDataValue("pageInfo.maxLine");
            pageInfo.setPageSize(pageSize);
        }
        catch (Exception pageSize) {
            // empty catch block
        }
        try {
            String pageIdx = (String)context.getDataValue("pageInfo.targetPage");
            pageInfo.setPageIdx(pageIdx);
        }
        catch (Exception pageIdx) {
            // empty catch block
        }
        if ("never".equals(countType)) {
            pageInfo.setRecordSize("0");
        } else if ("every".equals(countType)) {
            pageInfo.setRecordSize("-1");
        } else {
            try {
                String recordSize = (String)context.getDataValue("pageInfo.recordSize");
                pageInfo.setRecordSize(recordSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageInfo;
    }

    public static void parsePageInfo(Context context, PageInfo pageInfo) {
        KeyedCollection pi = null;
        try {
            pi = (KeyedCollection)context.getDataElement("pageInfo");
        }
        catch (Exception e) {
            pi = new KeyedCollection("pageInfo");
            try {
                context.addDataElement((DataElement)pi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (pi.containsKey((Object)"currentPage")) {
                pi.setDataValue("currentPage", (Object)new Integer(pageInfo.pageIdx).toString());
            } else {
                pi.addDataField("currentPage", (Object)new Integer(pageInfo.pageIdx).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (pi.containsKey((Object)"maxLine")) {
                pi.setDataValue("maxLine", (Object)new Integer(pageInfo.pageSize).toString());
            } else {
                pi.addDataField("maxLine", (Object)new Integer(pageInfo.pageSize).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (pi.containsKey((Object)"recordSize")) {
                pi.setDataValue("recordSize", (Object)new Integer(pageInfo.recordSize).toString());
            } else {
                pi.addDataField("recordSize", (Object)new Integer(pageInfo.recordSize).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getQueryCondition(String modelId, KeyedCollection queryData, Context context, boolean isSection, boolean isBlur, boolean isNull) {
        StringBuffer conditionBuffer = new StringBuffer();
        if (queryData != null && queryData.size() > 0) {
            KeyedCollection queryType = null;
            try {
                queryType = (KeyedCollection)context.getDataElement("queryType");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (queryType != null) {
                String isSectionStr2;
                try {
                    isSectionStr2 = (String)queryType.getDataValue("isSection");
                    isSection = new Boolean(isSectionStr2);
                }
                catch (Exception isSectionStr2) {
                    // empty catch block
                }
                try {
                    isSectionStr2 = (String)queryType.getDataValue("isBlur");
                }
                catch (Exception isSectionStr2) {
                    // empty catch block
                }
            }
            boolean hasCondition = false;
            TableModelLoader modelLoader = (TableModelLoader)((Object)context.getService("tableModelLoader"));
            TableModel model = modelLoader.getTableModel(modelId);
            for (TableModelField field : model.getModelFields().values()) {
                String dataValue;
                if (queryData.containsKey((Object)field.getId())) {
                    dataValue = null;
                    try {
                        dataValue = (String)queryData.getDataValue(field.getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((dataValue == null || dataValue.trim().length() == 0 || dataValue.trim().length() == 3 && dataValue.trim().endsWith(SEARCH_TYPE_SPLIT_FLAG)) && !isNull) continue;
                    dataValue = dataValue.trim();
                    if (!hasCondition) {
                        conditionBuffer.append(" WHERE (");
                        hasCondition = true;
                    } else if (isSection) {
                        conditionBuffer.append(" OR ");
                    } else {
                        conditionBuffer.append(" AND ");
                    }
                    conditionBuffer.append(TableModelUtil.getSearchTypeField(field, dataValue));
                    continue;
                }
                if (queryData.containsKey((Object)(String.valueOf(field.getId()) + "_begin"))) {
                    dataValue = null;
                    try {
                        dataValue = (String)queryData.getDataValue(String.valueOf(field.getId()) + "_begin");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dataValue != null && dataValue.length() != 0 && (dataValue.trim().length() != 3 || !dataValue.trim().endsWith(SEARCH_TYPE_SPLIT_FLAG)) || isNull) {
                        dataValue = dataValue.trim();
                        if (!hasCondition) {
                            conditionBuffer.append(" WHERE (");
                            hasCondition = true;
                        } else if (isSection) {
                            conditionBuffer.append(" OR ");
                        } else {
                            conditionBuffer.append(" AND ");
                        }
                        if (field.isCharType()) {
                            conditionBuffer.append(String.valueOf(field.getColumnName()) + " >='" + dataValue + "' ");
                        } else {
                            conditionBuffer.append(String.valueOf(field.getColumnName()) + " >= " + dataValue + " ");
                        }
                    }
                }
                if (!queryData.containsKey((Object)(String.valueOf(field.getId()) + "_end"))) continue;
                dataValue = null;
                try {
                    dataValue = (String)queryData.getDataValue(String.valueOf(field.getId()) + "_end");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((dataValue == null || dataValue.length() == 0 || dataValue.trim().length() == 3 && dataValue.trim().endsWith(SEARCH_TYPE_SPLIT_FLAG)) && !isNull) continue;
                if (!hasCondition) {
                    conditionBuffer.append(" WHERE (");
                    hasCondition = true;
                } else if (isSection) {
                    conditionBuffer.append(" OR ");
                } else {
                    conditionBuffer.append(" AND ");
                }
                if (field.isCharType()) {
                    conditionBuffer.append(String.valueOf(field.getColumnName()) + " <='" + dataValue + "' ");
                    continue;
                }
                conditionBuffer.append(String.valueOf(field.getColumnName()) + " <= " + dataValue + " ");
            }
            if (conditionBuffer != null && !conditionBuffer.toString().trim().equals("")) {
                conditionBuffer.append(") ");
            }
        }
        try {
            if (context != null && context.getDataValue(SYS_CUSTOM_CONDI_BEHIND) != null) {
                String custCondi = (String)context.getDataValue(SYS_CUSTOM_CONDI_BEHIND);
                if (custCondi != null && !custCondi.trim().equals("")) {
                    if (conditionBuffer != null && !conditionBuffer.toString().trim().equals("")) {
                        conditionBuffer.append(" and (").append(custCondi).append(") ");
                    } else {
                        conditionBuffer.append("WHERE ").append(custCondi);
                    }
                } else {
                    System.err.println("\u8bbe\u7f6e\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff0c\u81ea\u5b9a\u4e49\u6761\u4ef6\u65e0\u6548!");
                }
            } else {
                System.err.println("\u8bbe\u7f6e\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff0c\u81ea\u5b9a\u4e49\u6761\u4ef6\u65e0\u6548!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conditionBuffer.toString();
    }

    private static String getSearchTypeField(TableModelField field, String dataValue) {
        if (dataValue == null || dataValue.trim().equals("") || field == null) {
            return "";
        }
        String retValue = dataValue;
        if (dataValue.length() > 3 && dataValue.substring(0, 3).matches("\\d{2}_")) {
            String searchType = dataValue.substring(0, dataValue.indexOf(SEARCH_TYPE_SPLIT_FLAG));
            dataValue = dataValue.substring(dataValue.indexOf(SEARCH_TYPE_SPLIT_FLAG) + 1);
            if (searchType.equals(SEARCH_TYPE_START_WITH) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " like '" + dataValue + "%' ";
            } else if (searchType.equals(SEARCH_TYPE_END_WITH) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " like '%" + dataValue + "' ";
            } else if (searchType.equals(SEARCH_TYPE_CONTAIN) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " like '%" + dataValue + "%' ";
            } else if (searchType.equals(SEARCH_TYPE_EQUALS) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " = '" + dataValue + "' ";
            } else if (searchType.equals(SEARCH_TYPE_GREATER_THAN) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " >= '" + dataValue + "' ";
            } else if (searchType.equals(SEARCH_TYPE_GREATER_THAN)) {
                retValue = String.valueOf(field.getColumnName()) + " >= " + dataValue + " ";
            } else if (searchType.equals(SEARCH_TYPE_LESS_THAN) && field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " <= '" + dataValue + "' ";
            } else if (searchType.equals(SEARCH_TYPE_LESS_THAN)) {
                retValue = String.valueOf(field.getColumnName()) + " <= " + dataValue + " ";
            } else if (!field.isCharType()) {
                retValue = String.valueOf(field.getColumnName()) + " = " + dataValue + " ";
            }
        } else {
            retValue = field.isCharType() ? String.valueOf(field.getColumnName()) + " = '" + dataValue + "' " : String.valueOf(field.getColumnName()) + " = " + dataValue + " ";
        }
        return retValue;
    }

    public static void main(String[] args) {
        String ss = "_dabcdd";
        System.out.println(ss.substring(0, ss.indexOf(SEARCH_TYPE_SPLIT_FLAG)));
    }

    public static String getQueryCondition_bak(String modelId, KeyedCollection queryData, Context context, boolean isSection, boolean isBlur, boolean isNull) {
        StringBuffer conditionBuffer = new StringBuffer();
        if (queryData != null && queryData.size() > 0) {
            KeyedCollection queryType = null;
            try {
                queryType = (KeyedCollection)context.getDataElement("queryType");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (queryType != null) {
                try {
                    String isSectionStr = (String)queryType.getDataValue("isSection");
                    isSection = new Boolean(isSectionStr);
                }
                catch (Exception isSectionStr) {
                    // empty catch block
                }
                try {
                    String isBlurStr = (String)queryType.getDataValue("isBlur");
                    isBlur = new Boolean(isBlurStr);
                }
                catch (Exception isBlurStr) {
                    // empty catch block
                }
            }
            boolean hasCondition = false;
            TableModelLoader modelLoader = (TableModelLoader)((Object)context.getService("tableModelLoader"));
            TableModel model = modelLoader.getTableModel(modelId);
            for (TableModelField field : model.getModelFields().values()) {
                String dataValue;
                if (queryData.containsKey((Object)field.getId())) {
                    dataValue = null;
                    try {
                        dataValue = (String)queryData.getDataValue(field.getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((dataValue == null || dataValue.length() == 0) && !isNull) continue;
                    if (!hasCondition) {
                        conditionBuffer.append(" WHERE (");
                        hasCondition = true;
                    } else if (isSection) {
                        conditionBuffer.append(" OR ");
                    } else {
                        conditionBuffer.append(" AND ");
                    }
                    if (dataValue == null || dataValue.length() == 0) {
                        conditionBuffer.append(String.valueOf(field.getColumnName()) + " IS NULL ");
                        continue;
                    }
                    if (field.isCharType() && isBlur) {
                        conditionBuffer.append(String.valueOf(field.getColumnName()) + " LIKE '%" + dataValue + "%' ");
                        continue;
                    }
                    if (field.isCharType()) {
                        conditionBuffer.append(String.valueOf(field.getColumnName()) + " = '" + dataValue + "' ");
                        continue;
                    }
                    conditionBuffer.append(String.valueOf(field.getColumnName()) + " = " + dataValue + " ");
                    continue;
                }
                if (queryData.containsKey((Object)(String.valueOf(field.getId()) + "_begin"))) {
                    dataValue = null;
                    try {
                        dataValue = (String)queryData.getDataValue(String.valueOf(field.getId()) + "_begin");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dataValue != null && dataValue.length() != 0 || isNull) {
                        if (!hasCondition) {
                            conditionBuffer.append(" WHERE (");
                            hasCondition = true;
                        } else if (isSection) {
                            conditionBuffer.append(" OR ");
                        } else {
                            conditionBuffer.append(" AND ");
                        }
                        if (dataValue == null || dataValue.length() == 0) {
                            conditionBuffer.append(String.valueOf(field.getColumnName()) + " IS NULL ");
                        } else if (field.isCharType()) {
                            conditionBuffer.append(String.valueOf(field.getColumnName()) + " >='" + dataValue + "' ");
                        } else {
                            conditionBuffer.append(String.valueOf(field.getColumnName()) + " >= " + dataValue + " ");
                        }
                    }
                }
                if (!queryData.containsKey((Object)(String.valueOf(field.getId()) + "_end"))) continue;
                dataValue = null;
                try {
                    dataValue = (String)queryData.getDataValue(String.valueOf(field.getId()) + "_end");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((dataValue == null || dataValue.length() == 0) && !isNull) continue;
                if (!hasCondition) {
                    conditionBuffer.append(" WHERE (");
                    hasCondition = true;
                } else if (isSection) {
                    conditionBuffer.append(" OR ");
                } else {
                    conditionBuffer.append(" AND ");
                }
                if (dataValue == null || dataValue.length() == 0) {
                    conditionBuffer.append(String.valueOf(field.getColumnName()) + " IS NULL ");
                    continue;
                }
                if (field.isCharType()) {
                    conditionBuffer.append(String.valueOf(field.getColumnName()) + " <='" + dataValue + "' ");
                    continue;
                }
                conditionBuffer.append(String.valueOf(field.getColumnName()) + " <= " + dataValue + " ");
            }
            if (conditionBuffer != null && !conditionBuffer.toString().trim().equals("")) {
                conditionBuffer.append(") ");
            }
        }
        try {
            if (context != null && context.getDataValue(SYS_CUSTOM_CONDI_BEHIND) != null) {
                String custCondi = (String)context.getDataValue(SYS_CUSTOM_CONDI_BEHIND);
                if (custCondi != null && !custCondi.trim().equals("")) {
                    if (conditionBuffer != null && !conditionBuffer.toString().trim().equals("")) {
                        conditionBuffer.append(" and (").append(custCondi).append(") ");
                    } else {
                        conditionBuffer.append("WHERE ").append(custCondi);
                    }
                } else {
                    System.err.println("\u8bbe\u7f6e\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff0c\u81ea\u5b9a\u4e49\u6761\u4ef6\u65e0\u6548!");
                }
            } else {
                System.err.println("\u8bbe\u7f6e\u7684\u81ea\u5b9a\u4e49\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\uff0c\u81ea\u5b9a\u4e49\u6761\u4ef6\u65e0\u6548!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conditionBuffer.toString();
    }

    public static void setCustomizeQueryConditionB(String custCondi, Context context) {
        try {
            if (custCondi != null) {
                context.addDataField(SYS_CUSTOM_CONDI_BEHIND, (Object)custCondi);
            }
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (DuplicatedDataNameException e) {
            try {
                context.setDataValue(SYS_CUSTOM_CONDI_BEHIND, (Object)custCondi);
            }
            catch (ObjectNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InvalidArgumentException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void setCustomizeQueryConditionA(String custCondi, Context context) {
        try {
            if (custCondi != null) {
                context.addDataField(SYS_CUSTOM_CONDI_AHEAD, (Object)custCondi);
            }
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (DuplicatedDataNameException e) {
            try {
                context.setDataValue(SYS_CUSTOM_CONDI_AHEAD, (Object)custCondi);
            }
            catch (ObjectNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InvalidArgumentException e1) {
                e1.printStackTrace();
            }
        }
    }
}

