/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.util;

import com.ecc.emp.core.Context;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.exception.ExcelReadException;
import com.yucheng.pub.utils.excel.model.CellVO;
import com.yucheng.pub.utils.excel.model.ExcelVO;
import com.yucheng.pub.utils.excel.model.SheetVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtil {
    public static List<? extends CMISDomain> getPojoFromExcelVo(Context context, ExcelVO excelVO, CMISDomain domain) throws ExcelReadException, Exception {
        ArrayList<CMISDomain> domainList = new ArrayList<CMISDomain>();
        if (excelVO.sheets != null) {
            SheetVO[] sheetVOArray = excelVO.sheets;
            int n = excelVO.sheets.length;
            int n2 = 0;
            while (n2 < n) {
                SheetVO sheetVO = sheetVOArray[n2];
                if (sheetVO.cells != null) {
                    String[][] firstLen = new String[sheetVO.cells[0].length][3];
                    int i = 0;
                    while (i < sheetVO.cells.length) {
                        Object cellvalue;
                        CellVO cellVO;
                        if (i == 0) {
                            int j = 0;
                            while (j < sheetVO.cells[i].length) {
                                cellVO = sheetVO.cells[i][j];
                                if (cellVO != null) {
                                    cellvalue = cellVO.cellvalue;
                                    JSONObject object = ExcelUtil.string2Json(String.valueOf(cellvalue));
                                    firstLen[j][0] = (String)object.get("dataName");
                                    firstLen[j][1] = (String)object.get("name");
                                    firstLen[j][2] = (String)object.get("dictName");
                                }
                                ++j;
                            }
                        } else if (i == 1) {
                            int j = 0;
                            while (j < sheetVO.cells[i].length) {
                                cellVO = sheetVO.cells[i][j];
                                if (cellVO != null) {
                                    cellvalue = cellVO.cellvalue;
                                    String cellvalueCn = String.valueOf(cellvalue);
                                    if (firstLen[j][1] == null || StringUtils.isBlank((String)cellvalueCn) || !String.valueOf(cellvalueCn).equals(firstLen[j][1].toString())) {
                                        throw new ExcelReadException("REP0000021", cellvalueCn, "");
                                    }
                                }
                                ++j;
                            }
                        } else {
                            Class<?> class1 = domain.getClass();
                            CMISDomain newInstance = (CMISDomain)class1.newInstance();
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            int j = 0;
                            while (j < sheetVO.cells[i].length) {
                                CellVO cellVO2 = sheetVO.cells[i][j];
                                if (cellVO2 != null) {
                                    Object cellvalue2 = cellVO2.cellvalue;
                                    String fieldName = firstLen[j][0].toString();
                                    String dictName = firstLen[j][2].toString();
                                    if (StringUtils.isNotBlank((String)dictName)) {
                                        cellvalue2 = ExcelUtil.getDisplayName(String.valueOf(cellvalue2), dictName, context);
                                    }
                                    if (cellvalue2 != null) {
                                        map.put(fieldName, cellvalue2);
                                    } else {
                                        map.put(fieldName, null);
                                    }
                                }
                                ++j;
                            }
                            newInstance.putData(map);
                            domainList.add(newInstance);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return domainList;
    }

    private static String getDisplayName(String value, String dictName, Context context) throws ExcelReadException, Exception {
        if (value == null || dictName == null) {
            return value;
        }
        String decoratedValue = value;
        try {
            IndexedCollection iColl = CacheClient.getDictByType((Context)context, (String)dictName);
            if (iColl == null) {
                EMPLog.log((String)"CMIS", (int)EMPLog.WARNING, (int)0, (String)("\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01\u4e0d\u5b58\u5728\u540d\u4e3a" + dictName + "\u7684\u5b57\u5178\u9879\uff01"));
                throw new ExcelReadException("DIC0000010", dictName, "");
            }
            int i = 0;
            while (i < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(i);
                String cnname = (String)kColl.getDataValue("cnname");
                if (value.equals(cnname)) {
                    String enname;
                    decoratedValue = enname = (String)kColl.getDataValue("enname");
                    break;
                }
                ++i;
            }
        }
        catch (ExcelReadException e) {
            EMPLog.log((String)"CMIS-PLAT-ExcelUtil", (int)EMPLog.WARNING, (int)0, (String)"\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01", (Throwable)((Object)e));
            throw new ExcelReadException("DIC0000011", "", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decoratedValue;
    }

    public static JSONObject string2Json(String str) throws ExcelReadException {
        try {
            str = str.replaceAll("\\;", "\\,").replaceAll("\\=", "\\:");
            String ss = "[" + str + "]";
            JSONArray json = JSONArray.fromObject((Object)ss);
            JSONObject object = JSONObject.fromObject((Object)json.get(0));
            return object;
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS-PLAT-ExcelUtil", (int)EMPLog.WARNING, (int)0, (String)("\u9690\u85cf\u8868\u5934\u4fe1\u606f[" + str + "]\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u6a21\u7248\u5b9a\u4e49\u7684\u9690\u85cf\u8868\u5934\uff01"), (Throwable)e);
            throw new ExcelReadException("REP0000022", str, e.getMessage());
        }
    }

    public static JSONObject string2JsonTwo(String str) throws ExcelReadException {
        try {
            str = str.replaceAll("\\{", "\\{'").replaceAll("\\}", "\\'}").replaceAll("\\=", "\\':'").replaceAll("\\;", "\\','");
            String ss = "[" + str + "]";
            JSONArray json = JSONArray.fromObject((Object)ss);
            JSONObject object = JSONObject.fromObject((Object)json.get(0));
            return object;
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS-PLAT-ExcelUtil", (int)EMPLog.WARNING, (int)0, (String)("\u8868\u683c\u6570\u636e[" + str + "]\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u5b9a\u5408\u89c4\u7684\u6570\u636e\u8981\u6c42\uff01"), (Throwable)e);
            throw new ExcelReadException("REP0000023", str, e.getMessage());
        }
    }

    public static void main(String[] args) {
        String ss = "[{celltype=1;cellvalue={dataName='id', name='\u4e3b\u952e', dictName=''}}]";
        ss = ss.replaceAll("\\;", "\\,").replaceAll("\\=", "\\:");
        System.out.println("--------:" + ss);
        ss = "[{celltype=1;cellvalue=a}]";
        ss = ss.replaceAll("\\{", "\\{'").replaceAll("\\}", "\\'}").replaceAll("\\=", "\\':'").replaceAll("\\;", "\\','");
        JSONArray json = JSONArray.fromObject((Object)ss);
        JSONObject object = JSONObject.fromObject((Object)json.get(0));
        System.out.println("::" + object.get("celltype"));
        System.out.println("::" + object.get("cellvalue"));
    }
}

