/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.util;

import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.core.Context;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.dao.SqlClient;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.util.ResourceUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISPropertyManager {
    private static CMISPropertyManager instance = new CMISPropertyManager();
    private static String FILE_NAME = "cmis";
    public static boolean isInit = false;
    private static String permissionFilePath = null;
    private static String componentConfigFileDir = null;
    private static String agentConfigFileDir = null;
    private static String daoConfigFileDir = null;
    private static String moduleserviceConfigFileDir = null;
    private static String moduleInitializerConfigFileDir = null;
    private static String logflag = null;
    private static String pluginUninstallBackUpPath = null;
    private static String cmisProjectPath = null;
    private static ResourceBundle res = null;
    private static Context context;
    public static int period;
    public static Map<String, String> cfgsMap;

    static {
        period = 10000;
        cfgsMap = new HashMap<String, String>();
    }

    public static CMISPropertyManager getInstance() {
        CMISPropertyManager.init();
        return instance;
    }

    public static void init() {
        if (isInit) {
            return;
        }
        res = ResourceBundle.getBundle(FILE_NAME);
        try {
            Set<String> keySet = res.keySet();
            for (String proKey : keySet) {
                cfgsMap.put(proKey, res.getString(proKey));
            }
            permissionFilePath = res.getString("permission.file.path");
            permissionFilePath = ResourceUtils.getFile((String)permissionFilePath).getAbsolutePath();
            componentConfigFileDir = res.getString("component.config.file.dir");
            agentConfigFileDir = res.getString("agent.config.file.dir");
            daoConfigFileDir = res.getString("dao.config.file.dir");
            moduleserviceConfigFileDir = res.getString("moduleservice.config.file.dir");
            moduleInitializerConfigFileDir = res.getString("module.initializer.config.file.dir");
            logflag = res.getString("logflag");
            pluginUninstallBackUpPath = res.getString("pluginUninstallBackUpPath");
            cmisProjectPath = res.getString("cmisProjectPath");
            cfgsMap.put("permissionFilePath", permissionFilePath);
            cfgsMap.put("componentConfigFileDir", componentConfigFileDir);
            cfgsMap.put("agentConfigFileDir", agentConfigFileDir);
            cfgsMap.put("daoConfigFileDir", daoConfigFileDir);
            cfgsMap.put("moduleserviceConfigFileDir", moduleserviceConfigFileDir);
            cfgsMap.put("moduleInitializerConfigFileDir", moduleInitializerConfigFileDir);
            cfgsMap.put("logflag", logflag);
            cfgsMap.put("pluginUninstallBackUpPath", pluginUninstallBackUpPath);
            cfgsMap.put("cmisProjectPath", cmisProjectPath);
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.ERROR, (int)0, (String)"\u52a0\u8f7dcmis.properties\u51fa\u9519!", (Throwable)e);
            throw new RuntimeException("\u52a0\u8f7dcmis.properties\u51fa\u9519! " + cfgsMap);
        }
        isInit = true;
    }

    public void loadData() {
        block15: {
            Connection connection = null;
            DataSource dataSource = null;
            try {
                try {
                    List cfgList = null;
                    EMPFlowComponentFactory factory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)"CMISBiz");
                    context = factory.getContextNamed(factory.getRootContextName());
                    dataSource = (DataSource)context.getService("dataSource");
                    connection = ConnectionManager.getConnection((DataSource)dataSource);
                    cfgList = (List)SqlClient.queryList((String)"querySConfigLike", (Object)"", (Connection)connection);
                    int i = 0;
                    while (i < cfgList.size()) {
                        CMISDomain cfg = (CMISDomain)cfgList.get(i);
                        cfgsMap.put((String)cfg.getDataMap().get("cfg_name"), (String)cfg.getDataMap().get("cfg_value"));
                        ++i;
                    }
                    res = ResourceBundle.getBundle(FILE_NAME);
                    permissionFilePath = res.getString("permission.file.path");
                    permissionFilePath = ResourceUtils.getFile((String)permissionFilePath).getAbsolutePath();
                    componentConfigFileDir = res.getString("component.config.file.dir");
                    agentConfigFileDir = res.getString("agent.config.file.dir");
                    daoConfigFileDir = res.getString("dao.config.file.dir");
                    moduleserviceConfigFileDir = res.getString("moduleservice.config.file.dir");
                    moduleInitializerConfigFileDir = res.getString("module.initializer.config.file.dir");
                    logflag = res.getString("logflag");
                    pluginUninstallBackUpPath = res.getString("pluginUninstallBackUpPath");
                    cmisProjectPath = res.getString("cmisProjectPath");
                    cfgsMap.put("permissionFilePath", permissionFilePath);
                    cfgsMap.put("componentConfigFileDir", componentConfigFileDir);
                    cfgsMap.put("agentConfigFileDir", agentConfigFileDir);
                    cfgsMap.put("daoConfigFileDir", daoConfigFileDir);
                    cfgsMap.put("moduleserviceConfigFileDir", moduleserviceConfigFileDir);
                    cfgsMap.put("moduleInitializerConfigFileDir", moduleInitializerConfigFileDir);
                    cfgsMap.put("logflag", logflag);
                    cfgsMap.put("pluginUninstallBackUpPath", pluginUninstallBackUpPath);
                    cfgsMap.put("cmisProjectPath", cmisProjectPath);
                    EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.DEBUG, (int)0, (String)"\u52a0\u8f7d\u914d\u7f6e\u6570\u636e\u6210\u529f!");
                }
                catch (Exception e) {
                    EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.ERROR, (int)0, (String)"\u52a0\u8f7d\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u51fa\u9519!", (Throwable)e);
                    if (connection != null) {
                        try {
                            ConnectionManager.releaseConnection(dataSource, connection);
                        }
                        catch (EMPJDBCException e2) {
                            EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.ERROR, (int)0, (String)"\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519!", (Throwable)e2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        ConnectionManager.releaseConnection(dataSource, connection);
                    }
                    catch (EMPJDBCException e) {
                        EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.ERROR, (int)0, (String)"\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519!", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (connection != null) {
                try {
                    ConnectionManager.releaseConnection((DataSource)dataSource, (Connection)connection);
                }
                catch (EMPJDBCException e) {
                    EMPLog.log((String)"CMIS-PROPERTIES", (int)EMPLog.ERROR, (int)0, (String)"\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519!", (Throwable)e);
                }
            }
        }
    }

    public String getPropertyValue(String key) {
        String value = cfgsMap.get(key);
        return value;
    }

    public Collection<String> getAllKeys() {
        Set<String> keys = cfgsMap.keySet();
        return keys;
    }

    public Collection<String> getAllValues() {
        Collection<String> values = cfgsMap.values();
        return values;
    }

    public String getPermissionFilePath() {
        return permissionFilePath;
    }

    public String getComponentConfigFileDir() {
        return componentConfigFileDir;
    }

    public String getAgentConfigFileDir() {
        return agentConfigFileDir;
    }

    public String getDaoConfigFileDir() {
        return daoConfigFileDir;
    }

    public String getModuleserviceConfigFileDir() {
        return moduleserviceConfigFileDir;
    }

    public String getLogflag() {
        return logflag;
    }

    public String getPluginUninstallBackUpPath() {
        return pluginUninstallBackUpPath;
    }

    public String getCmisProjectPath() {
        return cmisProjectPath;
    }

    public String getModuleInitializerConfigFileDir() {
        return moduleInitializerConfigFileDir;
    }
}

