/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.language;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.session.Session;
import com.ecc.emp.session.SessionManager;
import com.yucheng.cmis.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class LanguageManager {
    private static final String LANGUAGE_FILE_ENCODING = "UTF-8";
    private static final String LANG_FILE_SUFFIX = ".lang";
    private static final String LANG_FILES_PATH = "languages";
    private static Map<String, Map<String, String>> languageMap = null;

    private static void loadLanguageFiles() {
        languageMap = new HashMap<String, Map<String, String>>();
        String langFilesPath = String.valueOf(CommonUtil.getClassesPath()) + LANG_FILES_PATH;
        File path = new File(langFilesPath);
        if (path.isDirectory()) {
            File[] listFiles;
            File[] fileArray = listFiles = path.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(LanguageManager.LANG_FILE_SUFFIX);
                }
            });
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    File file = fileArray[n2];
                    String fileName = file.getName();
                    BufferedReader br = null;
                    try {
                        try {
                            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), LANGUAGE_FILE_ENCODING));
                            HashMap<String, String> map = new HashMap<String, String>();
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                String key;
                                int indexOf;
                                if (line.trim().equals("") || line.trim().startsWith("#") || (indexOf = line.indexOf("=")) < 0 || (key = line.substring(0, indexOf).trim()).length() == 0) continue;
                                String value = line.substring(indexOf + 1);
                                map.put(key, value);
                            }
                            String language = fileName.substring(0, fileName.lastIndexOf(LANG_FILE_SUFFIX));
                            languageMap.put(language.toLowerCase(), map);
                            EMPLog.log((String)"Core", (int)EMPLog.INFO, (int)0, (String)("\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6" + fileName + "\u6210\u529f"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            EMPLog.log((String)"Core", (int)EMPLog.INFO, (int)0, (String)("\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6" + fileName + "\u51fa\u9519,"), (Throwable)e);
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e2) {
                                    EMPLog.log((String)"Core", (int)EMPLog.INFO, (int)0, (String)("\u52a0\u8bed\u8a00\u6587\u4ef6" + fileName + "\u51fa\u9519,"), (Throwable)e2);
                                }
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                EMPLog.log((String)"Core", (int)EMPLog.INFO, (int)0, (String)("\u52a0\u8bed\u8a00\u6587\u4ef6" + fileName + "\u51fa\u9519,"), (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            EMPLog.log((String)"Core", (int)EMPLog.INFO, (int)0, (String)("\u52a0\u8bed\u8a00\u6587\u4ef6" + fileName + "\u51fa\u9519,"), (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public static String translation(PageContext pageContext, String text) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return LanguageManager.translation(request, text);
    }

    public static String translation(HttpServletRequest request, String text) {
        String language = LanguageManager.getUserLanguage(request);
        return LanguageManager.translation(language, text);
    }

    public static String translation(Context context, String text) {
        String language = "zh_CN";
        try {
            String userLang = (String)context.getDataValue("user_locale_language");
            if (userLang != null && !"".equals(userLang)) {
                language = userLang;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LanguageManager.translation(language, text);
    }

    public static String translation(String language, String text) {
        if (language == null || language.equals("")) {
            return text;
        }
        if (languageMap == null) {
            LanguageManager.loadLanguageFiles();
        }
        Map<String, String> map = languageMap.get(language.toLowerCase());
        String retText = null;
        if (map != null) {
            retText = map.get(text);
        }
        return retText == null ? text : retText;
    }

    public static String getUserLanguage(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return LanguageManager.getUserLanguage(request);
    }

    public static String getUserLanguage(HttpServletRequest request) {
        SessionManager sessionManager;
        Session empSession;
        String language = null;
        Context context = (Context)request.getAttribute(EMPConstance.ATTR_CONTEXT);
        if (context != null) {
            try {
                language = (String)context.getDataValue("user_locale_language");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (language == null && (empSession = (sessionManager = (SessionManager)request.getAttribute(EMPConstance.ATTR_SESSION_MGR)).getSession((Object)request, null, false)) != null) {
            language = (String)empSession.getAttribute("user_locale_language");
        }
        if (language == null) {
            language = (String)request.getSession().getAttribute("user_locale_language");
        }
        if (language == null) {
            language = "zh_CN";
        }
        return language.toLowerCase();
    }
}

