/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.digester;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.pub.digester.DDict;
import com.yucheng.cmis.pub.digester.DWord;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DExecutor {
    private static int DIGESTER_TYPE_L2R = 1;
    private static int DIGESTER_TYPE_R2L = 2;
    private static int MAX_SEGMENT_SIZE = 120;
    private static char[] splitChar = new char[]{' ', ',', ';', ':', '\uff1a', '\uff0c', '\u3002', '\uff1b', '?', '-', '_', '!', '\uff1f', '\uff01', '\"', '\'', '\uff08', '\uff09', '(', ')', '[', ']', '{', '}', '<', '>', '\u300a', '\u300b'};

    public static List<DWord> doSplit(String segment) {
        ArrayList<DWord> result = new ArrayList<DWord>();
        List<String> subSegList = DExecutor.splitSegment2Sub(segment);
        if (subSegList != null) {
            for (String sub : subSegList) {
                int WdSize2;
                if (sub == null || sub.trim().equals("")) continue;
                List<DWord> subResult = null;
                List<DWord> subResult1 = DExecutor.doSplitSubSegment1(sub);
                List<DWord> subResult2 = DExecutor.doSplitSubSegment2(sub);
                int dicWddSize1 = DExecutor.checkDictWordSize(subResult1);
                int dicWddSize2 = DExecutor.checkDictWordSize(subResult2);
                int WdSize1 = subResult1.size();
                subResult = WdSize1 > (WdSize2 = subResult2.size()) ? subResult2 : (WdSize1 == WdSize2 ? (dicWddSize1 >= dicWddSize2 ? subResult1 : subResult2) : subResult1);
                if (subResult == null || subResult.size() <= 0) continue;
                result.addAll(subResult);
            }
        }
        return result;
    }

    private static int checkDictWordSize(List<DWord> wordList) {
        int dicWordSize = 0;
        if (wordList != null) {
            for (DWord dw : wordList) {
                if (!dw.isInDictInd()) continue;
                ++dicWordSize;
            }
        }
        return dicWordSize;
    }

    public static List<DWord> doSplitSubSegment1(String segment) {
        ArrayList<DWord> result = new ArrayList<DWord>();
        if (segment == null || segment.trim().equals("")) {
            return result;
        }
        if (segment.length() <= 2) {
            DWord word = new DWord(segment);
            String type = DDict.get(segment);
            if (type != null) {
                word.setWordType(type);
                word.setInDictInd(true);
            }
            result.add(word);
            return result;
        }
        if (segment.length() > MAX_SEGMENT_SIZE) {
            throw new RuntimeException("Surpass max segment lenght " + MAX_SEGMENT_SIZE);
        }
        int currentIdx = 0;
        int noDictStrIdx = -1;
        String _seg = segment;
        do {
            String _word = null;
            _word = DExecutor.getCheckWord(_seg, DDict.WORD_MAX_LEN, DIGESTER_TYPE_L2R);
            DWord dw = DExecutor.findAtDict(_word, DIGESTER_TYPE_L2R);
            if (dw == null) {
                dw = DExecutor.findAtNumber(_word, DIGESTER_TYPE_L2R);
            }
            if (dw != null) {
                if (noDictStrIdx != -1) {
                    String _wordnotindict = segment.substring(noDictStrIdx, currentIdx);
                    result.add(new DWord(_wordnotindict, noDictStrIdx));
                    noDictStrIdx = -1;
                }
                dw.setPosition(currentIdx);
                result.add(dw);
                currentIdx += dw.getLength();
            } else {
                if (noDictStrIdx == -1) {
                    noDictStrIdx = currentIdx;
                }
                ++currentIdx;
            }
            if (currentIdx <= 0) continue;
            _seg = segment.substring(currentIdx);
        } while (_seg.length() > 0);
        if (noDictStrIdx != -1) {
            String _wordnotindict = segment.substring(noDictStrIdx, segment.length());
            result.add(new DWord(_wordnotindict, noDictStrIdx));
            noDictStrIdx = -1;
        }
        return result;
    }

    public static List<DWord> doSplitSubSegment2(String segment) {
        ArrayList<DWord> result = new ArrayList<DWord>();
        if (segment == null || segment.trim().equals("")) {
            return result;
        }
        if (segment.length() <= 2) {
            DWord word = new DWord(segment);
            String type = DDict.get(segment);
            if (type != null) {
                word.setWordType(type);
                word.setInDictInd(true);
            }
            result.add(0, word);
            return result;
        }
        if (segment.length() > MAX_SEGMENT_SIZE) {
            throw new RuntimeException("Surpass max segment lenght " + MAX_SEGMENT_SIZE);
        }
        int currentIdx = segment.length();
        int noDictStrIdx = -1;
        String _seg = segment;
        do {
            String _word = null;
            _word = DExecutor.getCheckWord(_seg, DDict.WORD_MAX_LEN, DIGESTER_TYPE_R2L);
            DWord dw = DExecutor.findAtDict(_word, DIGESTER_TYPE_R2L);
            if (dw == null) {
                dw = DExecutor.findAtNumber(_word, DIGESTER_TYPE_R2L);
            }
            if (dw != null) {
                if (noDictStrIdx != -1) {
                    String _wordnotindict = segment.substring(currentIdx, noDictStrIdx);
                    result.add(0, new DWord(_wordnotindict, noDictStrIdx));
                    noDictStrIdx = -1;
                }
                dw.setPosition(currentIdx);
                result.add(0, dw);
                currentIdx -= dw.getLength();
            } else {
                if (noDictStrIdx == -1) {
                    noDictStrIdx = currentIdx;
                }
                --currentIdx;
            }
            if (currentIdx <= 0) continue;
            _seg = segment.substring(0, currentIdx);
        } while (_seg.length() > 0 && currentIdx > 0);
        if (noDictStrIdx != -1) {
            String _wordnotindict = segment.substring(0, noDictStrIdx);
            result.add(0, new DWord(_wordnotindict, noDictStrIdx));
            noDictStrIdx = -1;
        }
        return result;
    }

    public static String getCheckWord(String segment, int length, int ditype) {
        if (segment != null && !segment.trim().equals("")) {
            if (segment.length() >= length && length > 0) {
                if (ditype == DIGESTER_TYPE_L2R) {
                    return segment.substring(0, length);
                }
                if (ditype == DIGESTER_TYPE_R2L) {
                    return segment.substring(segment.length() - length, segment.length());
                }
                System.err.println("UNKNOW DISTYPE :" + ditype);
                EMPLog.log((String)"DICT", (int)EMPLog.ERROR, (int)0, (String)("UNKNOW DISTYPE :" + ditype));
            } else {
                return segment;
            }
        }
        return null;
    }

    public static List<String> splitSegment2Sub(String segment) {
        ArrayList<String> result = null;
        if (segment == null) {
            return null;
        }
        result = new ArrayList<String>();
        int segLen = segment.length();
        StringBuffer subSeg = new StringBuffer();
        int n = 0;
        while (n < segLen) {
            char aChar = segment.charAt(n);
            if (DExecutor.isSplitChar(aChar)) {
                if (subSeg != null && subSeg.length() > 0) {
                    result.add(subSeg.toString());
                    subSeg.delete(0, subSeg.length());
                }
            } else {
                subSeg.append(aChar);
            }
            ++n;
        }
        if (subSeg.length() > 0) {
            result.add(subSeg.toString());
        }
        return result;
    }

    private static boolean isSplitChar(char aChar) {
        boolean isSC = false;
        char[] cArray = splitChar;
        int n = splitChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == aChar) {
                isSC = true;
                break;
            }
            ++n2;
        }
        return isSC;
    }

    public static DWord findAtDict(String word, int ditype) {
        String type = DDict.get(word);
        if (type != null) {
            DWord dw = new DWord(word);
            dw.setWordType(type);
            dw.setInDictInd(true);
            return dw;
        }
        if (word.length() > 0) {
            if (ditype == DIGESTER_TYPE_L2R) {
                word = word.substring(0, word.length() - 1);
            } else if (ditype == DIGESTER_TYPE_R2L) {
                word = word.substring(1, word.length());
            } else {
                EMPLog.log((String)"DICT", (int)EMPLog.ERROR, (int)0, (String)("UNKNOW DISTYPE :" + ditype));
            }
            return DExecutor.findAtDict(word, ditype);
        }
        return null;
    }

    public static DWord findAtNumber(String word, int ditype) {
        DWord _numWord = null;
        String _num = null;
        int len = word.length();
        if (ditype == DIGESTER_TYPE_L2R) {
            int n = 0;
            while (n < len) {
                char chr = word.charAt(n);
                if (!(chr >= '0' && chr <= '9' || n == 0 && chr == '-' || chr == '.')) {
                    if (n > 0) {
                        _num = word.substring(0, n);
                        try {
                            Double.parseDouble(_num);
                            _numWord = new DWord(_num);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    break;
                }
                ++n;
            }
        } else if (ditype == DIGESTER_TYPE_R2L) {
            int n = len - 1;
            while (n >= 0) {
                char chr = word.charAt(n);
                if (chr < '0' || chr > '9') {
                    if (n < len - 1) {
                        _num = word.substring(n + 1, len);
                        try {
                            Double.parseDouble(_num);
                            _numWord = new DWord(_num);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    break;
                }
                --n;
            }
        } else {
            EMPLog.log((String)"DICT", (int)EMPLog.ERROR, (int)0, (String)("UNKNOW DISTYPE :" + ditype));
        }
        return _numWord;
    }
}

