/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.dic;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.pub.dic.CMISDataDicMapService;
import com.yucheng.cmis.pub.util.CMISPropertyManager;
import com.yucheng.cmis.pub.util.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;

public class CMISDataDicService
extends EMPService {
    public static String ATTR_ENNAME = "enname";
    public static String ATTR_CNNAME = "cnname";
    public static String OP_UPDATE = "update";
    public static String OP_DELETE = "delete";
    private String enNameColumn = "enname";
    private String cnNameColumn = "cnname";
    private String typeColumn = "opttype";
    private String orderByColumn = "orderid";
    private String tableName = "S_DIC";
    private String instuCdeColumn;
    private String conditionCol = " 1=1 ";
    private List dataDicMaps;
    private int MAX_DIC_NUMBER = 999999;

    public void loadDicData(Context context, Connection connection) throws Exception {
        String useCacheDB = CMISDaoPropertyManager.getInstance().getPropertyValue("cachedb.dict.enabled");
        String maxDicNumberStr = CMISPropertyManager.getInstance().getPropertyValue("dic.max.number");
        if (maxDicNumberStr != null && !"".equals(maxDicNumberStr)) {
            this.MAX_DIC_NUMBER = Integer.parseInt(maxDicNumberStr);
            if (this.MAX_DIC_NUMBER < 0) {
                this.MAX_DIC_NUMBER = 999999;
            }
        }
        KeyedCollection dictColl = null;
        try {
            dictColl = (KeyedCollection)context.getDataElement("dictColl");
            dictColl.clear();
        }
        catch (ObjectNotFoundException e) {
            dictColl = new KeyedCollection();
            dictColl.setName("dictColl");
            context.addDataElement((DataElement)dictColl);
        }
        String sqlStr = null;
        String selectSql = null;
        String whereSql = null;
        String orderBySql = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            try {
                HashMap cacheMap = new HashMap();
                state = connection.createStatement();
                selectSql = this.instuCdeColumn == null ? "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.typeColumn + " from " + this.tableName : "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.typeColumn + "," + this.instuCdeColumn + " from " + this.tableName;
                whereSql = " where " + this.conditionCol;
                orderBySql = this.orderByColumn != null ? " order by " + this.orderByColumn + " , " + this.enNameColumn : " order by " + this.enNameColumn;
                sqlStr = String.valueOf(selectSql) + whereSql + orderBySql;
                rs = state.executeQuery(sqlStr);
                while (rs.next()) {
                    KeyedCollection kColl;
                    String enName = rs.getString(1);
                    String cnName = rs.getString(2);
                    String type = rs.getString(3);
                    String instuCde = null;
                    if (this.instuCdeColumn != null) {
                        instuCde = rs.getString(4);
                    }
                    if (instuCde != null && !"#FFFFFF".equals(instuCde.trim())) {
                        type = String.valueOf(type) + "@" + instuCde;
                    }
                    if (type.indexOf(".") != -1) {
                        type = type.replace('.', '_');
                    }
                    if (useCacheDB != null && "1".equals(useCacheDB)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(ATTR_ENNAME, enName);
                        map.put(ATTR_CNNAME, cnName);
                        JSONObject toStrJSON = JSONObject.fromObject(map);
                        List list = null;
                        if (cacheMap.containsKey("dictColl:" + type)) {
                            list = (List)cacheMap.get("dictColl:" + type);
                        } else {
                            list = new ArrayList();
                            cacheMap.put("dictColl:" + type, list);
                        }
                        if (this.MAX_DIC_NUMBER > list.size()) {
                            ((List)cacheMap.get("dictColl:" + type)).add(toStrJSON.toString());
                            continue;
                        }
                        if (this.MAX_DIC_NUMBER != list.size()) continue;
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("\u5b57\u5178\u7c7b\u578b" + type + "\u7684\u5b57\u5178\u9879\u6570\u91cf\u5df2\u7ecf\u8fbe\u5230\u8bbe\u7f6e\u4e0a\u9650\uff08" + this.MAX_DIC_NUMBER + "\u4e2a\uff09\uff0c\u8d85\u51fa\u90e8\u5206\u5c06\u4e0d\u518d\u6dfb\u5165\u5b57\u5178\u9879\uff01\uff01\uff01"));
                        continue;
                    }
                    IndexedCollection iColl = null;
                    if (dictColl.containsKey((Object)type)) {
                        iColl = (IndexedCollection)dictColl.getDataElement(type);
                    } else {
                        iColl = new IndexedCollection();
                        iColl.setName(type);
                        dictColl.addDataElement((DataElement)iColl);
                        kColl = new KeyedCollection();
                        kColl.addDataField(ATTR_ENNAME, null);
                        kColl.addDataField(ATTR_CNNAME, null);
                        iColl.setDataElement((DataElement)kColl);
                    }
                    if (this.MAX_DIC_NUMBER > iColl.size()) {
                        kColl = (KeyedCollection)iColl.getDataElement().clone();
                        kColl.setName(enName);
                        kColl.setDataValue(ATTR_ENNAME, (Object)enName);
                        kColl.setDataValue(ATTR_CNNAME, (Object)cnName);
                        iColl.addDataElement((DataElement)kColl);
                        continue;
                    }
                    if (this.MAX_DIC_NUMBER != iColl.size()) continue;
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("\u5b57\u5178\u7c7b\u578b" + type + "\u7684\u5b57\u5178\u9879\u6570\u91cf\u5df2\u7ecf\u8d85\u51fa\u8bbe\u7f6e\u4e0a\u9650\uff08" + this.MAX_DIC_NUMBER + "\u4e2a\uff09\uff0c\u8d85\u51fa\u90e8\u5206\u5c06\u4e0d\u518d\u6dfb\u5165\u5b57\u5178\u9879\uff01\uff01\uff01"));
                }
                rs.close();
                rs = null;
                state.close();
                state = null;
                if (useCacheDB != null && "1".equals(useCacheDB)) {
                    CacheClient.deleteByKey((String)"dictColl:");
                    CacheClient.setMultiList(cacheMap);
                }
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("The DataDicService occur an error:" + e.getMessage()));
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.dataDicMaps != null && this.dataDicMaps.size() > 0) {
            int i = 0;
            while (i < this.dataDicMaps.size()) {
                CMISDataDicMapService service = (CMISDataDicMapService)((Object)this.dataDicMaps.get(i));
                service.loadDicData(dictColl, connection);
                ++i;
            }
        }
    }

    public void reloadSingleDic(String op, String comTyp, String comCde, String comDesc, Context rootCtx) throws Exception {
        KeyedCollection dictColl = null;
        try {
            IndexedCollection dictTypIColl;
            dictColl = (KeyedCollection)rootCtx.getDataElement("dictColl");
            if (dictColl == null) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u672a\u627e\u5230\u7f13\u5b58\u5b57\u5178\u9879\uff0c\u65e0\u6cd5\u4fee\u6539\u7f13\u5b58\u5b57\u5178\u9879\uff01");
                return;
            }
            if (OP_DELETE.equals(op)) {
                if (StringUtil.isStrNull((String)comTyp)) {
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u4f20\u5165COM_TYP\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4fee\u6539\u7f13\u5b58\u5b57\u5178\u9879\uff01");
                    return;
                }
                if (StringUtil.isStrNull((String)comCde)) {
                    dictColl.remove((Object)comTyp);
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u6210\u529f\u5220\u9664COM_TYP\u4e3a\uff1a" + comTyp + "\u7684\u6574\u4e2a\u5b57\u5178\u9879\uff01"));
                } else if (dictColl.containsKey((Object)comTyp)) {
                    dictTypIColl = (IndexedCollection)dictColl.getDataElement(comTyp);
                    for (Object obj : dictTypIColl) {
                        if (!comCde.equals(((KeyedCollection)obj).get((Object)ATTR_ENNAME))) continue;
                        dictTypIColl.remove(obj);
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u6210\u529f\u5220\u9664COM_TYP\u4e3a" + comTyp + "\uff0cCOM_CDE\u4e3a" + comCde + "\u7684\u5355\u4e2a\u5b57\u5178\u9879\uff01"));
                    }
                }
            }
            if (OP_UPDATE.equals(op)) {
                KeyedCollection comCdeKColl;
                if (StringUtil.isStrNull((String)comTyp)) {
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u4f20\u5165COM_TYP\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4fee\u6539\u7f13\u5b58\u5b57\u5178\u9879\uff01");
                    return;
                }
                if (dictColl.containsKey((Object)comTyp)) {
                    dictTypIColl = (IndexedCollection)dictColl.getDataElement(comTyp);
                    if (StringUtil.isStrNull((String)comCde)) {
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u4f20\u5165COM_CDE\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4fee\u6539\u7f13\u5b58\u5355\u4e2a\u5b57\u5178\u9879\uff01");
                        return;
                    }
                    if (StringUtil.isStrNull((String)comDesc)) {
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u4f20\u5165COM_DESC\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4fee\u6539\u7f13\u5b58\u5355\u4e2a\u5b57\u5178\u9879\uff01");
                        return;
                    }
                    comCdeKColl = null;
                    for (Object obj : dictTypIColl) {
                        if (!comCde.equals(((KeyedCollection)obj).get((Object)ATTR_ENNAME))) continue;
                        comCdeKColl = (KeyedCollection)obj;
                        break;
                    }
                    if (comCdeKColl == null) {
                        comCdeKColl = new KeyedCollection();
                        comCdeKColl.setName(comCde);
                        comCdeKColl.addDataField(ATTR_ENNAME, (Object)comCde);
                        comCdeKColl.addDataField(ATTR_CNNAME, (Object)comDesc);
                        dictTypIColl.add(comCdeKColl);
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u6210\u529f\u65b0\u589eCOM_TYP\u4e3a" + comTyp + ",COM_CDE\u4e3a" + comCde + "\u7684\u5355\u4e2a\u5b57\u5178\u9879\uff01"));
                    } else {
                        comCdeKColl.put((Object)ATTR_CNNAME, (Object)comDesc);
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u6210\u529f\u4fee\u6539COM_TYP\u4e3a" + comTyp + ",COM_CDE\u4e3a" + comCde + "\u7684\u5355\u4e2a\u5b57\u5178\u9879\uff01"));
                    }
                } else {
                    if (StringUtil.isStrNull((String)comTyp) || StringUtil.isStrNull((String)comCde) || StringUtil.isStrNull((String)comDesc)) {
                        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u5b58\u5728\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u65b0\u589e\u6574\u4e2a\u5b57\u5178\u9879\u5931\u8d25\uff01");
                        return;
                    }
                    dictTypIColl = new IndexedCollection();
                    dictTypIColl.setName(comTyp);
                    comCdeKColl = new KeyedCollection();
                    comCdeKColl.setName(comCde);
                    comCdeKColl.addDataField(ATTR_ENNAME, (Object)comCde);
                    comCdeKColl.addDataField(ATTR_CNNAME, (Object)comDesc);
                    dictTypIColl.add(comCdeKColl);
                    dictColl.addDataField(comTyp, (Object)dictTypIColl);
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u6210\u529f\u65b0\u589eCOM_TYP\u4e3a" + comTyp + ",COM_CDE\u4e3a" + comCde + "\u7684\u6574\u4e2a\u5b57\u5178\u9879\uff01"));
                }
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("\u4fee\u6539\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    public void reloadDicByTableName(String tableName, Context context, Connection connection) throws Exception {
        KeyedCollection dictColl = null;
        if (StringUtil.isStrNull((String)tableName)) {
            return;
        }
        try {
            dictColl = (KeyedCollection)context.getDataElement("dictColl");
        }
        catch (ObjectNotFoundException e) {
            dictColl = new KeyedCollection();
            dictColl.setName("dictColl");
            context.addDataElement((DataElement)dictColl);
        }
        if (this.dataDicMaps != null && this.dataDicMaps.size() > 0) {
            int i = 0;
            while (i < this.dataDicMaps.size()) {
                CMISDataDicMapService service = (CMISDataDicMapService)((Object)this.dataDicMaps.get(i));
                if (tableName.equals(service.getTableName())) {
                    if (dictColl.containsKey((Object)service.getType())) {
                        dictColl.remove((Object)service.getType());
                    }
                    service.loadDicData(dictColl, connection);
                }
                ++i;
            }
        }
    }

    public void reloadDicByType(String typ, Context context, Connection connection) throws Exception {
        KeyedCollection dictColl = null;
        if (StringUtil.isStrNull((String)typ)) {
            return;
        }
        try {
            dictColl = (KeyedCollection)context.getDataElement("dictColl");
        }
        catch (ObjectNotFoundException e) {
            dictColl = new KeyedCollection();
            dictColl.setName("dictColl");
            context.addDataElement((DataElement)dictColl);
        }
        if (this.dataDicMaps != null && this.dataDicMaps.size() > 0) {
            int i = 0;
            while (i < this.dataDicMaps.size()) {
                CMISDataDicMapService service = (CMISDataDicMapService)((Object)this.dataDicMaps.get(i));
                if (typ.equals(service.getType())) {
                    if (dictColl.containsKey((Object)service.getType())) {
                        dictColl.remove((Object)service.getType());
                    }
                    service.loadDicData(dictColl, connection);
                }
                ++i;
            }
        }
    }

    public List getDataDicMaps() {
        return this.dataDicMaps;
    }

    public void setDataDicMaps(List dataDicMaps) {
        this.dataDicMaps = dataDicMaps;
    }

    public void addCMISDataDicMapService(CMISDataDicMapService service) {
        if (this.dataDicMaps == null) {
            this.dataDicMaps = new ArrayList();
        }
        this.dataDicMaps.add(service);
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getTypeColumn() {
        return this.typeColumn;
    }

    public void setTypeColumn(String typeColumn) {
        this.typeColumn = typeColumn;
    }

    public String getConditionCol() {
        return this.conditionCol;
    }

    public void setConditionCol(String conditionCol) {
        this.conditionCol = conditionCol;
    }

    public String getInstuCdeColumn() {
        return this.instuCdeColumn;
    }

    public void setInstuCdeColumn(String instuCdeColumn) {
        this.instuCdeColumn = instuCdeColumn;
    }
}

