/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.dic;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.pub.dic.CMISDataDicService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;

public class CMISDataDicMapService
extends EMPService {
    private String enNameColumn;
    private String cnNameColumn;
    private String tableName;
    private String instuCdeColumn;
    private String type;
    private String orderByColumn;
    private String conditionCol = " 1=1 ";

    protected void loadDicData(KeyedCollection dictColl, Connection connection) throws Exception {
        String useCacheDB = CMISDaoPropertyManager.getInstance().getPropertyValue("cachedb.dict.enabled");
        if (this.type == null) {
            throw new EMPException("the type can not be null in service named[" + this.getName() + "].");
        }
        String sqlStr = null;
        String selectSql = null;
        String whereSql = null;
        String orderBySql = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            try {
                HashMap cacheMap = new HashMap();
                state = connection.createStatement();
                selectSql = this.instuCdeColumn != null ? "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.instuCdeColumn + " from " + this.tableName : "select " + this.enNameColumn + "," + this.cnNameColumn + " from " + this.tableName;
                whereSql = " where " + this.conditionCol;
                orderBySql = this.orderByColumn != null ? " order by " + this.orderByColumn + " , " + this.enNameColumn : " order by " + this.enNameColumn;
                sqlStr = String.valueOf(selectSql) + whereSql + orderBySql;
                rs = state.executeQuery(sqlStr);
                while (rs.next()) {
                    KeyedCollection kColl;
                    String enName = rs.getString(1);
                    String cnName = rs.getString(2);
                    String instuCde = null;
                    if (this.instuCdeColumn != null) {
                        instuCde = rs.getString(3);
                    }
                    String type = this.type;
                    if (instuCde != null && !"#FFFFFF".equals(instuCde.trim())) {
                        type = String.valueOf(this.type) + "@" + instuCde;
                    }
                    if (type.indexOf(".") != -1) {
                        type = type.replace('.', '_');
                    }
                    if (useCacheDB != null && "1".equals(useCacheDB)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(CMISDataDicService.ATTR_ENNAME, enName);
                        map.put(CMISDataDicService.ATTR_CNNAME, cnName);
                        JSONObject toStrJSON = JSONObject.fromObject(map);
                        List list = (List)cacheMap.get("dictColl:" + type);
                        if (list == null) {
                            cacheMap.put("dictColl:" + type, new ArrayList());
                        }
                        ((List)cacheMap.get("dictColl:" + type)).add(toStrJSON.toString());
                        continue;
                    }
                    IndexedCollection iColl = null;
                    if (dictColl.containsKey((Object)type)) {
                        iColl = (IndexedCollection)dictColl.getDataElement(type);
                    } else {
                        iColl = new IndexedCollection();
                        iColl.setName(type);
                        dictColl.addDataElement((DataElement)iColl);
                        kColl = new KeyedCollection();
                        kColl.addDataField(CMISDataDicService.ATTR_ENNAME, null);
                        kColl.addDataField(CMISDataDicService.ATTR_CNNAME, null);
                        iColl.setDataElement((DataElement)kColl);
                    }
                    kColl = (KeyedCollection)iColl.getDataElement().clone();
                    kColl.setName(enName);
                    kColl.setDataValue(CMISDataDicService.ATTR_ENNAME, (Object)enName);
                    kColl.setDataValue(CMISDataDicService.ATTR_CNNAME, (Object)cnName);
                    iColl.addDataElement((DataElement)kColl);
                }
                rs.close();
                rs = null;
                state.close();
                state = null;
                if (useCacheDB != null && "1".equals(useCacheDB)) {
                    CacheClient.deleteByKey((String)"dictColl:");
                    CacheClient.setMultiList(cacheMap);
                }
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("The DataDicService occur an error:" + e.getMessage()));
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getConditionCol() {
        return this.conditionCol;
    }

    public void setConditionCol(String conditionCol) {
        this.conditionCol = conditionCol;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getInstuCdeColumn() {
        return this.instuCdeColumn;
    }

    public void setInstuCdeColumn(String instuCdeColumn) {
        this.instuCdeColumn = instuCdeColumn;
    }
}

