/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.yucheng.cmis.pub.CMISDao;
import com.yucheng.cmis.pub.exception.AgentException;
import com.yucheng.cmis.pub.exception.DaoException;
import com.yucheng.cmis.pub.util.CMISPropertyManager;
import com.yucheng.cmis.pub.util.ResourceUtils;
import com.yucheng.cmis.pub.util.XMLFileUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CMISDaoFactory {
    private static CMISDaoFactory instance = new CMISDaoFactory();
    private static HashMap daoTable = new HashMap();
    public static final String CONFIGKEY_MODULEID = "moduleid";
    public static final String CONFIGKEY_CLASSNAME = "classname";
    public static final String CONFIGKEY_DESCRIBE = "describe";

    public static void init() throws DaoException {
        try {
            XMLFileUtil xmlFileUtil = new XMLFileUtil();
            String dir = CMISPropertyManager.getInstance().getDaoConfigFileDir();
            if (dir.startsWith("classpath:")) {
                String resourcePath = dir.substring("classpath:".length());
                List resourceFiles = ResourceUtils.scanResourceFiles((String)resourcePath, (String)".xml");
                ArrayList<URL> resources = new ArrayList<URL>();
                for (String resUrl : resourceFiles) {
                    resources.add(ResourceUtils.getClassLoader().getResource(resUrl));
                }
                daoTable = (HashMap)xmlFileUtil.readDaoFromFromResources(resources);
            } else {
                String DAO_CONFIG_FILM_DIR = ResourceUtils.getFile((String)dir).getAbsolutePath();
                daoTable = (HashMap)xmlFileUtil.readDaoFromXMLFile(DAO_CONFIG_FILM_DIR);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                throw new AgentException("999999", ex.getMessage());
            }
            catch (AgentException e) {
                e.printStackTrace();
            }
        }
    }

    public CMISDao getDaoInstance(String comId) throws DaoException {
        if (daoTable == null || daoTable.size() <= 0) {
            throw new DaoException("\u4e1a\u52a1\u7ec4\u4ef6\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getdaoInstance\u65b9\u6cd5");
        }
        if (comId == null || comId.trim().equals("")) {
            throw new DaoException("\u4e1a\u52a1\u7ec4\u4ef6\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
        }
        CMISDao dao = null;
        try {
            String st_describe;
            String st_classname;
            HashMap daoCfg = (HashMap)daoTable.get(comId);
            if (daoCfg != null && daoCfg.size() > 0) {
                st_classname = (String)daoCfg.get(CONFIGKEY_CLASSNAME);
                st_describe = (String)daoCfg.get(CONFIGKEY_DESCRIBE);
                if (st_classname == null || st_classname.trim().equals("")) {
                    throw new DaoException("\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
                }
            } else {
                throw new DaoException("\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            dao = (CMISDao)Class.forName(st_classname).newInstance();
            dao.setId(comId);
            dao.setDescribe(st_describe);
            dao.setParameter(daoCfg);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new DaoException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new DaoException("\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new DaoException("\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
        }
        return dao;
    }

    public static CMISDaoFactory getDaoFactoryInstance() {
        if (instance != null) {
            return instance;
        }
        return new CMISDaoFactory();
    }
}

