/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.paramprovider;

import com.ecc.emp.core.EMPException;
import com.yucheng.cmis.paramprovider.CMISParamProvider;
import com.yucheng.cmis.paramprovider.CMISParamProviderItem;
import java.util.HashMap;

public class CMISParamProviderService
implements CMISParamProvider {
    private HashMap paramCaches;

    public void addCMISParam(String paramId, String paramName, String paramValue, String defaultValue) {
        CMISParamProviderItem item = new CMISParamProviderItem();
        item.setId(paramId);
        item.setName(paramName);
        item.setValue(paramValue);
        item.setDefaultValue(defaultValue);
        if (this.paramCaches == null) {
            this.paramCaches = new HashMap();
        }
        this.paramCaches.put(paramId, item);
    }

    public String getValue(String paramId) {
        if (this.paramCaches == null) {
            return null;
        }
        CMISParamProviderItem item = (CMISParamProviderItem)this.paramCaches.get(paramId);
        if (item == null) {
            return null;
        }
        String value = item.getValue();
        if (value == null) {
            return item.getDefaultValue();
        }
        return value;
    }

    public void updateValue(String paramId, String paramValue) {
        if (this.paramCaches == null) {
            return;
        }
        CMISParamProviderItem item = (CMISParamProviderItem)this.paramCaches.get(paramId);
        if (item != null) {
            item.setValue(paramValue);
        }
    }

    public void addCMISParam(CMISParamProviderItem item) {
        if (this.paramCaches == null) {
            this.paramCaches = new HashMap();
        }
        this.paramCaches.put(item.getId(), item);
    }

    public CMISParamProviderItem getCMISParam(String paramId) {
        if (this.paramCaches == null) {
            return null;
        }
        return (CMISParamProviderItem)this.paramCaches.get(paramId);
    }

    public void initParamCache(Object obj) throws EMPException {
    }
}

