/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.session;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.CacheClient;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Jedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisEMPSessionUtil {
    public static final String KEY_PREX = "SID_";

    public static Long setSession(String sessionId) {
        Long hset = null;
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                hset = cli.hset(RedisEMPSessionUtil.getSessionKey(sessionId), "_SID_", sessionId);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
        return hset;
    }

    public static void setTimeOut(String sessionId, long timeOut) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.pexpire(RedisEMPSessionUtil.getSessionKey(sessionId), timeOut);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
    }

    public static boolean existsSession(String sessionId) {
        boolean success = false;
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                Boolean exists = cli.exists(RedisEMPSessionUtil.getSessionKey(sessionId));
                if (exists != null && exists.booleanValue()) {
                    success = true;
                }
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
        return success;
    }

    public static long ttlSession(String sessionId) {
        Long ttl;
        block8: {
            ttl = null;
            Jedis cli = null;
            try {
                try {
                    cli = RedisEMPSessionUtil.getConnection();
                    ttl = cli.ttl(sessionId);
                }
                catch (Exception e) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                    if (cli != null) {
                        cli.close();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (cli != null) {
                    cli.close();
                }
                throw throwable;
            }
            if (cli != null) {
                cli.close();
            }
        }
        return ttl;
    }

    public static void setSessionAttr(String sessionId, String subKey, String val) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.hset(RedisEMPSessionUtil.getSessionKey(sessionId), subKey, val);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
    }

    public static String getSessionAttr(String sessionId, String subKey) {
        Jedis cli = null;
        String attr = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                attr = cli.hget(RedisEMPSessionUtil.getSessionKey(sessionId), subKey);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
        return attr;
    }

    public static void removeSessionAttr(String sessionId, String subKey) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.hdel(RedisEMPSessionUtil.getSessionKey(sessionId), new String[]{subKey});
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
    }

    public static Map<String, String> getSessionAttrs(String sessionId) {
        Jedis cli = null;
        HashMap<String, String> attrs = new HashMap();
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                attrs = cli.hgetAll(RedisEMPSessionUtil.getSessionKey(sessionId));
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                if (cli != null) {
                    cli.close();
                }
            }
        }
        finally {
            if (cli != null) {
                cli.close();
            }
        }
        return attrs;
    }

    private static String getSessionKey(String sessionId) {
        return KEY_PREX + sessionId;
    }

    private static Jedis getConnection() {
        Jedis jedis = (Jedis)CacheClient.getConnection();
        return jedis;
    }
}

