/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.view.AbstractView;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.util.CMISJSONUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONExtView
extends AbstractView {
    private KeyedCollection output;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String jspRootPath) {
        try {
            Context context = (Context)model.get(EMPConstance.ATTR_CONTEXT);
            KeyedCollection outputKColl = this.output;
            if (outputKColl == null) {
                outputKColl = (KeyedCollection)context.getDataElement();
            }
            StringBuffer buffer = new StringBuffer();
            Object[] dataNames = outputKColl.keySet().toArray();
            buffer.append("{");
            for (int i = 0; i < dataNames.length; ++i) {
                DataElement dataElement;
                String dataName = dataNames[i].toString();
                if ("_ServletRequest".equalsIgnoreCase(dataName) || !((dataElement = outputKColl.getDataElement(dataName)) instanceof DataField)) continue;
                DataField field = (DataField)context.getDataElement(dataElement.getName());
                this.getDataFieldJson(field, buffer);
                if (i >= dataNames.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("}");
            System.out.println(buffer.toString());
            response.addHeader("Cache-Control", "no-cache");
            response.getOutputStream().write(buffer.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to return the jsonView!", (Throwable)e);
        }
    }

    public void getDataFieldJson(DataField field, StringBuffer buffer) throws Exception {
        buffer.append("\"" + field.getName() + "\":");
        Object value = field.getValue();
        if (value != null) {
            String className = value.getClass().getName();
            if (JSONExtView.isBasicDataType(className)) {
                buffer.append("\"" + CMISJSONUtil.normalizeString(value.toString()) + "\"");
            } else if (value instanceof List) {
                List objectList = (List)value;
                buffer.append("[");
                if (objectList != null && objectList.size() > 0) {
                    for (int i = 0; i < objectList.size(); ++i) {
                        Object dataField = objectList.get(i);
                        if (!(dataField instanceof CMISDomain)) continue;
                        buffer.append("{");
                        CMISDomain dd = (CMISDomain)dataField;
                        Object[] names = dd.getDataMap().keySet().toArray();
                        for (int k = 0; k < names.length; ++k) {
                            String name = names[k].toString();
                            Object fieldValue = dd.getDataMap().get(name);
                            buffer.append("\"" + name + "\":");
                            if (fieldValue != null) {
                                buffer.append("\"" + CMISJSONUtil.normalizeString(fieldValue.toString()) + "\"");
                            } else {
                                buffer.append("\"\"");
                            }
                            if (k >= names.length - 1) continue;
                            buffer.append(",");
                        }
                        buffer.append("}");
                        if (i >= objectList.size() - 1) continue;
                        buffer.append(",");
                    }
                }
                buffer.append("]");
            } else if (value instanceof CMISDomain) {
                buffer.append("{");
                CMISDomain dd = (CMISDomain)value;
                Object[] names = dd.getDataMap().keySet().toArray();
                for (int k = 0; k < names.length; ++k) {
                    String name = names[k].toString();
                    Object fieldValue = dd.getDataMap().get(name);
                    buffer.append("\"" + name + "\":");
                    if (fieldValue != null) {
                        buffer.append("\"" + CMISJSONUtil.normalizeString(fieldValue.toString()) + "\"");
                    } else {
                        buffer.append("\"\"");
                    }
                    if (k >= names.length - 1) continue;
                    buffer.append(",");
                }
                buffer.append("}");
            }
        } else {
            buffer.append("\"\"");
        }
    }

    private static boolean isBasicDataType(String Classname) {
        return Classname.equals("java.lang.Double") || Classname.equals("java.lang.Integer") || Classname.equals("java.lang.Float") || Classname.equals("java.lang.String") || Classname.equals("java.math.BigDecimal") || Classname.equals("java.lang.Boolean");
    }
}

