/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.view.AbstractView;
import com.yucheng.cmis.view.excel.ExcelColumn;
import com.yucheng.cmis.view.excel.ExcelSheet;
import com.yucheng.cmis.view.excel.ExcelWorkbook;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTempletJSONView
extends AbstractView {
    private String fileName;
    private short headFont = (short)700;
    private short bodyFont = 0;
    private int maxColSize = 8000;
    private ExcelWorkbook excelWorkbook;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String rootPath) {
        try {
            this.writeExcelByPOI(request, response, rootPath);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to return the excelView!", (Throwable)e);
        }
    }

    public void writeExcelByPOI(HttpServletRequest request, HttpServletResponse response, String rootPath) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        List excelSheets = this.excelWorkbook.getExcelSheets();
        for (int i = 0; i < excelSheets.size(); ++i) {
            ExcelSheet excelSheet = (ExcelSheet)excelSheets.get(i);
            HSSFSheet sheet = workbook.createSheet(excelSheet.getName());
            HSSFFont fontHead = workbook.createFont();
            fontHead.setBoldweight(this.headFont);
            fontHead.setBoldweight((short)700);
            fontHead.setFontHeightInPoints((short)11);
            fontHead.setColor((short)9);
            HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
            cellStyleTitle.setFont(fontHead);
            cellStyleTitle.setFillPattern((short)1);
            cellStyleTitle.setFillForegroundColor((short)55);
            cellStyleTitle.setAlignment((short)2);
            cellStyleTitle.setVerticalAlignment((short)6);
            List excelColumns = excelSheet.getExcelColumns();
            int[] columnsLen = new int[excelColumns.size()];
            boolean isTitle = excelSheet.isTitle();
            if (!isTitle) continue;
            HSSFRow row1 = sheet.createRow(0);
            HSSFRow row2 = sheet.createRow(1);
            row2.setHeight((short)450);
            for (int k = 0; k < excelColumns.size(); ++k) {
                ExcelColumn excelColumn = (ExcelColumn)excelColumns.get(k);
                HSSFCell cell1 = row1.createCell(k);
                HSSFCell cell2 = row2.createCell(k);
                StringBuilder sb = new StringBuilder("{dataName='");
                sb.append(excelColumn.dataName + "',name='");
                sb.append(excelColumn.name + "',dictName='");
                sb.append(excelColumn.dictName + "'}");
                String cell1Value = sb.toString();
                cell1.setCellType(1);
                cell1.setCellValue(cell1Value);
                cell2.setCellStyle(cellStyleTitle);
                cell2.setCellType(1);
                cell2.setCellValue(excelColumn.name);
                int relLen = this.getLength(excelColumn.name);
                if (relLen < this.maxColSize) {
                    sheet.setColumnWidth(k, relLen);
                    columnsLen[k] = relLen;
                    continue;
                }
                sheet.setColumnWidth(k, this.maxColSize);
                columnsLen[k] = this.maxColSize;
            }
            row1.setZeroHeight(true);
        }
        String fileName = this.excelWorkbook.getFileName();
        String contentType = "application/msexcel";
        response.setContentType(contentType);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        ServletOutputStream servletOS = response.getOutputStream();
        workbook.write((OutputStream)servletOS);
        servletOS.flush();
        servletOS.close();
        response.flushBuffer();
    }

    private final int getLength(String str) {
        int defAddLenA = 300;
        int defAddLenB = 500;
        if (str == null) {
            return 4;
        }
        int zhCount = 0;
        int retLength = 0;
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] < '\u4e00' || charArray[i] > '\u9fbb') continue;
            ++zhCount;
        }
        retLength = str.length() * defAddLenA + zhCount * defAddLenB;
        return retLength;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ExcelWorkbook getExcelWorkbook() {
        return this.excelWorkbook;
    }

    public void setExcelWorkbook(ExcelWorkbook excelWorkbook) {
        this.excelWorkbook = excelWorkbook;
    }

    public short getBodyFont() {
        return this.bodyFont;
    }

    public void setBodyFont(short bodyFont) {
        this.bodyFont = bodyFont;
    }

    public short getHeadFont() {
        return this.headFont;
    }

    public void setHeadFont(short headFont) {
        this.headFont = headFont;
    }
}

