/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.view.AbstractView;
import com.yucheng.cmis.util.CMISJSONUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EXTJSONView
extends AbstractView {
    private KeyedCollection output;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String jspRootPath) {
        try {
            Context context = (Context)model.get(EMPConstance.ATTR_CONTEXT);
            KeyedCollection outputKColl = this.output;
            if (outputKColl == null) {
                outputKColl = (KeyedCollection)context.getDataElement();
            }
            StringBuffer buffer = new StringBuffer();
            Object[] dataNames = outputKColl.keySet().toArray();
            buffer.append("{");
            for (int i = 0; i < dataNames.length; ++i) {
                String dataName = dataNames[i].toString();
                DataElement dataElement = outputKColl.getDataElement(dataName);
                if (dataElement instanceof DataField) {
                    DataField field = (DataField)context.getDataElement(dataElement.getName());
                    this.getDataFieldStr(field, buffer);
                } else if (dataElement instanceof IndexedCollection) {
                    IndexedCollection iColl = (IndexedCollection)dataElement;
                    String iCollName = iColl.getName();
                    IndexedCollection sIColl = (IndexedCollection)context.getDataElement(iCollName);
                    this.getIndexedCollectionStr(iColl, sIColl, buffer);
                } else if (dataElement instanceof KeyedCollection) {
                    KeyedCollection kColl = (KeyedCollection)dataElement;
                    KeyedCollection sKColl = (KeyedCollection)context.getDataElement(dataElement.getName());
                    this.getKeyedCollectionStr(kColl, sKColl, false, buffer);
                }
                if (i >= dataNames.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("}");
            response.addHeader("Cache-Control", "no-cache");
            response.getOutputStream().write(buffer.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to return the jsonView!", (Throwable)e);
        }
    }

    private void getKeyedCollectionStr(KeyedCollection outputKColl, KeyedCollection sKColl, boolean isArray, StringBuffer buffer) throws Exception {
        if (sKColl.getName() != null && sKColl.getName().length() > 0 && !isArray) {
            if (sKColl.getName().equals("pageInfo")) {
                buffer.append("\"totalCount\":").append("\"" + (String)sKColl.getDataValue("recordSize") + "\"");
                return;
            }
        } else {
            buffer.append("{");
        }
        if (outputKColl.size() == 0) {
            outputKColl = sKColl;
        }
        Object[] names = outputKColl.keySet().toArray();
        for (int k = 0; k < names.length; ++k) {
            String name = names[k].toString();
            DataElement element = outputKColl.getDataElement(name);
            if (element instanceof DataField) {
                DataField field = (DataField)sKColl.getDataElement(name);
                this.getDataFieldStr(field, buffer);
            } else if (element instanceof IndexedCollection) {
                IndexedCollection iColl = (IndexedCollection)sKColl.getDataElement(name);
                this.getIndexedCollectionStr((IndexedCollection)element, iColl, buffer);
            } else if (element instanceof KeyedCollection) {
                KeyedCollection kColl = (KeyedCollection)sKColl.getDataElement(name);
                this.getKeyedCollectionStr((KeyedCollection)element, kColl, false, buffer);
            }
            if (k >= names.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("}");
    }

    private void getDataFieldStr(DataField field, StringBuffer buffer) throws Exception {
        buffer.append("\"" + field.getName() + "\":");
        Object value = field.getValue();
        if (value != null) {
            buffer.append("\"" + CMISJSONUtil.normalizeString(value.toString()) + "\"");
        } else {
            buffer.append("null");
        }
    }

    private void getIndexedCollectionStr(IndexedCollection outputIColl, IndexedCollection iColl, StringBuffer buffer) throws Exception {
        buffer.append("\"topics\":[");
        KeyedCollection outputKColl = (KeyedCollection)outputIColl.getDataElement();
        if (outputKColl == null) {
            outputKColl = (KeyedCollection)iColl.getDataElement();
        }
        if (iColl != null) {
            for (int i = 0; i < iColl.size(); ++i) {
                KeyedCollection sKColl = (KeyedCollection)iColl.get(i);
                this.getKeyedCollectionStr(outputKColl, sKColl, true, buffer);
                if (i >= iColl.size() - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append("]");
    }

    public KeyedCollection getOutput() {
        return this.output;
    }

    public void setOutput(KeyedCollection output) {
        this.output = output;
    }
}

