/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.digester;

import java.math.BigDecimal;

public class DWord {
    public static final String WORD_TYPE_ADDRESS_1 = "0040";
    public static final String WORD_TYPE_ADDRESS_2 = "0080";
    public static final String WORD_TYPE_ADDRESS_3 = "6000";
    public static final int WORD_EQUAL_TYPE_NONE = 0;
    public static final int WORD_EQUAL_TYPE_WHOLE = 1;
    public static final int WORD_EQUAL_TYPE_PREFIX = 2;
    public static final int WORD_EQUAL_TYPE_SUFFIX = 3;
    public static final int WORD_EQUAL_TYPE_PART = 4;
    private String word = null;
    private String wordType = "";
    private int position = 0;
    private boolean inDictInd = false;
    private double matchRate = 100.0;

    public DWord(String word) {
        this.word = word;
    }

    public DWord(String word, int position) {
        this.word = word;
        this.position = position;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getWordType() {
        if (this.wordType != null) {
            this.wordType = this.wordType.trim();
        }
        return this.wordType;
    }

    public void setWordType(String wordType) {
        this.wordType = wordType;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isInDictInd() {
        return this.inDictInd;
    }

    public void setInDictInd(boolean inDictInd) {
        this.inDictInd = inDictInd;
    }

    public int getLength() {
        if (this.word != null) {
            return this.word.length();
        }
        return 0;
    }

    public boolean isNumber() {
        if (this.word != null && !this.word.trim().equals("")) {
            boolean isNumber = false;
            int i = this.word.length();
            while (--i >= 0) {
                char chr = this.word.charAt(i);
                if (chr >= '0' && chr <= '9' || i == 0 && chr == '-' || chr == '.') {
                    isNumber = true;
                    continue;
                }
                isNumber = false;
                break;
            }
            return isNumber;
        }
        return false;
    }

    public int equals(DWord obj) {
        int result = 0;
        this.matchRate = 0.0;
        if (obj != null && this.getWord() != null && !this.getWord().trim().equals("")) {
            if (!obj.isNumber()) {
                if (this.getWord().equals(obj.getWord())) {
                    this.matchRate = 100.0;
                    result = 1;
                } else {
                    int sLen = this.getWord().length();
                    int oLen = obj.getWord().length();
                    this.matchRate = 1.0 - new BigDecimal(Math.abs(sLen - oLen)).divide(new BigDecimal(sLen > oLen ? sLen : oLen), 3, 0).doubleValue();
                    result = this.getWord().startsWith(obj.getWord()) || obj.getWord().startsWith(this.getWord()) ? (this.wordType != null && (this.wordType.equals(WORD_TYPE_ADDRESS_1) || this.wordType.equals(WORD_TYPE_ADDRESS_2) || this.wordType.equals(WORD_TYPE_ADDRESS_3)) && (obj.getWordType().equals(WORD_TYPE_ADDRESS_1) || obj.getWordType().equals(WORD_TYPE_ADDRESS_2) || obj.getWordType().equals(WORD_TYPE_ADDRESS_3)) ? (this.matchRate > 0.65 ? 1 : 0) : 2) : (this.getWord().endsWith(obj.getWord()) || obj.getWord().endsWith(this.getWord()) ? 3 : (this.getWord().indexOf(obj.getWord()) > 0 || obj.getWord().indexOf(this.getWord()) > 0 ? 4 : 0));
                }
            } else if (this.getWord().equals(obj.getWord())) {
                this.matchRate = 100.0;
                result = 1;
            } else {
                this.matchRate = 0.0;
                result = 0;
            }
        } else {
            System.err.println("\u539f\u5355\u8bcd\u6216\u76ee\u6807\u5355\u8bcd\u4e3a\u7a7a\uff0c\u8ba4\u4e3a\u4e0d\u5339\u914d");
            this.matchRate = 0.0;
            result = 0;
        }
        return result;
    }

    public double getMatchRate() {
        return this.matchRate;
    }

    public double getMatchRate(DWord obj) {
        this.equals(obj);
        return this.matchRate;
    }

    public String toString() {
        return this.word;
    }
}

