/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.digester;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.pub.digester.DExecutor;
import com.yucheng.cmis.pub.digester.DWord;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMatcher {
    public static final int MATCH_USE_TYPE_COMMON = 0;
    public static final int MATCH_USE_TYPE_CORPNAME = 1;
    public static final int MATCH_USE_TYPE_ADDRESS = 2;
    private static double ADDITION_SCORE_NOKEY = 5.0;
    private static double ADDITION_SCORE_CONTINUE = 2.0;

    public static double doMatch(String src, String obj, int mtype) {
        String _src = null;
        String _obj = null;
        if (src == null || src.trim().equals("") || obj == null || obj.trim().equals("")) {
            EMPLog.log((String)"DICT", (int)EMPLog.WARNING, (int)0, (String)"doMatch param is null");
            return -9999.0;
        }
        if (src.length() > obj.length()) {
            _src = obj;
            _obj = src;
        } else {
            _src = src;
            _obj = obj;
        }
        List<DWord> resultLst1 = DExecutor.doSplit(DMatcher.filter(_src));
        List<DWord> resultLst2 = DExecutor.doSplit(DMatcher.filter(_obj));
        return DMatcher.doMatch(resultLst1, resultLst2, mtype);
    }

    public static double doMatch(List<DWord> src, List<DWord> obj, int mtype) {
        int i;
        if (src == null || src.size() <= 0) {
            EMPLog.log((String)"DICT", (int)EMPLog.WARNING, (int)0, (String)"doMatch param src is null");
            return 0.0;
        }
        if (obj == null || obj.size() <= 0) {
            EMPLog.log((String)"DICT", (int)EMPLog.WARNING, (int)0, (String)"doMatch param obj is null");
            return 0.0;
        }
        double result = 0.0;
        double srcSize = src.size();
        double objSize = obj.size();
        double standard = 0.0;
        standard = new BigDecimal(100.0).divide(new BigDecimal(objSize), 3, 0).doubleValue();
        ArrayList<Integer> matchIdxLst = new ArrayList<Integer>();
        ArrayList<Integer> matchWholeIdxLst = new ArrayList<Integer>();
        ArrayList<Integer> matchPrefixIdxLst = new ArrayList<Integer>();
        ArrayList<Double> matchPrefixRateLst = new ArrayList<Double>();
        ArrayList<Integer> matchSuffixIdxLst = new ArrayList<Integer>();
        ArrayList<Double> matchSuffixRateLst = new ArrayList<Double>();
        ArrayList<Integer> matchPartIdxLst = new ArrayList<Integer>();
        ArrayList<Double> matchPartRateLst = new ArrayList<Double>();
        ArrayList<Integer> matchSrcNoneIdxLst = new ArrayList<Integer>();
        ArrayList<Integer> matchSrcIdxLst = new ArrayList<Integer>();
        ArrayList<Integer> matchObjNoneIdxLst = new ArrayList<Integer>();
        int sIdx = 0;
        for (DWord s : src) {
            if (s != null && s.getWord() != null) {
                boolean isMatched = false;
                int oIdx = 0;
                for (DWord o : obj) {
                    boolean isAlreadyMatch = false;
                    for (Integer i2 : matchWholeIdxLst) {
                        if (i2 != oIdx) continue;
                        isAlreadyMatch = true;
                        break;
                    }
                    if (isAlreadyMatch) {
                        ++oIdx;
                        continue;
                    }
                    int equalType = s.equals(o);
                    if (equalType == 1) {
                        isMatched = true;
                        matchIdxLst.add(oIdx);
                        matchWholeIdxLst.add(oIdx);
                        break;
                    }
                    if (equalType == 2) {
                        isMatched = true;
                        matchIdxLst.add(oIdx);
                        matchPrefixIdxLst.add(oIdx);
                        matchPrefixRateLst.add(s.getMatchRate());
                        break;
                    }
                    if (equalType == 3) {
                        isMatched = true;
                        matchIdxLst.add(oIdx);
                        matchSuffixIdxLst.add(oIdx);
                        matchSuffixRateLst.add(s.getMatchRate());
                        break;
                    }
                    if (equalType == 4) {
                        isMatched = true;
                        matchIdxLst.add(oIdx);
                        matchPartIdxLst.add(oIdx);
                        matchPartRateLst.add(s.getMatchRate());
                        break;
                    }
                    ++oIdx;
                }
                if (!isMatched) {
                    matchSrcNoneIdxLst.add(sIdx);
                } else {
                    matchSrcIdxLst.add(sIdx);
                }
            }
            ++sIdx;
        }
        int n = 0;
        while ((double)n < objSize) {
            boolean matched = false;
            for (Integer mIdx : matchIdxLst) {
                if (mIdx != n) continue;
                matched = true;
                break;
            }
            if (!matched) {
                matchObjNoneIdxLst.add(n);
            }
            ++n;
        }
        for (i = 0; i < matchWholeIdxLst.size(); ++i) {
            result += standard;
            int idx = (Integer)matchWholeIdxLst.get(i);
            if (obj.get(idx).isInDictInd()) continue;
            result += ADDITION_SCORE_NOKEY;
        }
        for (i = 0; i < matchPrefixIdxLst.size(); ++i) {
            double rate = (Double)matchPrefixRateLst.get(i) * 1.08;
            int idx = (Integer)matchPrefixIdxLst.get(i);
            result += standard * rate;
            if (obj.get(idx).isInDictInd()) continue;
            result += ADDITION_SCORE_NOKEY * rate;
        }
        for (i = 0; i < matchSuffixIdxLst.size(); ++i) {
            double rate = (Double)matchSuffixRateLst.get(i) * 1.03;
            result += standard * rate;
            int idx = (Integer)matchSuffixIdxLst.get(i);
            if (obj.get(idx).isInDictInd()) continue;
            result += ADDITION_SCORE_NOKEY * rate;
        }
        for (i = 0; i < matchPartIdxLst.size(); ++i) {
            double rate = (Double)matchPartRateLst.get(i);
            result += standard * rate;
            int idx = (Integer)matchPartIdxLst.get(i);
            if (obj.get(idx).isInDictInd()) continue;
            result += ADDITION_SCORE_NOKEY * rate;
        }
        for (i = 0; i < matchSrcNoneIdxLst.size(); ++i) {
            result -= standard * 1.5;
            int idx = (Integer)matchSrcNoneIdxLst.get(i);
            if (src.get(idx).isInDictInd()) continue;
            result -= ADDITION_SCORE_NOKEY * 2.0;
        }
        for (i = 0; i < matchObjNoneIdxLst.size(); ++i) {
            int idx = (Integer)matchObjNoneIdxLst.get(i);
            if (obj.get(idx).isInDictInd()) continue;
            result -= ADDITION_SCORE_NOKEY;
        }
        if (mtype == 2) {
            if (objSize > srcSize) {
                int srchaveAddress1 = 0;
                int srchaveAddress2 = 0;
                for (int n2 = 0; n2 < matchIdxLst.size(); ++n2) {
                    String wtype;
                    int cur = (Integer)matchIdxLst.get(n2);
                    int last = 0;
                    if (n2 > 0 && cur - (last = ((Integer)matchIdxLst.get(n2 - 1)).intValue()) != 1 && cur - last > 1) {
                        result -= ADDITION_SCORE_CONTINUE * (double)(cur - last);
                    }
                    if ((wtype = obj.get(cur).getWordType()) != null && wtype.equals("0040")) {
                        ++srchaveAddress1;
                    } else if (wtype != null && wtype.equals("0080")) {
                        ++srchaveAddress2;
                    }
                    if (!(result > 100.0)) continue;
                    result = 100.0;
                }
                int objHaveAddress1 = 0;
                int objHaveAddress2 = 0;
                for (DWord _objWord : obj) {
                    String wtype = _objWord.getWordType();
                    if (wtype != null && wtype.equals("0040")) {
                        ++objHaveAddress1;
                        continue;
                    }
                    if (wtype == null || !wtype.equals("0080")) continue;
                    ++objHaveAddress2;
                }
                if (objHaveAddress1 > 0 && srchaveAddress1 <= 0) {
                    result -= standard * 0.3;
                }
                if (objHaveAddress2 > 0 && srchaveAddress2 <= 0) {
                    result -= ADDITION_SCORE_NOKEY * 10.0;
                }
            }
            for (i = 0; i < matchObjNoneIdxLst.size(); ++i) {
                int idx = (Integer)matchObjNoneIdxLst.get(i);
                if (obj.get(idx).isInDictInd()) continue;
                result -= ADDITION_SCORE_NOKEY * (double)(idx < 4 ? 4 : (idx < 5 ? idx : 5));
            }
        } else if (mtype == 1) {
            for (i = 0; i < obj.size(); ++i) {
                DWord word = obj.get(i);
                if (word == null || word.isInDictInd()) continue;
                boolean isMatched = false;
                for (Integer idx : matchWholeIdxLst) {
                    if (idx != i) continue;
                    isMatched = true;
                    result += ADDITION_SCORE_NOKEY;
                }
                if (isMatched) continue;
                result -= ADDITION_SCORE_NOKEY * 10.0;
            }
        } else if (mtype == 0) {
            return result;
        }
        return result;
    }

    private static String filter(String seg) {
        return seg;
    }
}

