/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.digester;

import com.ecc.emp.log.EMPLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class DDict {
    private static HashMap<String, String> keyDict = null;
    private static final String ENCODING = "UTF-8";
    public static int WORD_MAX_LEN = 8;
    public static final int WORD_MIN_LEN = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String dictFileName) {
        long star = System.currentTimeMillis();
        File dictFile = new File(dictFileName);
        if (!dictFile.exists() || !dictFile.isFile()) {
            keyDict = new HashMap();
            EMPLog.log((String)"DICT", (int)EMPLog.ERROR, (int)0, (String)("dict file " + dictFileName + " is not exist!"));
            return;
        }
        keyDict = new HashMap(8192, 0.99f);
        BufferedReader br = null;
        InputStreamReader in = null;
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(dictFile);
            in = new InputStreamReader((InputStream)fi, ENCODING);
            br = new BufferedReader(in);
            int maxLen = 0;
            int maxLenAtLine = 0;
            int n = 0;
            String line = null;
            while ((line = br.readLine()) != null) {
                ++n;
                int idx = line.indexOf("|");
                if (idx > 0) {
                    String word = line.substring(0, idx).trim();
                    String wordType = line.substring(idx + 1, line.indexOf("|", idx + 1));
                    if (keyDict.containsKey(word)) {
                        EMPLog.log((String)"DICT", (int)EMPLog.INFO, (int)0, (String)("Duplicate key :" + word + " at " + n));
                    }
                    keyDict.put(word, wordType);
                    if (idx <= maxLen) continue;
                    maxLen = idx;
                    maxLenAtLine = n;
                    continue;
                }
                if (n <= 1) continue;
                EMPLog.log((String)"DICT", (int)EMPLog.INFO, (int)0, (String)("null row at " + n));
            }
            if (maxLen > WORD_MAX_LEN) {
                EMPLog.log((String)"DICT", (int)EMPLog.WARNING, (int)0, (String)("the Word size supass max length(" + WORD_MAX_LEN + ") , System will be adjust WORD_MAX_LEN automatically!"));
                WORD_MAX_LEN = maxLen;
            }
            EMPLog.log((String)"DICT", (int)EMPLog.INFO, (int)0, (String)("Load dict use " + (System.currentTimeMillis() - star) + "ms, size of dict is " + keyDict.size() + " maxLen " + maxLen + " at " + maxLenAtLine));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(String word) {
        return keyDict.get(word);
    }

    public static boolean contains(String word) {
        return keyDict.containsKey(word);
    }
}

