/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.dic;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.pub.dic.CMISTreeDicNode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class CMISTreeDicService
extends EMPService {
    private String enNameColumn = "enname";
    private String cnNameColumn = "cnname";
    private String parentColumn = "abven_name";
    private String typeColumn = "opt_type";
    private String locateColumn = "locate";
    private String levelColumn = "levels";
    private String orderByColumn = "order_id";
    private String tableName = "s_tree_dic";
    private String displaySeparator = "->";
    private HashMap treeCache = new HashMap();
    private HashMap treeNodeCache = new HashMap();

    /*
     * Loose catch block
     */
    public void loadDicData(Context context, Connection connection) throws Exception {
        block22: {
            SQLException e22;
            ResultSet rs;
            Statement state;
            block21: {
                String sqlStr = null;
                state = null;
                rs = null;
                this.treeCache.clear();
                this.treeNodeCache.clear();
                state = connection.createStatement();
                sqlStr = "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.parentColumn + "," + this.locateColumn + "," + this.typeColumn + "," + this.orderByColumn + " from " + this.tableName + " order by " + this.locateColumn;
                rs = state.executeQuery(sqlStr);
                while (rs.next()) {
                    CMISTreeDicNode node;
                    String enName = rs.getString(1);
                    String cnName = rs.getString(2);
                    String parentId = rs.getString(3);
                    String locate = rs.getString(4);
                    String type = rs.getString(5);
                    String orderId = rs.getString(6);
                    if (locate == null || "".equals(locate)) continue;
                    HashMap<String, CMISTreeDicNode> nodeCache = (HashMap<String, CMISTreeDicNode>)this.treeNodeCache.get(type);
                    if (nodeCache == null) {
                        nodeCache = new HashMap<String, CMISTreeDicNode>();
                        this.treeNodeCache.put(type, nodeCache);
                    }
                    if ((node = (CMISTreeDicNode)nodeCache.get(enName)) != null) {
                        node.cnName = cnName;
                        node.orderId = orderId;
                        node.locate = locate;
                        continue;
                    }
                    node = new CMISTreeDicNode();
                    node.enName = enName;
                    node.cnName = cnName;
                    node.orderId = orderId;
                    node.locate = locate;
                    nodeCache.put(enName, node);
                    if (parentId == null || "".equals(parentId) || " ".equals(parentId)) {
                        this.treeCache.put(type, node);
                        continue;
                    }
                    CMISTreeDicNode parent = (CMISTreeDicNode)nodeCache.get(parentId);
                    if (parent != null) {
                        parent.addChild(node);
                        continue;
                    }
                    String[] paths = locate.split(",");
                    CMISTreeDicNode pNode = null;
                    for (int i = 0; i < paths.length - 1; ++i) {
                        String path = paths[i];
                        if (path == null || "".equals(path)) continue;
                        if (pNode == null) {
                            pNode = (CMISTreeDicNode)this.treeCache.get(type);
                            if (pNode != null) continue;
                            pNode = new CMISTreeDicNode();
                            pNode.enName = path;
                            nodeCache.put(path, pNode);
                            this.treeCache.put(type, pNode);
                            continue;
                        }
                        CMISTreeDicNode child = pNode.getChild(path);
                        if (child == null) {
                            child = new CMISTreeDicNode();
                            child.enName = path;
                            pNode.addChild(child);
                            nodeCache.put(path, child);
                        }
                        pNode = child;
                    }
                    if (pNode == null) continue;
                    pNode.addChild(node);
                }
                rs.close();
                rs = null;
                state.close();
                state = null;
                Object var20_20 = null;
                if (rs == null) break block21;
                try {
                    rs.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException e22) {}
            }
            break block22;
            {
                catch (Exception e3) {
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("The DataDicService occur an error:" + e3.getMessage()));
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var20_21 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (state != null) {
                    try {
                        state.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public String toJsonStringByType(String type, boolean dynamic) {
        CMISTreeDicNode node = (CMISTreeDicNode)this.treeCache.get(type);
        return this.toJsonString(node, dynamic);
    }

    public String toJsonStringById(String type, String nodeId, boolean dynamic) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        return this.toJsonString(node, dynamic);
    }

    public String toJsonString(CMISTreeDicNode node, boolean dynamic) {
        if (node == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{id:\"").append(node.enName).append("\"");
        buf.append(",label:\"").append(node.cnName).append("\"");
        buf.append(",dynamic:\"").append(dynamic).append("\"");
        if (node.locate != null && node.locate.length() > 0) {
            buf.append(",locate:\"").append(node.locate).append("\"");
        }
        if (node.childs != null && node.childs.size() > 0) {
            buf.append(",leaf:\"").append(false).append("\"");
            buf.append(",children:[");
            for (int i = 0; i < node.childs.size(); ++i) {
                CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
                this.getSubTreeJsonString(buf, child, dynamic);
                if (i >= node.childs.size() - 1) continue;
                buf.append(",");
            }
            buf.append("]");
        } else {
            buf.append(",leaf:\"").append(true).append("\"");
        }
        buf.append("}");
        return buf.toString();
    }

    public String toChildrenJsonStringById(String type, String nodeId) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        if (node == null || node.childs == null || node.childs.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < node.childs.size(); ++i) {
            CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
            buf.append("{id:\"").append(child.enName).append("\"");
            buf.append(",label:\"").append(child.cnName).append("\"");
            buf.append(",dynamic:\"").append(true).append("\"");
            if (child.locate != null && child.locate.length() > 0) {
                buf.append(",locate:\"").append(child.locate).append("\"");
            }
            if (child.childs != null && child.childs.size() > 0) {
                buf.append(",leaf:\"").append(false).append("\"");
            } else {
                buf.append(",leaf:\"").append(true).append("\"");
            }
            buf.append("}");
            if (i >= node.childs.size() - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    private void getSubTreeJsonString(StringBuffer buf, CMISTreeDicNode node, boolean dynamic) {
        buf.append("{id:\"").append(node.enName).append("\"");
        buf.append(",label:\"").append(node.cnName).append("\"");
        buf.append(",dynamic:\"").append(dynamic).append("\"");
        if (node.locate != null && node.locate.length() > 0) {
            buf.append(",locate:\"").append(node.locate).append("\"");
        }
        if (node.childs != null && node.childs.size() > 0) {
            buf.append(",leaf:\"").append(false).append("\"");
            if (!dynamic) {
                buf.append(",children:[");
                for (int i = 0; i < node.childs.size(); ++i) {
                    CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
                    this.getSubTreeJsonString(buf, child, true);
                    if (i >= node.childs.size() - 1) continue;
                    buf.append(",");
                }
                buf.append("]");
            }
        } else {
            buf.append(",leaf:\"").append(true).append("\"");
        }
        buf.append("}");
    }

    public CMISTreeDicNode getTree(String type) {
        CMISTreeDicNode node = (CMISTreeDicNode)this.treeCache.get(type);
        return node;
    }

    public CMISTreeDicNode getNode(String type, String nodeId) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        return node;
    }

    public String getDecoratedValue(String type, String nodeId) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        list.add(node.cnName);
        while (node.parent != null) {
            node = node.parent;
            list.add(node.cnName);
        }
        for (int i = list.size(); i > 0; --i) {
            if (i != 1) {
                buffer.append(list.get(i - 1)).append(this.displaySeparator);
                continue;
            }
            buffer.append(list.get(1));
        }
        return buffer.toString();
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getDisplaySeparator() {
        return this.displaySeparator;
    }

    public void setDisplaySeparator(String displaySeparator) {
        this.displaySeparator = displaySeparator;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getLevelColumn() {
        return this.levelColumn;
    }

    public void setLevelColumn(String levelColumn) {
        this.levelColumn = levelColumn;
    }

    public String getLocateColumn() {
        return this.locateColumn;
    }

    public void setLocateColumn(String locateColumn) {
        this.locateColumn = locateColumn;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getParentColumn() {
        return this.parentColumn;
    }

    public void setParentColumn(String parentColumn) {
        this.parentColumn = parentColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTypeColumn() {
        return this.typeColumn;
    }

    public void setTypeColumn(String typeColumn) {
        this.typeColumn = typeColumn;
    }
}

