/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.dic;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DuplicatedDataNameException;
import com.yucheng.cmis.operation.CMISOperation;
import com.yucheng.cmis.pub.dic.CMISTreeDicService;

public class CMISShowTreeDic
extends CMISOperation {
    private String addressTypeName = "DQBM";
    private String organnoName = "S_distno";
    private boolean dynamic = true;

    public String doExecute(Context context) throws EMPException {
        CMISTreeDicService service = (CMISTreeDicService)((Object)context.getService("treeDicService"));
        String dicTreeTypeId = (String)context.getDataValue("dicTreeTypeId");
        String parentNodeId = null;
        try {
            parentNodeId = (String)context.getDataValue("parentNodeId");
        }
        catch (Exception e) {
            // empty catch block
        }
        String jsonStr = null;
        if (!this.dynamic || parentNodeId == null) {
            if (this.addressTypeName != null && this.addressTypeName.equals(dicTreeTypeId)) {
                String organno = (String)context.getDataValue(this.organnoName);
                jsonStr = service.toJsonStringById(dicTreeTypeId, organno, this.dynamic);
            } else {
                jsonStr = service.toJsonStringByType(dicTreeTypeId, this.dynamic);
            }
            if (jsonStr == null) {
                throw new EMPException("Can not find the dictree's json-string typeof[" + dicTreeTypeId + "]!");
            }
        } else {
            jsonStr = service.toChildrenJsonStringById(dicTreeTypeId, parentNodeId);
            if (jsonStr == null) {
                throw new EMPException("Can not find the dictree's json-string typeof[" + dicTreeTypeId + ":" + parentNodeId + "]!");
            }
        }
        try {
            context.addDataField("retJSONTreeDataName", (Object)jsonStr);
        }
        catch (DuplicatedDataNameException e) {
            context.setDataValue("retJSONTreeDataName", (Object)jsonStr);
        }
        return "0";
    }

    public String getAddressTypeName() {
        return this.addressTypeName;
    }

    public void setAddressTypeName(String addressTypeName) {
        this.addressTypeName = addressTypeName;
    }

    public String getOrgannoName() {
        return this.organnoName;
    }

    public void setOrgannoName(String organnoName) {
        this.organnoName = organnoName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }
}

