/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.datatype;

import com.ecc.emp.datatype.EMPDataType;
import com.ecc.emp.datatype.InvalidDataException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;

public class Rate4MonthType
extends EMPDataType {
    int scale = 2;
    boolean showComma = true;
    boolean isPercent = true;
    double min = -1.7976931348623157E308;
    double max = Double.MAX_VALUE;

    public Object convertFromString(String strValue, Locale locale) throws InvalidDataException {
        System.err.println("convertFromString be called ...");
        if (strValue == null || "".equals(strValue)) {
            return null;
        }
        strValue = strValue.trim();
        BigDecimal value = null;
        try {
            DecimalFormat numberformat = (DecimalFormat)DecimalFormat.getPercentInstance(locale);
            numberformat.applyPattern(numberformat.toPattern().replaceAll("%", "\u2030"));
            value = new BigDecimal(numberformat.parse(strValue).toString());
            value = value.multiply(new BigDecimal("1200"));
            BigDecimal one = new BigDecimal("1");
            value = value.divide(one, this.scale, 1);
        }
        catch (ParseException e) {
            throw new InvalidDataException((Throwable)e);
        }
        if (this.keepStringValue) {
            return value.toString();
        }
        return value;
    }

    public String getJavaTypeName() {
        return "decimal";
    }

    public String getStringValue(Object object, Locale locale) {
        System.err.println("getStringValue be called ...");
        if (object == null) {
            return "";
        }
        BigDecimal value = null;
        value = this.keepStringValue ? new BigDecimal((String)object) : (BigDecimal)object;
        BigDecimal one = new BigDecimal("1200");
        value = value.divide(one, this.scale, 1);
        DecimalFormat numberformat = (DecimalFormat)DecimalFormat.getPercentInstance(locale);
        numberformat.applyPattern(numberformat.toPattern().replaceAll("%", "\u2030"));
        numberformat.setGroupingUsed(this.showComma);
        numberformat.setMinimumFractionDigits(this.scale);
        numberformat.setMaximumFractionDigits(this.scale);
        return numberformat.format(value);
    }

    public boolean validateStringValue(String value) throws InvalidDataException {
        Locale locale = Locale.getDefault();
        return this.validateStringValue(value, locale);
    }

    public boolean validateStringValue(String value, Locale locale) throws InvalidDataException {
        if (value == null || "".equals(value)) {
            return true;
        }
        value = value.trim();
        DecimalFormat numberformat = (DecimalFormat)DecimalFormat.getPercentInstance(locale);
        if (!this.isPercent) {
            numberformat.applyPattern(numberformat.toPattern().replaceAll("%", "\u2030"));
        }
        BigDecimal tmp = null;
        try {
            tmp = new BigDecimal(numberformat.parse(value).toString());
        }
        catch (ParseException e) {
            throw new InvalidDataException((Throwable)e);
        }
        if (tmp.doubleValue() > this.max || tmp.doubleValue() < this.min) {
            throw new InvalidDataException("The value[" + value + "] must be between" + this.getMin() + " to " + this.getMax() + "!");
        }
        return true;
    }

    public boolean getIsPercent() {
        return this.isPercent;
    }

    public void setIsPercent(boolean isPercent) {
        this.isPercent = isPercent;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean getShowComma() {
        return this.showComma;
    }

    public void setShowComma(boolean showComma) {
        this.showComma = showComma;
    }
}

