/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.base;

import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.component.xml.ComponentParser;
import com.ecc.emp.component.xml.FormatParser;
import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.dbmodel.service.TableModelDAO;
import com.ecc.emp.dbmodel.service.TableModelLoader;
import com.ecc.emp.dbmodel.service.pkgenerator.PkGeneratorSet;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.Initializer;
import com.yucheng.cmis.accesscontroll.PermissionAccessController;
import com.yucheng.cmis.base.BusinessInitializer;
import com.yucheng.cmis.base.CMISComponetHelper;
import com.yucheng.cmis.message.CMISMessageManager;
import com.yucheng.cmis.pub.dic.CMISDataDicService;
import com.yucheng.cmis.pub.dic.CMISTreeDicService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;

public class CMISInitializer
implements Initializer {
    BusinessInitializer businessInitializer;

    public void initialize(EMPFlowComponentFactory factory) throws Exception {
        Context rootCtx = factory.getContextNamed(factory.getRootContextName());
        String bizRootPath = factory.getRootPath();
        String webInfPath = bizRootPath.substring(0, bizRootPath.indexOf("bizs"));
        try {
            rootCtx.addDataField("webInfPath", (Object)webInfPath);
        }
        catch (Exception e) {
            rootCtx.setDataValue("webInfPath", (Object)webInfPath);
        }
        String tableModelPath = webInfPath + "/tables/";
        TableModelLoader modelLoader = (TableModelLoader)((Object)rootCtx.getService("tableModelLoader"));
        modelLoader.initTableModels(tableModelPath);
        TableModelDAO dao = (TableModelDAO)((Object)rootCtx.getService("tableModelDAO"));
        dao.setTableModelLoader(modelLoader);
        PkGeneratorSet pkGeneratorSet = (PkGeneratorSet)rootCtx.getService("pkGeneratorSet");
        dao.setPkGeneratorSet(pkGeneratorSet);
        String messageFilePath = webInfPath + "/commons/messageManager.xml";
        CMISMessageManager.initiateMessage(messageFilePath);
        PermissionAccessController accessController = PermissionAccessController.accessController;
        if (accessController != null) {
            String accessFilePath = webInfPath + "/commons/permissionAccess.xml";
            accessController.setAccessFileName(accessFilePath);
            PermissionAccessController.initializeAccess();
        }
        CMISComponetHelper.setComponentFactory((EMPFlowComponentFactory)factory);
        DataSource dataSource = (DataSource)rootCtx.getService("dataSource");
        Connection connection = null;
        try {
            connection = ConnectionManager.getConnection((DataSource)dataSource);
            CMISDataDicService dicService = (CMISDataDicService)((Object)rootCtx.getService("dataDicService"));
            if (dicService != null) {
                dicService.loadDicData(rootCtx, connection);
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)"Initial the CMISDataDicService success!");
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.WARNING, (int)0, (String)"There is no CMISDataDicService in rootContext!");
            }
            CMISTreeDicService treeDicService = (CMISTreeDicService)((Object)rootCtx.getService("treeDicService"));
            if (treeDicService != null) {
                treeDicService.loadDicData(rootCtx, connection);
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)"Initial the CMISTreeDicService success!");
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.WARNING, (int)0, (String)"There is no CMISTreeDicService in rootContext!");
            }
            if (this.businessInitializer != null) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)"Initial the businessInitializer... ");
                this.businessInitializer.initialize(rootCtx, connection);
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)"Initial the businessInitializer success!");
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.WARNING, (int)0, (String)"There is no businessInitializer!");
            }
        }
        catch (Exception e1) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)e1.getMessage());
            throw e1;
        }
        finally {
            if (connection != null) {
                ConnectionManager.releaseConnection((DataSource)dataSource, (Connection)connection);
            }
        }
        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)"\u4ea4\u6613\u62a5\u6587\u683c\u5f0f\u914d\u7f6e\u521d\u59cb\u5316...");
        ComponentFactory formatFactory = new ComponentFactory();
        FormatParser parser = new FormatParser();
        formatFactory.setComponentParser((ComponentParser)parser);
        parser.setComponentFactory((ComponentFactory)factory);
        this.cpFormatFile(factory.getRootPath());
        String fileName = factory.getRootPath() + "newFormats.xml";
        formatFactory.initializeComponentFactory("formats", fileName);
        ComponentFactory.removeComponentFactory((String)"formats");
        try {
            Object obj = formatFactory.getRootComponent();
            if (obj instanceof Map) {
                rootCtx.setFormats((Map)obj);
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)"failed to load the format file !", (Throwable)e);
        }
    }

    public BusinessInitializer getBusinessInitializer() {
        return this.businessInitializer;
    }

    public void setBusinessInitializer(BusinessInitializer businessInitializer) {
        this.businessInitializer = businessInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean cpFormatFile(String rootpath) {
        boolean boReturn;
        block48: {
            IOException e22222222;
            BufferedWriter bWrite;
            BufferedReader bRead;
            FileWriter fWriter;
            FileReader fRead;
            block42: {
                boReturn = true;
                fRead = null;
                fWriter = null;
                bRead = null;
                bWrite = null;
                File srcFile = new File(rootpath + "formats.xml");
                File newFile = new File(rootpath + "newFormats.xml");
                fRead = new FileReader(srcFile);
                fWriter = new FileWriter(newFile);
                bRead = new BufferedReader(fRead);
                bWrite = new BufferedWriter(fWriter);
                String line = bRead.readLine();
                while (line != null) {
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.DEBUG, (int)0, (String)line);
                    if (line.trim().startsWith("<formats.xml>")) {
                        line = "<formats.xml class=\"java.util.HashMap\">";
                    }
                    bWrite.write(line);
                    bWrite.newLine();
                    line = bRead.readLine();
                }
                boReturn = true;
                Object var11_12 = null;
                if (bRead == null) break block42;
                try {
                    bRead.close();
                }
                catch (IOException e22222222) {
                    e22222222.printStackTrace();
                }
            }
            if (fRead != null) {
                try {
                    fRead.close();
                }
                catch (IOException e22222222) {
                    e22222222.printStackTrace();
                }
            }
            if (bWrite != null) {
                try {
                    bWrite.close();
                }
                catch (IOException e22222222) {
                    e22222222.printStackTrace();
                }
            }
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (IOException e22222222) {
                    e22222222.printStackTrace();
                }
            }
            break block48;
            {
                catch (FileNotFoundException e3) {
                    IOException e22222222;
                    e3.printStackTrace();
                    boReturn = false;
                    Object var11_13 = null;
                    if (bRead != null) {
                        try {
                            bRead.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (fRead != null) {
                        try {
                            fRead.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (bWrite != null) {
                        try {
                            bWrite.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (fWriter != null) {
                        try {
                            fWriter.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    break block48;
                }
                catch (IOException e4) {
                    IOException e22222222;
                    e4.printStackTrace();
                    boReturn = false;
                    Object var11_14 = null;
                    if (bRead != null) {
                        try {
                            bRead.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (fRead != null) {
                        try {
                            fRead.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (bWrite != null) {
                        try {
                            bWrite.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                    if (fWriter != null) {
                        try {
                            fWriter.close();
                        }
                        catch (IOException e22222222) {
                            e22222222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e22222222;
                Object var11_15 = null;
                if (bRead != null) {
                    try {
                        bRead.close();
                    }
                    catch (IOException e22222222) {
                        e22222222.printStackTrace();
                    }
                }
                if (fRead != null) {
                    try {
                        fRead.close();
                    }
                    catch (IOException e22222222) {
                        e22222222.printStackTrace();
                    }
                }
                if (bWrite != null) {
                    try {
                        bWrite.close();
                    }
                    catch (IOException e22222222) {
                        e22222222.printStackTrace();
                    }
                }
                if (fWriter != null) {
                    try {
                        fWriter.close();
                    }
                    catch (IOException e22222222) {
                        e22222222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return boReturn;
    }
}

