/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.base.CMISException;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.util.NewStringUtils;
import com.yucheng.cmis.pub.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHelper {
    public IndexedCollection domain2icol(List list, String modeId) throws CMISException {
        return this.domain2icol(list, modeId, "");
    }

    public IndexedCollection domain2icol(List list, String modeId, String listInd) throws CMISException {
        ArrayList arrlist = (ArrayList)list;
        IndexedCollection icol = new IndexedCollection();
        if ("listInd" == listInd) {
            icol.setName(modeId + "List");
        } else {
            icol.setName(modeId);
        }
        CMISDomain domain = null;
        KeyedCollection kcol = null;
        if (null != arrlist) {
            for (int i = 0; i < arrlist.size(); ++i) {
                if (null == arrlist.get(i) || !(arrlist.get(i) instanceof CMISDomain)) continue;
                domain = (CMISDomain)arrlist.get(i);
                kcol = this.domain2kcol(domain, modeId);
                icol.add(kcol);
            }
        }
        return icol;
    }

    public List<CMISDomain> icol2domainlist(CMISDomain domain, IndexedCollection icol) throws CMISException {
        KeyedCollection kcol = new KeyedCollection();
        ArrayList<CMISDomain> arrlist = new ArrayList<CMISDomain>();
        if (null != icol || null != domain) {
            for (int i = 0; i < icol.size(); ++i) {
                kcol = (KeyedCollection)icol.get(i);
                try {
                    domain = this.kcolTOdomain((CMISDomain)domain.getClass().newInstance(), kcol);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                arrlist.add(domain);
            }
        }
        return arrlist;
    }

    public List<CMISDomain> icol2domainlist(String className, IndexedCollection icol) throws CMISException {
        KeyedCollection kcol = new KeyedCollection();
        ArrayList<CMISDomain> arrlist = new ArrayList<CMISDomain>();
        if (null != icol) {
            for (int i = 0; i < icol.size(); ++i) {
                kcol = (KeyedCollection)icol.get(i);
                try {
                    Class<?> domainClass = Class.forName(className);
                    CMISDomain domain = (CMISDomain)domainClass.newInstance();
                    domain = this.kcolTOdomain((CMISDomain)domain.getClass().newInstance(), kcol);
                    arrlist.add(domain);
                    continue;
                }
                catch (InstantiationException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return arrlist;
    }

    public KeyedCollection domain2kcol(CMISDomain domain, String modeId) throws CMISException {
        if (domain == null || modeId == null) {
            return null;
        }
        KeyedCollection kCol = null;
        try {
            Class[] returnType = new Class[1];
            kCol = new KeyedCollection();
            kCol.setName(modeId);
            Field[] fields = domain.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                BigDecimal bvalue;
                String str = fields[i].getName();
                StringUtil.getInstance();
                String formatName = StringUtil.AddUnderlineByUppercase((String)str);
                DataField df = new DataField();
                df.setName(formatName);
                String sq = "get" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                Method md = domain.getClass().getDeclaredMethod(sq, new Class[0]);
                returnType[0] = md.getReturnType();
                if (returnType[0].getName().endsWith("String")) {
                    String svalue = (String)md.invoke((Object)domain, new Object[0]);
                    if (null == svalue) continue;
                    df.setValue(svalue);
                    kCol.addDataField(df);
                    continue;
                }
                if (returnType[0].getName().endsWith("int")) {
                    int ivalue = (Integer)md.invoke((Object)domain, new Object[0]);
                    df.setValue("" + ivalue);
                    kCol.addDataField(df);
                    continue;
                }
                if (returnType[0].getName().endsWith("double")) {
                    double dvalue = (Double)md.invoke((Object)domain, new Object[0]);
                    df.setValue("" + dvalue);
                    kCol.addDataField(df);
                    continue;
                }
                if (!returnType[0].getName().endsWith("BigDecimal") || (bvalue = (BigDecimal)md.invoke((Object)domain, new Object[0])) == null) continue;
                df.setValue("" + bvalue);
                kCol.addDataField(df);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)this.getClass().getName(), (int)EMPLog.INFO, (int)0, (String)e.toString());
            throw new CMISException((Throwable)e);
        }
        return kCol;
    }

    public CMISDomain kcolTOdomain(CMISDomain domain, KeyedCollection kCol) throws CMISException {
        if (kCol.isEmpty() || null == kCol) {
            return null;
        }
        if (domain == null) {
            return null;
        }
        Class[] returnType = new Class[1];
        Field[] fields = domain.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String str = fields[i].getName();
            StringUtil.getInstance();
            String formatName = StringUtil.AddUnderlineByUppercase((String)str);
            try {
                Method md;
                String sq;
                String sq1 = "get" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                Method md1 = domain.getClass().getDeclaredMethod(sq1, new Class[0]);
                if (md1 == null) continue;
                returnType[0] = md1.getReturnType();
                if (returnType[0].getName().endsWith("String")) {
                    sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                    md = domain.getClass().getDeclaredMethod(sq, String.class);
                    String kValue = (String)kCol.getDataValue(formatName);
                    md.invoke((Object)domain, kValue);
                    continue;
                }
                if (returnType[0].getName().endsWith("int")) {
                    sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                    md = domain.getClass().getDeclaredMethod(sq, Integer.TYPE);
                    md.invoke((Object)domain, Integer.parseInt((String)kCol.getDataValue(formatName)));
                    continue;
                }
                if (returnType[0].getName().endsWith("double")) {
                    sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                    md = domain.getClass().getDeclaredMethod(sq, Double.TYPE);
                    md.invoke((Object)domain, Double.parseDouble((String)kCol.getDataValue(formatName)));
                    continue;
                }
                if (!returnType[0].getName().endsWith("BigDecimal")) continue;
                sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                md = domain.getClass().getDeclaredMethod(sq, BigDecimal.class);
                String _val = (String)kCol.getDataValue(formatName);
                if (_val == null || _val.trim().equals("")) {
                    _val = "0";
                }
                BigDecimal bv = new BigDecimal((String)kCol.getDataValue(formatName));
                md.invoke((Object)domain, bv);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return domain;
    }

    public Object kcolTodomain(String className, KeyedCollection kCol) throws ObjectNotFoundException, InvalidArgumentException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Class<?> domainClass = Class.forName(className);
        Object domain = domainClass.newInstance();
        ArrayList<String> datanames = new ArrayList<String>();
        ArrayList<String> methodnames = new ArrayList<String>();
        HashMap<String, String> datanameMap = new HashMap<String, String>();
        HashMap<String, Method> methodnameMap = new HashMap<String, Method>();
        Iterator it = kCol.keySet().iterator();
        while (it.hasNext()) {
            String dataname = it.next().toString();
            String tmpstring = null;
            for (int t = 0; t < dataname.length(); ++t) {
                if (dataname.charAt(t) == '_') continue;
                tmpstring = tmpstring + dataname.charAt(t);
            }
            datanames.add(tmpstring.toLowerCase());
            datanameMap.put(tmpstring, dataname);
        }
        Method[] methods = domain.getClass().getDeclaredMethods();
        int j = domain.getClass().getDeclaredMethods().length;
        for (int i = 0; i < j; ++i) {
            String methodname = methods[i].getName();
            if (methodname.charAt(0) != 's') continue;
            methodname = methodname.substring(3);
            methodnames.add(methodname.toLowerCase());
            methodnameMap.put(methodname, methods[i]);
        }
        for (int k = 0; k < methodnames.size(); ++k) {
            String s1 = ((String)datanames.get(k)).toString();
            for (int l = 0; l < methodnames.size(); ++l) {
                String s2 = ((String)methodnames.get(l)).toString();
                if (!s1.equals(s2)) continue;
                String s3 = ((String)datanameMap.get(s1)).toString();
                Method tmpMethod = (Method)methodnameMap.get(s2);
                tmpMethod.invoke(domain, kCol.getDataValue(s3));
            }
        }
        return domain;
    }

    private Map<String, String> koc2Map(KeyedCollection kcol) {
        HashMap<String, String> toMap = new HashMap<String, String>();
        String key = null;
        String value = null;
        for (int i = 0; i < kcol.size(); ++i) {
            try {
                key = ((DataField)kcol.getDataElement(i)).getName();
                value = (String)((DataField)kcol.getDataElement(i)).getValue();
            }
            catch (InvalidArgumentException e) {
                // empty catch block
            }
            toMap.put(key, value);
        }
        return toMap;
    }

    private Map<String, List<Map<String, String>>> kol2Map(KeyedCollection kcol) {
        HashMap<String, List<Map<String, String>>> toMap = new HashMap<String, List<Map<String, String>>>();
        IndexedCollection icol = null;
        KeyedCollection kCol = null;
        String key = null;
        String value = null;
        ArrayList list = new ArrayList();
        String kName = kcol.getName();
        for (int m = 0; m < kcol.size(); ++m) {
            String subName = kName.substring(0, kName.length() - 1) + m;
            icol = (IndexedCollection)kcol.get((Object)subName);
            for (int i = 0; i < icol.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                kCol = (KeyedCollection)icol.get(i);
                for (int j = 0; j < kCol.size(); ++j) {
                    try {
                        key = ((DataField)kCol.getDataElement(j)).getName();
                        value = (String)((DataField)kCol.getDataElement(j)).getValue();
                    }
                    catch (InvalidArgumentException e) {
                        // empty catch block
                    }
                    map.put(key, value);
                }
                list.add(map);
            }
            toMap.put(subName, list);
        }
        return toMap;
    }

    private List<Map<String, String>> icol2List(IndexedCollection icol) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String key = null;
        String value = null;
        KeyedCollection kCol = new KeyedCollection();
        for (int i = 0; i < icol.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            kCol = (KeyedCollection)icol.get(i);
            for (int j = 0; j < kCol.size(); ++j) {
                try {
                    key = ((DataField)kCol.getDataElement(j)).getName();
                    value = (String)((DataField)kCol.getDataElement(j)).getValue();
                }
                catch (InvalidArgumentException e) {
                    // empty catch block
                }
                map.put(key, value);
            }
            list.add(map);
        }
        return list;
    }

    private Map<String, Map<String, String>> icol2Map(IndexedCollection icol) {
        HashMap<String, Map<String, String>> toMap = new HashMap<String, Map<String, String>>();
        String key = null;
        String value = null;
        String name = null;
        KeyedCollection kCol = null;
        for (int i = 0; i < icol.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            kCol = (KeyedCollection)icol.get(i);
            name = kCol.getName();
            for (int j = 0; j < kCol.size(); ++j) {
                try {
                    key = ((DataField)kCol.getDataElement(j)).getName();
                    value = (String)((DataField)kCol.getDataElement(j)).getValue();
                }
                catch (InvalidArgumentException e) {
                    // empty catch block
                }
                map.put(key, value);
            }
            toMap.put(name, map);
        }
        return toMap;
    }

    private IndexedCollection list2Icol(List list) {
        IndexedCollection icol = new IndexedCollection();
        KeyedCollection kc = null;
        DataField df = null;
        List subList = null;
        Map subMap = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                subList = (List)list.get(i);
                kc = new KeyedCollection();
                kc.setName("" + i);
                for (int j = 0; j < subList.size(); ++j) {
                    subMap = (Map)subList.get(j);
                    for (Object k : subMap.keySet()) {
                        df = new DataField();
                        df.setName((String)k);
                        df.setValue(subMap.get(k));
                        kc.addDataField(df);
                    }
                }
                icol.add(kc);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return icol;
    }

    public static int searchArr(String[] rec, String key) {
        for (int i = 0; i < rec.length; ++i) {
            if (!rec[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    public boolean isBaseType(String type) {
        boolean bool = false;
        String[] baseTypeStr = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void", "["};
        for (int i = 0; i < baseTypeStr.length; ++i) {
            if (type.indexOf(baseTypeStr[i]) == -1) continue;
            bool = true;
        }
        return bool;
    }

    public Object clone() throws CloneNotSupportedException {
        Object result = this.clone();
        return result;
    }

    public List<CMISDomain> icol2domainList4One(CMISDomain domain, IndexedCollection iCol) {
        CMISDomain tempDomain;
        List rtList = null;
        KeyedCollection tempKcol = null;
        try {
            tempDomain = (CMISDomain)domain.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        for (int i = 0; i < iCol.size(); ++i) {
            if (null == iCol.get(i) || !(iCol.get(i) instanceof KeyedCollection)) continue;
            tempKcol = (KeyedCollection)iCol.get(i);
            try {
                tempDomain = this.kcolTOdomain((CMISDomain)domain.clone(), tempKcol);
                if (null == tempDomain) continue;
                rtList.add(tempDomain);
                continue;
            }
            catch (CMISException e) {
                continue;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        return iCol;
    }

    private void fatherToChild(Object father, Object child) throws Exception {
        if (child.getClass().getSuperclass() != father.getClass()) {
            throw new Exception("child\u4e0d\u662ffather\u7684\u5b50\u7c7b");
        }
        Class<?> fatherClass = father.getClass();
        Field[] ff = fatherClass.getDeclaredFields();
        for (int i = 0; i < ff.length; ++i) {
            Field f = ff[i];
            Class<?> type = f.getType();
            Method m = fatherClass.getMethod("get" + this.upperHeadChar(f.getName()), new Class[0]);
            Object obj = m.invoke(father, new Object[0]);
            f.set(child, obj);
        }
    }

    private String upperHeadChar(String in) {
        String head = in.substring(0, 1);
        String out = head.toUpperCase() + in.substring(1, in.length());
        return out;
    }

    public String tabName2modId(String tabName) {
        String modId = "";
        String[] temp = NewStringUtils.split((String)tabName, (String)"_");
        for (int t = 0; t < temp.length; ++t) {
            modId = modId + temp[t].charAt(0) + temp[t].substring(1);
        }
        return modId;
    }

    public String modId2tabName(String modId) {
        return StringUtil.AddUnderlineByUppercase((String)modId);
    }
}

