/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.yucheng.cmis.pub.CMISModuleService;
import com.yucheng.cmis.pub.util.CMISPropertyManager;
import com.yucheng.cmis.pub.util.ResourceUtils;
import com.yucheng.cmis.pub.util.XMLFileUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public class CMISModuleServiceFactory {
    private static CMISModuleServiceFactory instance = new CMISModuleServiceFactory();
    private static Map moduleServiceMap;
    public static final String ID = "id";
    public static final String DESCRIBE = "describe";
    public static final String COMPROPERTY = "comproperty";
    public static final String CLASSNAME = "classname";
    public static final String MODULENAME = "moduleName";

    private CMISModuleServiceFactory() {
    }

    public static CMISModuleServiceFactory getInstance() {
        return instance;
    }

    public static void init() throws Exception {
        XMLFileUtil xmlFileUtil = new XMLFileUtil();
        String dir = CMISPropertyManager.getInstance().getModuleserviceConfigFileDir();
        if (dir.startsWith("classpath:")) {
            String resourcePath = dir.substring("classpath:".length());
            List resourceFiles = ResourceUtils.scanResourceFiles((String)resourcePath, (String)".xml");
            ArrayList<URL> resources = new ArrayList<URL>();
            for (String resUrl : resourceFiles) {
                resources.add(ResourceUtils.getClassLoader().getResource(resUrl));
            }
            moduleServiceMap = xmlFileUtil.readModuleServiceFromResources(resources);
        } else {
            String CONFIG_FILM_DIR = ResourceUtils.getFile((String)dir).getAbsolutePath();
            moduleServiceMap = (HashMap)xmlFileUtil.readModuleServiceFromXMLFile(CONFIG_FILM_DIR);
        }
        Set keySet = moduleServiceMap.keySet();
        System.out.println("==============" + moduleServiceMap.size());
        for (Object key : keySet) {
            System.out.println(key + " = " + moduleServiceMap.get(key));
        }
    }

    private CMISModuleService loadModuleService(String serviceId, String moduleId) throws Exception {
        CMISModuleService service = null;
        if (moduleServiceMap == null || moduleServiceMap.size() == 0) {
            return null;
        }
        if (serviceId == null || serviceId.length() <= 0) {
            return null;
        }
        Map configMap = (Map)moduleServiceMap.get(serviceId);
        if (configMap == null || configMap.size() <= 0) {
            throw new Exception("\u670d\u52a1ID\u4e3a\uff1a" + serviceId + "\u7684\u670d\u52a1\u672a\u6ce8\u518c\uff01\u8bf7\u5728src/main/com/yucheng/cmis/config/\u4e0b\u6ce8\u518c");
        }
        String id = (String)configMap.get(ID);
        String className = (String)configMap.get(CLASSNAME);
        String describe = (String)configMap.get(DESCRIBE);
        String comproperty = (String)configMap.get(COMPROPERTY);
        String moduleName = (String)configMap.get(MODULENAME);
        service = (CMISModuleService)Class.forName(className).newInstance();
        service.setModuleName(moduleName);
        service.setId(id);
        service.setDescribe(describe);
        service.setComproperty(comproperty);
        service.setClassName(className);
        return service;
    }

    public CMISModuleService getModuleServiceById(String serviceId, String moduleId) throws Exception {
        if (moduleServiceMap == null || moduleServiceMap.size() <= 0) {
            throw new Exception("Module Service\u670d\u52a1\u52a0\u8f7d\u5931\u8d25\uff01");
        }
        String value = "2";
        try {
            value = CMISPropertyManager.getInstance().getPropertyValue(moduleId);
        }
        catch (MissingResourceException e) {
            System.err.println(moduleId + "\u6a21\u5757\u672a\u8bbe\u7f6e\u662f\u5426\u4f7f\u7528\u6863\u677f\uff0c\u9ed8\u8ba4\u4e0d\u4f7f\u7528");
        }
        if (value != null && value.equals("1")) {
            return this.loadModuleService(serviceId + "Baffle", moduleId);
        }
        return this.loadModuleService(serviceId, moduleId);
    }

    public static void main(String[] args) {
        CMISModuleServiceFactory factory = instance;
        try {
            factory.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

