/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.dbmodel.service.TableModelDAO;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.pub.CMISDao;
import com.yucheng.cmis.pub.CMISDaoFactory;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.ComponentHelper;
import com.yucheng.cmis.pub.exception.AgentException;
import com.yucheng.cmis.pub.exception.ComponentException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISAgent {
    private String id;
    private String describe;
    private Context context;
    private Connection connection;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    protected Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected Connection getConnectionFromContext() throws AgentException {
        try {
            DataSource dataSource = null;
            if (this.context == null) {
                throw new EMPJDBCException("\u7cfb\u7edf\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u6ca1\u6709\u5f97\u5230Context");
            }
            if (dataSource == null) {
                dataSource = (DataSource)this.context.getService("dataSource");
            }
            if (dataSource == null) {
                throw new EMPJDBCException("dataSource is null in :" + this.toString());
            }
            this.connection = ConnectionManager.getConnection(dataSource);
            return this.connection;
        }
        catch (EMPJDBCException e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)e.toString());
            throw new AgentException("connection_error", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected TableModelDAO getTableModelDAO() {
        return (TableModelDAO)((Object)this.context.getService("tableModelDAO"));
    }

    protected void releaseConnection(Connection connection) {
        DataSource dataSource = (DataSource)this.context.getService("dataSource");
        try {
            ConnectionManager.releaseConnection((DataSource)dataSource, (Connection)connection);
        }
        catch (EMPJDBCException e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.INFO, (int)0, (String)("Do release the connection from data source: " + dataSource + " failed!"));
        }
        EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.INFO, (int)0, (String)("Do release the connection from data source: " + dataSource + " success!"));
    }

    public int insertCMISDomain(CMISDomain domain, String modeId) throws AgentException {
        int i_flag = 0;
        Connection conn = null;
        try {
            int count;
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            ComponentHelper componetHelper = new ComponentHelper();
            KeyedCollection kCol = componetHelper.domain2kcol(domain, modeId);
            i_flag = count = tDao.insert(kCol, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)this.getClass().getName(), (int)EMPLog.INFO, (int)0, (String)("\u65b0\u589e\u5931\u8d25\n" + e.toString()));
            throw new AgentException("add_error", "\u65b0\u589e\u5931\u8d25");
        }
        return i_flag;
    }

    public int modifyCMISDomain(CMISDomain domain, String modeId) throws AgentException {
        int i_flag = 0;
        Connection conn = null;
        try {
            int count;
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            ComponentHelper componetHelper = new ComponentHelper();
            KeyedCollection kCol = componetHelper.domain2kcol(domain, modeId);
            i_flag = count = tDao.update(kCol, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u4fee\u6539\u5931\u8d25\n" + e.toString()));
            throw new AgentException("update_error", "\u4fee\u6539\u5931\u8d25");
        }
        return i_flag;
    }

    public int removeCMISDomainByKeywords(String modelId, Map<String, String> pkValues) throws AgentException {
        int i_flag = 0;
        Connection conn = null;
        try {
            int count;
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            i_flag = count = tDao.deleteByPks(modelId, pkValues, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u5220\u9664\u5931\u8d25\n" + e.toString()));
            throw new AgentException("delete_error", "\u5220\u9664\u5931\u8d25");
        }
        return i_flag;
    }

    public int removeCMISDomainByKeyword(String modelId, String keyword) throws AgentException {
        int iFlag = 0;
        Connection conn = null;
        try {
            int count;
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            iFlag = count = tDao.deleteByPk(modelId, keyword, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u5220\u9664\u5931\u8d25\n" + e.toString()));
            throw new AgentException("delete_error", "\u5220\u9664\u5931\u8d25");
        }
        return iFlag;
    }

    public List<CMISDomain> findCMISDomainList4one(CMISDomain domain, String modelId) throws AgentException {
        Connection conn = null;
        List<CMISDomain> rtList = null;
        try {
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            IndexedCollection iCol = tDao.queryList(modelId, conn);
            if (iCol.isEmpty()) {
                return null;
            }
            ComponentHelper componetHelper = new ComponentHelper();
            rtList = componetHelper.icol2domainList4One(domain, iCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u67e5\u8be2\u5931\u8d25\n" + e.toString()));
            throw new AgentException("query_error", "\u67e5\u8be2\u5931\u8d25");
        }
        return rtList;
    }

    public List<CMISDomain> findCMISDomainList4one(CMISDomain domain, String modelId, List<String> columnNames) throws AgentException {
        Connection conn = null;
        List<CMISDomain> rtList = null;
        try {
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            IndexedCollection iCol = tDao.queryList(modelId, columnNames, conn);
            if (iCol.isEmpty()) {
                return null;
            }
            ComponentHelper componetHelper = new ComponentHelper();
            rtList = componetHelper.icol2domainList4One(domain, iCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u67e5\u8be2\u5931\u8d25\n" + e.toString()));
            throw new AgentException("query_error", "\u67e5\u8be2\u5931\u8d25");
        }
        return rtList;
    }

    public CMISDomain findCMISDomainByKeywords(CMISDomain domain, String modelId, Map<String, String> pk_values) throws AgentException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            KeyedCollection kCol = tDao.queryAllDetail(modelId, pk_values, conn);
            ComponentHelper componetHelper = new ComponentHelper();
            domain = componetHelper.kcolTOdomain(domain, kCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u67e5\u8be2\u5931\u8d25\n" + e.toString()));
            throw new AgentException("query_error", "\u67e5\u8be2\u5931\u8d25");
        }
        return domain;
    }

    public CMISDomain findCMISDomainByKeyword(CMISDomain domain, String modelId, String keyword) throws AgentException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            TableModelDAO tDao = this.getTableModelDAO();
            KeyedCollection kCol = tDao.queryAllDetail(modelId, keyword, conn);
            ComponentHelper componetHelper = new ComponentHelper();
            domain = componetHelper.kcolTOdomain(domain, kCol);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u67e5\u8be2\u5931\u8d25\n" + e.toString()));
            throw new AgentException("query_error", "\u67e5\u8be2\u5931\u8d25");
        }
        return domain;
    }

    protected List<CMISDomain> findListByCondition(Class<? extends CMISDomain> domainClass, String condition) throws ComponentException {
        try {
            TableModelDAO tDao = this.getTableModelDAO();
            IndexedCollection iCol = tDao.queryList(domainClass.getSimpleName(), condition, this.getConnection());
            if (iCol.isEmpty()) {
                return null;
            }
            ComponentHelper componetHelper = new ComponentHelper();
            return componetHelper.icol2domainlist(domainClass.getName(), iCol);
        }
        catch (Exception e) {
            throw new ComponentException(e);
        }
    }

    public CMISDao getDaoInstance(String agentId) throws ComponentException {
        CMISDao dao = CMISDaoFactory.getDaoFactoryInstance().getDaoInstance(agentId);
        dao.setContext(this.context);
        dao.setConnection(this.connection);
        return dao;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.class.path"));
    }
}

