/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.message;

import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.xml.ComponentParser;
import com.ecc.emp.component.xml.GeneralComponentParser;
import com.ecc.emp.component.xml.XMLDocumentLoader;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.base.CMISException;
import com.yucheng.cmis.message.CMISMessage;
import com.yucheng.cmis.message.CMISMessageGroup;
import java.text.MessageFormat;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMISMessageManager {
    protected static CMISMessageManager messageManager = null;
    protected String messageFilePath = null;
    private HashMap messageGroup = new HashMap();

    private CMISMessageManager(String messageFilePath) {
        this.messageFilePath = messageFilePath;
    }

    private void addMessageGroup(CMISMessageGroup messageGroup) {
        this.messageGroup.put(messageGroup.getId(), messageGroup);
    }

    public static void initiateMessage(String messageFilePath) {
        messageManager = new CMISMessageManager(messageFilePath);
        GeneralComponentParser parser = new GeneralComponentParser();
        ComponentFactory messageFactory = new ComponentFactory();
        messageFactory.setComponentParser((ComponentParser)parser);
        try {
            XMLDocumentLoader loader = new XMLDocumentLoader();
            Document document = loader.loadXMLDocument(messageFilePath);
            NodeList nodeList = document.getElementsByTagName("messageGroup");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object aBean;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((aBean = parser.parseTheElement(document, node)) instanceof CMISMessageGroup)) continue;
                messageManager.addMessageGroup((CMISMessageGroup)aBean);
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("An exception occured when load messageManager in file[" + messageFilePath + "]!"), (Throwable)e);
        }
    }

    public static void reloadMessage() {
        if (messageManager == null || CMISMessageManager.messageManager.messageFilePath == null) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.WARNING, (int)0, (String)"There is no exist messageManager instance!");
            return;
        }
        CMISMessageManager.initiateMessage(CMISMessageManager.messageManager.messageFilePath);
    }

    protected String getMessage(String groupId, String code) {
        if (messageManager == null) {
            return null;
        }
        CMISMessageGroup messageGroup = (CMISMessageGroup)CMISMessageManager.messageManager.messageGroup.get(groupId);
        if (messageGroup == null) {
            return null;
        }
        CMISMessage message = messageGroup.getMessage(code);
        if (message != null) {
            return message.getDisplay();
        }
        if (messageGroup.isNeedDefault()) {
            message = messageGroup.getMessage("default");
            return message.getDisplay();
        }
        return null;
    }

    public static String getMessage(String groupId, String code, Object[] templateArgs) {
        String msgStr = null;
        if (messageManager == null) {
            return null;
        }
        CMISMessageGroup messageGroup = (CMISMessageGroup)CMISMessageManager.messageManager.messageGroup.get(groupId);
        if (messageGroup == null) {
            return null;
        }
        CMISMessage message = messageGroup.getMessage(code);
        if (message != null) {
            msgStr = message.getDisplay();
            if (templateArgs != null) {
                msgStr = MessageFormat.format(msgStr, templateArgs);
            }
        } else if (messageGroup.isNeedDefault()) {
            message = messageGroup.getMessage("default");
            msgStr = message.getDisplay();
        }
        return msgStr;
    }

    public static CMISMessage getCMISMessage(String groupId, String code, Object[] templateArgs) {
        String msgStr = null;
        if (messageManager == null) {
            return null;
        }
        CMISMessageGroup messageGroup = (CMISMessageGroup)CMISMessageManager.messageManager.messageGroup.get(groupId);
        if (messageGroup == null) {
            return null;
        }
        CMISMessage message = messageGroup.getMessage(code);
        if (message != null) {
            if (templateArgs != null) {
                msgStr = message.getDisplay();
                msgStr = MessageFormat.format(msgStr, templateArgs);
                message.setDisplay(msgStr);
            }
        } else if (messageGroup.isNeedDefault()) {
            message = messageGroup.getMessage("default");
        }
        return message;
    }

    protected String getMessage(Class aClass, String code) {
        if (messageManager == null) {
            return null;
        }
        String className = aClass.getName();
        String message = messageManager.getMessage(className, code);
        if (message == null) {
            className = className.substring(className.lastIndexOf(".") + 1);
            message = messageManager.getMessage(className, code);
        }
        return message;
    }

    protected String getMessage(Class aClass, String code, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        String className = aClass.getName();
        String message = CMISMessageManager.getMessage(className, code, templateArgs);
        if (message == null) {
            className = className.substring(className.lastIndexOf(".") + 1);
            message = CMISMessageManager.getMessage(className, code, templateArgs);
        }
        return message;
    }

    protected CMISMessage getCMISMessage(Class aClass, String code, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        String className = aClass.getName();
        CMISMessage message = CMISMessageManager.getCMISMessage(className, code, templateArgs);
        if (message == null) {
            className = className.substring(className.lastIndexOf(".") + 1);
            message = CMISMessageManager.getCMISMessage(className, code, templateArgs);
        }
        return message;
    }

    public static String getMessage(CMISException e) {
        if (messageManager == null) {
            return null;
        }
        String code = e.getErrorCode();
        String message = messageManager.getMessage(e.getClass(), code);
        if (message == null) {
            message = e.getShowMessage();
        }
        return message;
    }

    public static String getMessage(CMISException e, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        String code = e.getErrorCode();
        String message = messageManager.getMessage(e.getClass(), code, templateArgs);
        if (message == null) {
            message = e.getShowMessage();
        }
        return message;
    }

    public static CMISMessage getCMISMessage(CMISException e, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        String code = e.getErrorCode();
        CMISMessage message = messageManager.getCMISMessage(e.getClass(), code, templateArgs);
        if (message == null) {
            message = new CMISMessage();
            message.setDisplay(e.getShowMessage());
        }
        return message;
    }

    public static String getMessage(Exception e, String code) {
        if (messageManager == null) {
            return null;
        }
        return messageManager.getMessage(e.getClass(), code);
    }

    public static String getMessage(Exception e, String code, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        return messageManager.getMessage(e.getClass(), code, templateArgs);
    }

    public static CMISMessage getCMISMessage(Exception e, String code, Object[] templateArgs) {
        if (messageManager == null) {
            return null;
        }
        return messageManager.getCMISMessage(e.getClass(), code, templateArgs);
    }
}

