/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dic;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.dic.CMISDataDicService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CMISDataDicMapService
extends EMPService {
    private String enNameColumn;
    private String cnNameColumn;
    private String tableName;
    private String type;
    private String orderByColumn;

    protected void loadDicData(KeyedCollection dictColl, Connection connection) throws Exception {
        if (this.type == null) {
            throw new EMPException("the type can not be null in service named[" + this.getName() + "].");
        }
        IndexedCollection iColl = null;
        if (dictColl.containsKey((Object)this.type)) {
            iColl = (IndexedCollection)dictColl.getDataElement(this.type);
        } else {
            iColl = new IndexedCollection();
            iColl.setName(this.type);
            dictColl.addDataElement((DataElement)iColl);
            KeyedCollection kColl = new KeyedCollection();
            kColl.addDataField(CMISDataDicService.ATTR_ENNAME, null);
            kColl.addDataField(CMISDataDicService.ATTR_CNNAME, null);
            iColl.setDataElement((DataElement)kColl);
        }
        String sqlStr = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            state = connection.createStatement();
            sqlStr = this.orderByColumn != null ? "select " + this.enNameColumn + "," + this.cnNameColumn + " from " + this.tableName + " order by " + this.orderByColumn + " , " + this.enNameColumn : "select " + this.enNameColumn + "," + this.cnNameColumn + " from " + this.tableName + " order by " + this.enNameColumn;
            rs = state.executeQuery(sqlStr);
            while (rs.next()) {
                String enName = rs.getString(1);
                String cnName = rs.getString(2);
                KeyedCollection kColl = (KeyedCollection)iColl.getDataElement().clone();
                kColl.setName(enName);
                kColl.setDataValue(CMISDataDicService.ATTR_ENNAME, (Object)enName);
                kColl.setDataValue(CMISDataDicService.ATTR_CNNAME, (Object)cnName);
                iColl.addDataElement((DataElement)kColl);
            }
            rs.close();
            rs = null;
            state.close();
            state = null;
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("The DataDicService occur an error:" + e.getMessage()));
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

