/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.ad.mvc;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.datatype.DataType;
import com.ecc.emp.datatype.InvalidDataException;
import com.ecc.emp.flow.EMPFlow;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.multipart.MultipartHttpServletRequest;
import com.ecc.emp.web.servlet.mvc.EMPModelUpdater;
import com.ecc.emp.web.servlet.mvc.InvalidInputException;
import com.ecc.emp.web.servlet.mvc.ViewField;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;

public class ADModelUpdater
extends EMPModelUpdater {
    public void updateModel(HttpServletRequest request, Context context, EMPFlow flow, String opId, Map dataTypeDefs, boolean append) throws EMPException {
        if (this.getKeyedCollection() != null) {
            this.updateContextWithKeyedCollection(request, this.getKeyedCollection(), context, dataTypeDefs);
            return;
        }
        MultipartHttpServletRequest mReq = null;
        Map files = null;
        if (request instanceof MultipartHttpServletRequest) {
            mReq = (MultipartHttpServletRequest)request;
            files = mReq.getFiles();
        }
        Stack<IndexedCollection> adjustStack = null;
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String dataName;
            int idx;
            Object paramName = paramNames.nextElement();
            String[] values = request.getParameterValues(paramName.toString());
            String value = null;
            if (values != null && values.length > 0) {
                value = values[0];
            }
            if (files != null && files.get(paramName) != null) {
                value = files.get(paramName).toString();
            }
            if ((idx = (dataName = paramName.toString()).indexOf(".")) != -1) {
                String empDataName = dataName.substring(0, idx);
                int eidx = empDataName.indexOf("[");
                if (empDataName.charAt(idx - 1) == ']' && eidx != -1) {
                    KeyedCollection aKcoll;
                    int size;
                    int pos = -1;
                    try {
                        pos = Integer.parseInt(empDataName.substring(eidx + 1, idx - 1));
                    }
                    catch (NumberFormatException e1) {
                        continue;
                    }
                    if (pos < 0) continue;
                    IndexedCollection iColl = null;
                    String iCollName = empDataName.substring(0, eidx);
                    try {
                        iColl = (IndexedCollection)context.getDataElement(iCollName);
                        if (iColl == null) {
                            iColl = new IndexedCollection();
                            iColl.setName(iCollName);
                            KeyedCollection tempKcoll = new KeyedCollection();
                            iColl.setDataElement((DataElement)tempKcoll);
                            if (adjustStack == null) {
                                adjustStack = new Stack();
                            }
                            adjustStack.push(iColl);
                        }
                    }
                    catch (Exception e) {
                        iColl = new IndexedCollection();
                        iColl.setName(iCollName);
                        KeyedCollection tempKcoll = new KeyedCollection();
                        iColl.setDataElement((DataElement)tempKcoll);
                        if (adjustStack == null) {
                            adjustStack = new Stack<IndexedCollection>();
                        }
                        adjustStack.push(iColl);
                        context.addDataElement((DataElement)iColl);
                    }
                    this.adjustIndexedCollectionTemplate((KeyedCollection)iColl.getDataElement(), dataName.substring(idx + 1));
                    if (size <= pos) {
                        for (size = iColl.size(); size <= pos; ++size) {
                            aKcoll = new KeyedCollection();
                            iColl.add(aKcoll);
                        }
                    }
                    aKcoll = (KeyedCollection)iColl.get(pos);
                    this.updateKeyedCollectionModel(aKcoll, dataName.substring(idx + 1), value, adjustStack);
                    continue;
                }
                String kCollName = empDataName;
                KeyedCollection kColl = null;
                try {
                    kColl = (KeyedCollection)context.getDataElement(kCollName);
                    if (kColl == null) {
                        kColl = new KeyedCollection();
                        kColl.setName(kCollName);
                    }
                }
                catch (Exception e) {
                    kColl = new KeyedCollection();
                    kColl.setName(kCollName);
                    context.addDataElement((DataElement)kColl);
                }
                this.updateKeyedCollectionModel(kColl, dataName.substring(idx + 1), value, adjustStack);
                continue;
            }
            if (context.containsKey((Object)dataName)) {
                context.setDataValue(dataName, (Object)value);
                continue;
            }
            context.addDataField(dataName, (Object)value);
        }
        if (adjustStack != null && adjustStack.size() > 0) {
            while (!adjustStack.isEmpty()) {
                KeyedCollection tempKcoll;
                IndexedCollection iColl = (IndexedCollection)adjustStack.pop();
                if (iColl == null || iColl.size() == 0 || (tempKcoll = (KeyedCollection)iColl.getDataElement()) == null || tempKcoll.size() == 0) continue;
                for (int i = 0; i < iColl.size(); ++i) {
                    KeyedCollection kColl = (KeyedCollection)iColl.getElementAt(i);
                    for (int j = 0; j < tempKcoll.size(); ++j) {
                        DataElement element = tempKcoll.getDataElement(j);
                        if (kColl.containsKey((Object)element.getName())) continue;
                        kColl.addDataElement((DataElement)element.clone());
                    }
                }
            }
        }
    }

    protected void updateKeyedCollectionModel(KeyedCollection kColl, String dataName, String dataValue, Stack adjustStack) throws EMPException {
        int idx = dataName.indexOf(".");
        if (idx != -1) {
            String empDataName = dataName.substring(0, idx);
            int eidx = empDataName.indexOf("[");
            if (empDataName.charAt(idx - 1) == ']' && eidx != -1) {
                KeyedCollection aKcoll;
                int size;
                KeyedCollection tempKcoll;
                int pos = -1;
                try {
                    pos = Integer.parseInt(empDataName.substring(eidx + 1, idx - 1));
                }
                catch (NumberFormatException e1) {
                    return;
                }
                if (pos < 0) {
                    return;
                }
                IndexedCollection iColl = null;
                String iCollName = empDataName.substring(0, eidx);
                if (kColl.containsKey((Object)iCollName)) {
                    iColl = (IndexedCollection)kColl.getDataElement(iCollName);
                    if (iColl == null) {
                        iColl = new IndexedCollection();
                        iColl.setName(iCollName);
                        tempKcoll = new KeyedCollection();
                        iColl.setDataElement((DataElement)tempKcoll);
                        if (adjustStack == null) {
                            adjustStack = new Stack();
                        }
                        adjustStack.push(iColl);
                    }
                } else {
                    iColl = new IndexedCollection();
                    iColl.setName(iCollName);
                    tempKcoll = new KeyedCollection();
                    iColl.setDataElement((DataElement)tempKcoll);
                    if (adjustStack == null) {
                        adjustStack = new Stack<IndexedCollection>();
                    }
                    adjustStack.push(iColl);
                    kColl.addDataElement((DataElement)iColl);
                }
                this.adjustIndexedCollectionTemplate((KeyedCollection)iColl.getDataElement(), dataName.substring(idx + 1));
                if (size <= pos) {
                    for (size = iColl.size(); size <= pos; ++size) {
                        aKcoll = new KeyedCollection();
                        iColl.add(aKcoll);
                    }
                }
                aKcoll = (KeyedCollection)iColl.get(pos);
                this.updateKeyedCollectionModel(aKcoll, dataName.substring(idx + 1), dataValue, adjustStack);
            } else {
                String kCollName = empDataName;
                KeyedCollection aKcoll = null;
                if (kColl.containsKey((Object)kCollName)) {
                    aKcoll = (KeyedCollection)kColl.getDataElement(kCollName);
                    if (aKcoll == null) {
                        aKcoll = new KeyedCollection();
                        aKcoll.setName(kCollName);
                    }
                } else {
                    aKcoll = new KeyedCollection();
                    aKcoll.setName(kCollName);
                    kColl.addDataElement((DataElement)aKcoll);
                }
                this.updateKeyedCollectionModel(aKcoll, dataName.substring(idx + 1), dataValue, adjustStack);
            }
        } else if (kColl.containsKey((Object)dataName)) {
            kColl.setDataValue(dataName, (Object)dataValue);
        } else {
            kColl.addDataField(dataName, (Object)dataValue);
        }
    }

    protected void adjustIndexedCollectionTemplate(KeyedCollection tempKcoll, String dataName) throws EMPException {
        int idx = dataName.indexOf(".");
        if (idx != -1) {
            String empDataName = dataName.substring(0, idx);
            int eidx = empDataName.indexOf("[");
            if (empDataName.charAt(idx - 1) == ']' && eidx != -1) {
                String iCollName = empDataName.substring(0, eidx);
                if (!tempKcoll.containsKey((Object)iCollName)) {
                    IndexedCollection iColl = new IndexedCollection(iCollName);
                    tempKcoll.addDataElement((DataElement)iColl);
                }
            } else {
                String kCollName = empDataName;
                if (!tempKcoll.containsKey((Object)kCollName)) {
                    KeyedCollection kColl = new KeyedCollection(kCollName);
                    tempKcoll.addDataElement((DataElement)kColl);
                    this.adjustIndexedCollectionTemplate(kColl, dataName.substring(idx + 1));
                }
            }
        } else if (!tempKcoll.containsKey((Object)dataName)) {
            tempKcoll.addDataField(dataName, null);
        }
    }

    protected void updateContextWithKeyedCollection(HttpServletRequest request, KeyedCollection kColl, Context context, Map dataTypeDefs) throws EMPException {
        MultipartHttpServletRequest mReq = null;
        Map files = null;
        if (request instanceof MultipartHttpServletRequest) {
            mReq = (MultipartHttpServletRequest)request;
            files = mReq.getFiles();
        }
        boolean haveInputException = false;
        Object[] keys = kColl.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String name = (String)keys[i];
            DataElement field = kColl.getDataElement(name);
            if (IndexedCollection.class.isAssignableFrom(field.getClass())) {
                String iCollName = field.getName();
                IndexedCollection targetIColl = null;
                try {
                    targetIColl = (IndexedCollection)context.getDataElement(iCollName);
                }
                catch (ObjectNotFoundException e2) {
                    targetIColl = (IndexedCollection)field.clone();
                    context.addDataElement((DataElement)targetIColl);
                }
                try {
                    this.updateICollByRequest(request, files, targetIColl, dataTypeDefs, null);
                }
                catch (InvalidDataException e) {
                    haveInputException = true;
                }
                continue;
            }
            if (KeyedCollection.class.isAssignableFrom(field.getClass())) {
                String kCollName = field.getName();
                KeyedCollection targetKColl = null;
                try {
                    targetKColl = (KeyedCollection)context.getDataElement(kCollName);
                }
                catch (ObjectNotFoundException e2) {
                    targetKColl = (KeyedCollection)field.clone();
                    context.addDataElement((DataElement)targetKColl);
                }
                try {
                    this.updateKCollByRequest(request, files, targetKColl, dataTypeDefs, null);
                }
                catch (InvalidDataException e) {
                    haveInputException = true;
                }
                continue;
            }
            DataField dataField = (DataField)field;
            String dataName = field.getName();
            String value = request.getParameter(dataName);
            if (files != null && files.get(name) != null) {
                value = files.get(name);
            }
            String dstFieldName = dataField.getName();
            if (field instanceof ViewField) {
                dstFieldName = ((ViewField)field).getDstDataName();
            }
            DataField dstDataElement = (DataField)context.getDataElement(dstFieldName);
            if ((value == null || value == "") && dataField.isRequired()) {
                this.addErrorMessage(context, dataName, "Required field ");
                haveInputException = true;
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Required field  " + dataName + "Not posted!"));
                continue;
            }
            String dataType = dstDataElement.getDataType();
            if (dataType != null) {
                try {
                    DataType dataTypeDef = (DataType)dataTypeDefs.get(dataType);
                    Object objValue = dataTypeDef.convertFromString(value.toString(), null);
                    context.setDataValue(dstFieldName, objValue);
                }
                catch (InvalidDataException e) {
                    haveInputException = true;
                    String msg = e.getMessage();
                    this.addErrorMessage(context, dstDataElement.getName(), msg);
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Invalid dataValue DataField  " + dataName + " = " + value), (Throwable)e);
                }
            } else {
                context.setDataValue(dstFieldName, (Object)value);
            }
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Posted DataField  " + name + " = " + value));
        }
        if (haveInputException) {
            throw new InvalidInputException();
        }
    }

    protected void updateKCollByRequest(HttpServletRequest request, Map files, KeyedCollection kColl, Map dataTypeDefs, String prefix) throws EMPException {
        Object[] keys = kColl.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String name = (String)keys[i];
            DataElement field = kColl.getDataElement(name);
            if (IndexedCollection.class.isAssignableFrom(field.getClass())) {
                IndexedCollection targetIColl = (IndexedCollection)field;
                prefix = prefix == null ? kColl.getName() : prefix + "." + kColl.getName();
                this.updateICollByRequest(request, files, targetIColl, dataTypeDefs, prefix);
                continue;
            }
            if (KeyedCollection.class.isAssignableFrom(field.getClass())) {
                KeyedCollection targetKColl = (KeyedCollection)field;
                prefix = prefix == null ? kColl.getName() : prefix + "." + kColl.getName();
                this.updateKCollByRequest(request, files, targetKColl, dataTypeDefs, prefix);
                continue;
            }
            DataField dataField = (DataField)field;
            String dataName = kColl.getName() + "." + field.getName();
            if (prefix != null) {
                dataName = prefix + "." + dataName;
            }
            String value = request.getParameter(dataName);
            if (files != null && files.get(name) != null) {
                value = files.get(name);
            }
            if ((value == null || value == "") && dataField.isRequired()) {
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Required field  " + dataName + "Not posted!"));
                continue;
            }
            String dataType = dataField.getDataType();
            if (dataType != null) {
                DataType dataTypeDef = (DataType)dataTypeDefs.get(dataType);
                Object objValue = dataTypeDef.convertFromString(value.toString(), null);
                dataField.setValue(objValue);
            } else {
                dataField.setValue((Object)value);
            }
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Posted DataField  " + name + " = " + value));
        }
    }

    public void updateModel(HttpServletRequest request, Context context, Map dataTypeDefs, boolean append) throws EMPException {
        this.updateModel(request, context, null, null, dataTypeDefs, append);
    }

    protected void updateICollByRequest(HttpServletRequest request, Map files, IndexedCollection iColl, Map dataTypeDefs, String prefix) throws EMPException {
        DataElement element = iColl.getDataElement();
        String iCollName = iColl.getName();
        if (prefix != null) {
            iCollName = prefix + "." + iCollName;
        }
        if (KeyedCollection.class.isAssignableFrom(element.getClass())) {
            KeyedCollection kColl = (KeyedCollection)element;
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String empDataName;
                int idx;
                Object paramName = paramNames.nextElement();
                String dataName = paramName.toString();
                if (!dataName.startsWith(iCollName + "[") || (idx = (empDataName = dataName.substring(iCollName.length() + 1)).indexOf("].")) == -1) continue;
                int pos = -1;
                try {
                    pos = Integer.parseInt(empDataName.substring(0, idx));
                }
                catch (NumberFormatException e1) {
                    continue;
                }
                if (pos < 0) continue;
                KeyedCollection aKColl = null;
                if (pos <= iColl.size()) {
                    aKColl = (KeyedCollection)iColl.getElementAt(pos);
                } else {
                    for (int size = iColl.size(); size <= pos; ++size) {
                        aKColl = (KeyedCollection)element.clone();
                        iColl.addDataElement((DataElement)aKColl);
                    }
                }
                this.updateKCollByRequest(request, files, aKColl, dataTypeDefs, iCollName + ".[" + pos + "]");
            }
        } else {
            DataField field = (DataField)element;
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String empDataName;
                int idx;
                Object paramName = paramNames.nextElement();
                String dataName = paramName.toString();
                if (!dataName.startsWith(iCollName + "[") || (idx = (empDataName = dataName.substring(iCollName.length() + 1)).indexOf("].")) == -1) continue;
                int pos = -1;
                try {
                    pos = Integer.parseInt(empDataName.substring(0, idx));
                }
                catch (NumberFormatException e1) {
                    continue;
                }
                if (pos < 0) continue;
                DataElement aElement = null;
                if (pos <= iColl.size()) {
                    aElement = iColl.getElementAt(pos);
                } else {
                    for (int size = iColl.size(); size <= pos; ++size) {
                        aElement = (DataElement)element.clone();
                        iColl.addDataElement(aElement);
                    }
                }
                if (KeyedCollection.class.isAssignableFrom(aElement.getClass())) {
                    ((KeyedCollection)aElement).setDataValue(empDataName.substring(idx + 1), (Object)request.getParameter(dataName));
                    continue;
                }
                ((DataField)aElement).setValue(request.getParameter(dataName));
            }
        }
    }

    protected void addErrorMessage(Context context, String dataName, String msg) {
        try {
            KeyedCollection errorKColl = null;
            try {
                errorKColl = (KeyedCollection)context.getDataElement(EMPConstance.ERROR_MSG_KCOLL);
            }
            catch (Exception e) {
                errorKColl = new KeyedCollection(EMPConstance.ERROR_MSG_KCOLL);
                context.addDataElement((DataElement)errorKColl);
            }
            errorKColl.addDataField(dataName, (Object)msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

