/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.session;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.CacheClient;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Jedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisEMPSessionUtil {
    public static final String KEY_PREX = "SID_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long setSession(String sessionId) {
        Long hset = null;
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                hset = cli.hset(RedisEMPSessionUtil.getSessionKey(sessionId), "_SID_", sessionId);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var5_4 = null;
                if (cli == null) return hset;
                cli.close();
                return hset;
            }
            Object var5_3 = null;
            if (cli == null) return hset;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
        return hset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setTimeOut(String sessionId, long timeOut) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.pexpire(RedisEMPSessionUtil.getSessionKey(sessionId), timeOut);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var6_4 = null;
                if (cli == null) return;
                cli.close();
                return;
            }
            Object var6_3 = null;
            if (cli == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsSession(String sessionId) {
        boolean success = false;
        Jedis cli = null;
        try {
            block4: {
                try {
                    cli = RedisEMPSessionUtil.getConnection();
                    Boolean exists = cli.exists(RedisEMPSessionUtil.getSessionKey(sessionId));
                    if (exists == null || !exists.booleanValue()) break block4;
                    success = true;
                }
                catch (Exception e) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                    Object var5_6 = null;
                    if (cli == null) return success;
                    cli.close();
                    return success;
                }
            }
            Object var5_5 = null;
            if (cli == null) return success;
            cli.close();
            return success;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long ttlSession(String sessionId) {
        Long ttl = null;
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                ttl = cli.ttl(sessionId);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var5_4 = null;
                if (cli == null) return ttl;
                cli.close();
                return ttl;
            }
            Object var5_3 = null;
            if (cli == null) return ttl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
        return ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSessionAttr(String sessionId, String subKey, String val) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.hset(RedisEMPSessionUtil.getSessionKey(sessionId), subKey, val);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var6_5 = null;
                if (cli == null) return;
                cli.close();
                return;
            }
            Object var6_4 = null;
            if (cli == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSessionAttr(String sessionId, String subKey) {
        Jedis cli = null;
        String attr = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                attr = cli.hget(RedisEMPSessionUtil.getSessionKey(sessionId), subKey);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var6_5 = null;
                if (cli == null) return attr;
                cli.close();
                return attr;
            }
            Object var6_4 = null;
            if (cli == null) return attr;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeSessionAttr(String sessionId, String subKey) {
        Jedis cli = null;
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                cli.hdel(RedisEMPSessionUtil.getSessionKey(sessionId), new String[]{subKey});
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var5_4 = null;
                if (cli == null) return;
                cli.close();
                return;
            }
            Object var5_3 = null;
            if (cli == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getSessionAttrs(String sessionId) {
        Jedis cli = null;
        HashMap<String, String> attrs = new HashMap();
        try {
            try {
                cli = RedisEMPSessionUtil.getConnection();
                attrs = cli.hgetAll(RedisEMPSessionUtil.getSessionKey(sessionId));
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                Object var5_4 = null;
                if (cli == null) return attrs;
                cli.close();
                return attrs;
            }
            Object var5_3 = null;
            if (cli == null) return attrs;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (cli == null) throw throwable;
            cli.close();
            throw throwable;
        }
        cli.close();
        return attrs;
    }

    private static String getSessionKey(String sessionId) {
        return KEY_PREX + sessionId;
    }

    private static Jedis getConnection() {
        Jedis jedis = (Jedis)CacheClient.getConnection();
        return jedis;
    }
}

