/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.session;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.session.EMPSession;
import com.ecc.emp.session.EMPSessionManager;
import com.ecc.emp.session.RedisEMPSession;
import com.ecc.emp.session.RedisEMPSessionUtil;
import com.ecc.emp.session.Session;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisEMPSessionManager
extends EMPSessionManager {
    protected String factoryName = "CMISBiz";
    protected boolean useCache = true;
    protected String contextNameKey = "_sessionContextName_";
    protected String keySpecialCharacter = "$$";

    public Session getSession(Object requestObj, Object responseObj, boolean createWhenNotCreate) {
        String sessionId = null;
        HttpServletRequest request = null;
        Session session = null;
        if (requestObj instanceof String) {
            sessionId = (String)requestObj;
        } else if (requestObj instanceof HttpServletRequest) {
            request = (HttpServletRequest)requestObj;
            if (this.sessionTraceType == 0) {
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!this.sessionIdLabel.equals(cookies[i].getName())) continue;
                        sessionId = cookies[i].getValue();
                        break;
                    }
                }
            } else {
                sessionId = (String)request.getAttribute("SID");
                if (sessionId == null) {
                    sessionId = request.getParameter(this.sessionIdLabel);
                }
                if (this.bindCookie && sessionId != null && (session = this.getSession(request, sessionId)) != null) {
                    boolean cookieExist = false;
                    String curSid = (String)session.getAttribute(this.sessionIdLabel);
                    List<String> cookieSessionIds = this.getCookieSessionIds(request);
                    for (String id : cookieSessionIds) {
                        if (!id.equals(curSid)) continue;
                        cookieExist = true;
                        break;
                    }
                    if (!cookieExist) {
                        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.INFO, (int)0, (String)("Invalid Session for cookie bind [" + sessionId + "][" + curSid + "]"));
                        sessionId = null;
                    }
                }
            }
        } else if (requestObj != null) {
            sessionId = requestObj.toString();
        }
        if (sessionId == null) {
            session = null;
            if (createWhenNotCreate) {
                session = (EMPSession)request.getAttribute(EMPConstance.ATTR_SESSION);
                if (session == null) {
                    session = this.createNewRedisSession(responseObj, request);
                } else {
                    sessionId = session.getId();
                }
                if (this.bindClientIP) {
                    String reqIP = request.getRemoteAddr();
                    session.setAttribute("_CLTIP", (Object)reqIP);
                }
            }
        } else if (session == null) {
            session = this.getSession(request, sessionId);
        }
        if (session != null) {
            if (this.bindClientIP) {
                String saveIP = (String)session.getAttribute("_CLTIP");
                String reqIP = request.getRemoteAddr();
                if (!reqIP.equals(saveIP)) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)("Invalid Session from IP " + saveIP + " to " + reqIP));
                    session = null;
                }
            }
            if (request != null) {
                request.setAttribute(EMPConstance.ATTR_SESSION, (Object)session);
            }
        }
        return session;
    }

    private Session getSession(HttpServletRequest request, String sessionId) {
        EMPSession session = (EMPSession)request.getAttribute(EMPConstance.ATTR_SESSION);
        if (session == null) {
            session = (EMPSession)this.sessions.get(sessionId);
            if (session == null) {
                if (RedisEMPSessionUtil.existsSession(sessionId)) {
                    session = new RedisEMPSession(sessionId, this.useCache, this.factoryName, this.contextNameKey, this.keySpecialCharacter);
                    this.sessions.put(sessionId, session);
                }
            } else if (this.checkTimeout(session)) {
                session = null;
            }
            if (session != null) {
                RedisEMPSessionUtil.setTimeOut(session.getId(), this.sessionTimeOut);
                session.setLastAccessTime(System.currentTimeMillis());
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)("Update timeOut " + sessionId));
            } else {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)("Session timeOut " + sessionId));
            }
        } else {
            EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)"Get session from request");
        }
        return session;
    }

    public void removeSession(String sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session == null) {
            RedisEMPSessionUtil.setTimeOut(sessionId, 0L);
        } else {
            this.removeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session) {
        if (session != null) {
            RedisEMPSessionUtil.setTimeOut(session.getId(), 0L);
            Map map = this.sessions;
            synchronized (map) {
                this.sessions.remove(session.getId());
            }
            Context sessionContext = (Context)session.getAttribute(EMPConstance.ATTR_CONTEXT);
            if (sessionContext != null) {
                sessionContext.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheSession(Session session) {
        if (session != null) {
            Map map = this.sessions;
            synchronized (map) {
                this.sessions.remove(session.getId());
            }
            Context sessionContext = (Context)session.getAttribute(EMPConstance.ATTR_CONTEXT);
            if (sessionContext != null) {
                sessionContext.terminate();
            }
        }
    }

    public void sessionRequestEnd(Session session) {
    }

    public void initialize() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SessionCheckTask(), this.sessionCheckInterval, (long)this.sessionCheckInterval);
    }

    public int getSessionCount() {
        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"=====", (Throwable)new Exception("--Deprecated getSessionCount()--"));
        return 0;
    }

    public Map getSessions() {
        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"=====", (Throwable)new Exception("--Deprecated getSessions()--"));
        return null;
    }

    public void setSessions(Map sessions) {
        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"=====", (Throwable)new Exception("--Deprecated setSessions()--"));
    }

    public void terminate() {
        super.terminate();
    }

    protected Session createNewRedisSession(Object responseObj, HttpServletRequest request) {
        HttpServletResponse response;
        String sessionId;
        String cookieSessionId = sessionId = this.generateSessionId();
        RedisEMPSession session = null;
        if (this.sessionTraceType == 0 && responseObj != null && responseObj instanceof HttpServletResponse) {
            response = (HttpServletResponse)responseObj;
            Cookie cookie = new Cookie(this.sessionIdLabel, sessionId);
            response.addCookie(cookie);
        }
        if (this.bindCookie && this.sessionTraceType == 1 && responseObj != null && responseObj instanceof HttpServletResponse) {
            response = (HttpServletResponse)responseObj;
            List<String> cookieSessionIds = this.getCookieSessionIds(request);
            if (cookieSessionIds.isEmpty()) {
                Cookie cookie = new Cookie(this.sessionIdLabel + "_" + new Date().getTime() + this.randomInt(4), sessionId);
                response.addCookie(cookie);
            } else {
                cookieSessionId = cookieSessionIds.get(cookieSessionIds.size() - 1);
            }
        }
        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)("Create new Session:" + sessionId + " Total session size: " + (this.sessions.size() + 1)));
        RedisEMPSessionUtil.setSession(sessionId);
        session = new RedisEMPSession(sessionId, this.useCache, this.factoryName, this.contextNameKey, this.keySpecialCharacter);
        session.setAttribute(this.sessionIdLabel, cookieSessionId);
        this.sessions.put(sessionId, session);
        return session;
    }

    protected boolean checkTimeout(EMPSession session) {
        boolean timeOut = false;
        if (this.useCache) {
            if (System.currentTimeMillis() - session.getLastAccessTime() > (long)this.sessionTimeOut) {
                timeOut = true;
            }
        } else if (!RedisEMPSessionUtil.existsSession(session.getId())) {
            timeOut = true;
        }
        return timeOut;
    }

    private String randomInt(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int nextInt = random.nextInt(10);
            sb.append(nextInt);
        }
        return sb.toString();
    }

    private List<String> getCookieSessionIds(HttpServletRequest request) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!cookie.getName().startsWith(this.sessionIdLabel + "_")) continue;
                list.add(cookie.getValue());
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"Read cookie error! ", (Throwable)e);
        }
        return list;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String getContextNameKey() {
        return this.contextNameKey;
    }

    public void setContextNameKey(String contextNameKey) {
        this.contextNameKey = contextNameKey;
    }

    public String getKeySpecialCharacter() {
        return this.keySpecialCharacter;
    }

    public void setKeySpecialCharacter(String keySpecialCharacter) {
        this.keySpecialCharacter = keySpecialCharacter;
    }

    protected class SessionCheckTask
    extends TimerTask {
        protected SessionCheckTask() {
        }

        public void run() {
            EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)("Do the session check for RedisEMPSessionManager [" + RedisEMPSessionManager.this.name + "]"));
            Object[] keys = null;
            try {
                keys = RedisEMPSessionManager.this.sessions.keySet().toArray();
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"Failed to do session time out check: ", (Throwable)e);
                return;
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    RedisEMPSession session = (RedisEMPSession)((Object)RedisEMPSessionManager.this.sessions.get(keys[i]));
                    if (session == null || !RedisEMPSessionManager.this.checkTimeout(session)) continue;
                    if (RedisEMPSessionManager.this.sessionTimeoutListener != null) {
                        RedisEMPSessionManager.this.sessionTimeoutListener.sessionTimeout(session.getId(), (Context)session.getAttribute(EMPConstance.ATTR_CONTEXT));
                    }
                    RedisEMPSessionManager.this.removeCacheSession((Session)session);
                    continue;
                }
                catch (Exception e) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"Failed to do session time out check", (Throwable)e);
                }
            }
        }
    }
}

