/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.format.String;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataField;
import com.ecc.emp.format.EMPFormatException;
import com.ecc.emp.format.FormatElement;
import com.ecc.emp.format.FormatField;
import com.ecc.emp.log.EMPLog;

public class FixedLenFormat
extends FormatField {
    private String len;
    private char padChar = (char)32;
    private String aligment = "none";

    public void setAligment(String aligment) {
        this.aligment = aligment;
    }

    public void setLen(String len) {
        this.len = len;
    }

    public void setPadChar(String padChar) {
        this.padChar = padChar.charAt(0);
    }

    public String getLen() {
        return this.len;
    }

    public String getAligment() {
        return this.aligment;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public Object format(DataField dataField) throws EMPFormatException {
        String theLen = this.getLen();
        int len = 0;
        len = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        if (len <= 0) {
            EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat format failed! len should not be null or 0!", null);
            throw new EMPFormatException("FixedLenFormat format failed! len should not be null or 0!");
        }
        StringBuffer buffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buffer.append(this.padChar);
        }
        String valueStr = (String)dataField.getValue();
        int b = 0;
        if (valueStr == null) {
            valueStr = "";
        }
        int realLen = valueStr.length();
        if ("right".equalsIgnoreCase(this.aligment)) {
            if (realLen > len) {
                valueStr = valueStr.substring(realLen - len);
                realLen = len;
            }
            b = len - realLen;
        } else if ("center".equalsIgnoreCase(this.aligment)) {
            if (realLen > len) {
                b = realLen / 2 - len / 2;
                valueStr = valueStr.substring(b, b + len);
                realLen = len;
            }
            b = len / 2 - realLen / 2;
        } else if (realLen > len) {
            valueStr = valueStr.substring(0, len);
            realLen = len;
        }
        buffer.replace(b, b + realLen, valueStr);
        return buffer.toString();
    }

    public void unformat(Object src, DataField dataField) {
        int i;
        String mySrc = (String)src;
        int realLen = mySrc.length();
        int b = 0;
        int e = realLen - 1;
        if (this.aligment != null && ("left".equalsIgnoreCase(this.aligment) || "center".equalsIgnoreCase(this.aligment))) {
            for (i = realLen - 1; i >= 0; --i) {
                if (mySrc.charAt(i) == this.padChar) continue;
                e = i;
                break;
            }
        }
        if (this.aligment != null && ("right".equalsIgnoreCase(this.aligment) || "center".equalsIgnoreCase(this.aligment))) {
            for (i = 0; i < realLen; ++i) {
                if (mySrc.charAt(i) == this.padChar) continue;
                b = i;
                break;
            }
        }
        String value = mySrc.substring(b, e + 1);
        dataField.setValue(value);
    }

    public int extract(Object src, int offset) throws EMPFormatException {
        String theLen = this.getLen();
        int length = 0;
        length = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        int retLen = super.extract(src, offset);
        if (retLen != -1) {
            return retLen;
        }
        return length;
    }

    public String toString(int tabCount) {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < tabCount; ++i) {
            buf.append("\t");
        }
        buf.append("<FixedLenFormat dataName=\"");
        buf.append(this.getDataName());
        buf.append("\" len=\"").append(this.len).append("\" padChar=\"").append(this.padChar);
        buf.append("\" aligment=\"").append(this.aligment);
        buf.append("\"/>\n");
        for (i = 0; i < this.getDecorators().size(); ++i) {
            FormatElement fmt = (FormatElement)this.getDecorators().get(i);
            buf.append(fmt.toString(tabCount));
            buf.append("\n");
        }
        return buf.toString();
    }
}

