/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.format.String;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataField;
import com.ecc.emp.format.Decorator;
import com.ecc.emp.format.EMPFormatException;
import com.ecc.emp.format.String.FixedLenFormat;
import com.ecc.emp.log.EMPLog;
import java.math.BigDecimal;
import java.util.List;

public class DualbyteCharFixedLenFormat
extends FixedLenFormat {
    private String precision;

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public Object format(DataField dataField) throws EMPFormatException {
        int i;
        String theLen = this.getLen();
        int len = 0;
        len = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        String pre = null;
        if (theLen.lastIndexOf(44) != -1) {
            pre = theLen.substring(theLen.lastIndexOf(44) + 1);
        }
        if (len <= 0) {
            EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat format failed! len should not be null or 0!", null);
            throw new EMPFormatException("FixedLenFormat format failed! len should not be null or 0!");
        }
        String valueStr = (String)dataField.getValue();
        int b = 0;
        if (valueStr == null) {
            valueStr = "";
        }
        if (pre != null && !pre.equals("")) {
            String newStr;
            int prec = 0;
            try {
                prec = Integer.parseInt(pre);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat format failed! precision must be Integer!", null);
                throw new EMPFormatException("FixedLenFormat format failed! precision must be Integer!");
            }
            valueStr = newStr = DualbyteCharFixedLenFormat.formatNumber(valueStr, prec);
        }
        int realLen = valueStr.length();
        int idx = 0;
        int max = len;
        int bufflen = len;
        for (i = 0; i < realLen && idx < max; ++i) {
            char nc;
            char c = valueStr.charAt(i);
            if (c > '\u00ff') {
                --bufflen;
                idx += 2;
                if (i == realLen - 1) {
                    max -= 2;
                    continue;
                }
                nc = valueStr.charAt(i + 1);
                if (max - idx < 4 && nc > '\u00ff') {
                    ++i;
                    break;
                }
                if (nc > '\u00ff') continue;
                max -= 2;
                continue;
            }
            ++idx;
            if (i >= realLen - 1) continue;
            nc = valueStr.charAt(i + 1);
            if (max - idx >= 4 || nc <= '\u00ff') continue;
            ++i;
            break;
        }
        len = i;
        if ("right".equalsIgnoreCase(this.getAligment())) {
            if (realLen > len) {
                valueStr = valueStr.substring(realLen - len);
                realLen = len;
            }
            b = bufflen - realLen;
        } else if ("center".equalsIgnoreCase(this.getAligment())) {
            if (realLen > len) {
                b = realLen / 2 - len / 2;
                valueStr = valueStr.substring(b, b + len);
                realLen = len;
            }
            b = bufflen / 2 - realLen / 2;
        } else if (realLen > len) {
            valueStr = valueStr.substring(0, len);
            realLen = len;
        }
        StringBuffer buffer = new StringBuffer(bufflen);
        for (int j = 0; j < bufflen; ++j) {
            buffer.append(this.getPadChar());
        }
        buffer.replace(b, b + realLen, valueStr);
        return buffer.toString();
    }

    public void unformat(Object src, DataField dataField) {
        int i;
        String mySrc = (String)src;
        int realLen = mySrc.length();
        String aligment = this.getAligment();
        String pre = null;
        String theLen = this.getLen();
        if (theLen.lastIndexOf(44) != -1) {
            pre = theLen.substring(theLen.lastIndexOf(44) + 1);
        }
        char padChar = this.getPadChar();
        int b = 0;
        int e = realLen - 1;
        if (aligment != null && ("left".equalsIgnoreCase(aligment) || "center".equalsIgnoreCase(aligment))) {
            for (i = realLen - 1; i >= 0; --i) {
                if (mySrc.charAt(i) == padChar) continue;
                e = i;
                break;
            }
        }
        if (aligment != null && ("right".equalsIgnoreCase(aligment) || "center".equalsIgnoreCase(aligment))) {
            for (i = 0; i < realLen; ++i) {
                if (mySrc.charAt(i) == padChar) continue;
                b = i;
                break;
            }
        }
        String value = mySrc.substring(b, e + 1);
        if (pre != null && !pre.equals("")) {
            String newStr;
            int prec = 0;
            try {
                prec = Integer.parseInt(pre);
            }
            catch (Exception ee) {
                EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat unformat failed! precision must be Integer!", null);
            }
            value = newStr = DualbyteCharFixedLenFormat.unformatNumber(value, prec);
        }
        dataField.setValue(value);
    }

    public int extract(Object src, int offset) throws EMPFormatException {
        List decorators = this.getDecorators();
        for (int i = 0; i < decorators.size(); ++i) {
            Decorator decorator = (Decorator)decorators.get(i);
            int retValue = decorator.extract(src, offset);
            if (retValue == -1) continue;
            return retValue;
        }
        String theLen = this.getLen();
        int reallen = 0;
        reallen = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        int count = 0;
        for (int i = 0; i < reallen; ++i) {
            char c = ((String)src).charAt(offset + i);
            if (c > '\u00ff') {
                ++count;
            }
            if (reallen - count - i == 1) break;
        }
        return reallen - count;
    }

    public static String formatNumber(String src, int len2) {
        if (src == null || src.trim().length() == 0) {
            src = "0";
        }
        BigDecimal bd = new BigDecimal(src).setScale(len2, 1);
        for (int i = 0; i < len2; ++i) {
            bd = bd.multiply(new BigDecimal(10));
        }
        bd = bd.setScale(0, 3);
        return bd.toString();
    }

    public static String unformatNumber(String src, int len2) {
        if (src.trim().length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(src = src.trim());
        int nidx = sb.indexOf("-");
        if (nidx != -1) {
            sb.deleteCharAt(nidx);
            sb.insert(0, '-');
        }
        if (len2 > 0) {
            for (int t = sb.length() - len2; t < 0; ++t) {
                sb.insert(0, "0");
            }
            sb.insert(sb.length() - len2, '.');
        }
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(sb.toString().trim()).setScale(len2, 7);
            return bd.toString();
        }
        catch (Exception e) {
            return sb.toString();
        }
    }
}

