/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.dbmodel.service;

import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.component.xml.ComponentParser;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.dbmodel.TableModel;
import com.ecc.emp.dbmodel.TableModelParser;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import java.io.File;
import java.util.HashMap;

public class TableModelLoader
extends EMPService {
    private HashMap modelBase = new HashMap();

    public void addTableModel(TableModel model) {
        this.modelBase.put(model.getId(), model);
    }

    public TableModel getTableModel(String modelId) {
        return (TableModel)this.modelBase.get(modelId);
    }

    public HashMap getAllModels() {
        return this.modelBase;
    }

    public void initialize(String factoryName) {
        ComponentFactory factory = EMPFlowComponentFactory.getComponentFactory((String)factoryName);
        String webInfPath = ((EMPFlowComponentFactory)factory).getRootPath();
        String tableModelPath = (webInfPath = webInfPath.substring(0, webInfPath.indexOf("bizs"))) + "/tables/";
        File dir = new File(tableModelPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return;
        }
        this.loadMultiFolderTableModels(tableModelPath);
        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.INFO, (int)0, (String)"Load all the tableModel file success!");
    }

    private void loadMultiFolderTableModels(String path) {
        File dir = new File(path);
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return;
        }
        this.loadSingleFolderTableModels(path);
        for (int i = 0; i < files.length; ++i) {
            String subPath = path + files[i];
            File subDir = new File(subPath);
            if (!subDir.isDirectory()) continue;
            this.loadMultiFolderTableModels(subPath + "/");
        }
    }

    private void loadSingleFolderTableModels(String path) {
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return;
        }
        ComponentFactory tableFactory = new ComponentFactory();
        TableModelParser parser = new TableModelParser();
        tableFactory.setComponentParser((ComponentParser)parser);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".xml")) continue;
            String fileName = path + files[i];
            tableFactory.initializeComponentFactory("table", fileName);
            ComponentFactory.removeComponentFactory((String)"table");
            try {
                String componentName = files[i].substring(0, files[i].lastIndexOf(".xml"));
                Object obj = tableFactory.getComponent(componentName);
                if (!(obj instanceof TableModel)) continue;
                TableModel tableModel = (TableModel)obj;
                this.addTableModel(tableModel);
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.INFO, (int)0, (String)("Add tableModel[" + tableModel.getId() + "] to TableModelService."));
                continue;
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)"failed to load the tableModel file !", (Throwable)e);
            }
        }
    }

    public void initTableModels(String tableModelPath) {
        File dir = new File(tableModelPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return;
        }
        ComponentFactory tableFactory = new ComponentFactory();
        TableModelParser parser = new TableModelParser();
        tableFactory.setComponentParser((ComponentParser)parser);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".xml")) continue;
            String fileName = tableModelPath + files[i];
            tableFactory.initializeComponentFactory("table", fileName);
            ComponentFactory.removeComponentFactory((String)"table");
            try {
                String componentName = files[i].substring(0, files[i].lastIndexOf(".xml"));
                Object obj = tableFactory.getComponent(componentName);
                if (!(obj instanceof TableModel)) continue;
                TableModel tableModel = (TableModel)obj;
                this.addTableModel(tableModel);
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.INFO, (int)0, (String)("Add tableModel[" + tableModel.getId() + "] to TableModelService."));
                continue;
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)"failed to load the tableModel file !", (Throwable)e);
            }
        }
        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.INFO, (int)0, (String)"Load all the tableModel file success!");
    }
}

