/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.datatype;

import com.ecc.emp.datatype.EMPDataType;
import com.ecc.emp.datatype.InvalidDataException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTimeType
extends EMPDataType {
    String inputFormat = null;
    String valueFormat = null;
    String[] inputAmPm = new String[]{"\u4e0a\u5348", "\u4e0b\u5348"};
    String[] valueAmPm = new String[]{"\u4e0a\u5348", "\u4e0b\u5348"};
    String type = "DateTimeType";

    public Object convertFromString(String strValue, Locale locale) throws InvalidDataException {
        Date date = null;
        DateFormatSymbols symbol = new DateFormatSymbols();
        strValue = strValue.trim();
        if (this.inputFormat == null) {
            this.validateStringValue(strValue, locale);
            try {
                DateFormat dateformat = null;
                dateformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
                dateformat.setLenient(false);
                date = dateformat.parse(strValue);
            }
            catch (ParseException e) {
                throw new InvalidDataException(e.getMessage());
            }
        }
        this.validateStringValue(strValue);
        try {
            SimpleDateFormat inputField = new SimpleDateFormat(this.inputFormat);
            inputField.setLenient(false);
            symbol.setAmPmStrings(this.inputAmPm);
            inputField.setDateFormatSymbols(symbol);
            date = inputField.parse(strValue);
        }
        catch (ParseException e) {
            throw new InvalidDataException(e.getMessage());
        }
        if (this.keepStringValue) {
            if (this.valueFormat == null) {
                DateFormat valueformat = null;
                valueformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
                return valueformat.format(date);
            }
            SimpleDateFormat valueField = new SimpleDateFormat(this.valueFormat);
            symbol.setAmPmStrings(this.valueAmPm);
            valueField.setDateFormatSymbols(symbol);
            return valueField.format(date);
        }
        return date;
    }

    public String getStringValue(Object value, Locale locale) {
        String ret = null;
        DateFormatSymbols symbol = new DateFormatSymbols();
        if (this.inputFormat == null) {
            if (this.keepStringValue || value instanceof String) {
                try {
                    SimpleDateFormat valueField = new SimpleDateFormat(this.valueFormat);
                    symbol.setAmPmStrings(this.valueAmPm);
                    valueField.setDateFormatSymbols(symbol);
                    DateFormat dateformat = null;
                    dateformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
                    dateformat.setLenient(false);
                    Date date = valueField.parse((String)value);
                    ret = dateformat.format(date);
                }
                catch (Exception e) {
                    ret = value.toString();
                }
            } else {
                DateFormat dateformat = null;
                dateformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
                dateformat.setLenient(false);
                ret = dateformat.format(value);
            }
        } else if (this.keepStringValue || value instanceof String) {
            SimpleDateFormat inputField = new SimpleDateFormat(this.inputFormat);
            symbol.setAmPmStrings(this.inputAmPm);
            inputField.setDateFormatSymbols(symbol);
            try {
                SimpleDateFormat valueField = new SimpleDateFormat(this.valueFormat);
                symbol.setAmPmStrings(this.valueAmPm);
                valueField.setDateFormatSymbols(symbol);
                Date date = valueField.parse((String)value);
                ret = inputField.format(date);
            }
            catch (Exception e) {
                try {
                    DateFormat dateformat = null;
                    dateformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
                    dateformat.setLenient(false);
                    Date date = dateformat.parse((String)value);
                    ret = inputField.format(date);
                }
                catch (ParseException dateformat) {}
            }
        } else {
            SimpleDateFormat inputField = new SimpleDateFormat(this.inputFormat);
            symbol.setAmPmStrings(this.inputAmPm);
            inputField.setDateFormatSymbols(symbol);
            ret = inputField.format(value);
        }
        return ret;
    }

    public boolean validateStringValue(String value) throws InvalidDataException {
        value = value.trim();
        SimpleDateFormat inputField = new SimpleDateFormat(this.inputFormat);
        DateFormatSymbols symbol = inputField.getDateFormatSymbols();
        symbol.setAmPmStrings(this.inputAmPm);
        inputField.setDateFormatSymbols(symbol);
        inputField.setLenient(false);
        try {
            inputField.parse(value);
        }
        catch (ParseException e) {
            throw new InvalidDataException("formatError!" + e.getMessage());
        }
        if (this.inputFormat.indexOf("yyyy") != -1) {
            boolean tmpFlag = false;
            int n = 0;
            for (int i = 0; i < value.length() && !tmpFlag; ++i) {
                if (n == 4) {
                    tmpFlag = true;
                    break;
                }
                if ('0' <= value.charAt(i) && value.charAt(i) <= '9') {
                    ++n;
                    continue;
                }
                n = 0;
            }
            if (!tmpFlag) {
                throw new InvalidDataException("formatError!The year's length must be 4.");
            }
        }
        if (!"TimeType".equalsIgnoreCase(this.type) && this.inputFormat.indexOf("y") == -1 && this.inputFormat.indexOf("M") == -1 && this.inputFormat.indexOf("d") == -1) {
            throw new InvalidDataException("formatError!The inputFormat[" + this.inputFormat + "]don't have the DateFormat while the type is" + this.type + ".");
        }
        if (!("DateType".equalsIgnoreCase(this.type) || this.inputFormat.indexOf("h") != -1 && this.inputFormat.indexOf("H") != -1 || this.inputFormat.indexOf("m") != -1 || this.inputFormat.indexOf("s") != -1)) {
            throw new InvalidDataException("formatError!The inputFormat[" + this.inputFormat + "]don't have the TimeFormat while the type is" + this.type + ".");
        }
        return true;
    }

    public boolean validateStringValue(String value, Locale locale) throws InvalidDataException {
        value = value.trim();
        DateFormat dateformat = null;
        dateformat = "DateType".equalsIgnoreCase(this.type) ? DateFormat.getDateInstance(2, locale) : ("TimeType".equalsIgnoreCase(this.type) ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
        dateformat.setLenient(false);
        try {
            dateformat.parse(value);
        }
        catch (ParseException e) {
            throw new InvalidDataException("formatError!" + e.getMessage());
        }
        return true;
    }

    public String getFormat() {
        return this.inputFormat;
    }

    public String getMax() {
        String ret = null;
        ret = "TimeType".equalsIgnoreCase(this.type) ? (this.inputFormat.indexOf("hh") != -1 ? "12:00:00" : (this.inputFormat.indexOf("KK") != -1 ? "11:59:59" : (this.inputFormat.indexOf("kk") != -1 ? "24:00:00" : "23:59:59"))) : ("DateType".equalsIgnoreCase(this.type) ? "12-31" : (this.inputFormat.indexOf("hh") != -1 ? "12-31 12:00:00" : (this.inputFormat.indexOf("KK") != -1 ? "12-31 11:59:59" : (this.inputFormat.indexOf("kk") != -1 ? "12-31 24:00:00" : "12-31 23:59:59"))));
        return ret;
    }

    public String getMin() {
        String ret = "";
        ret = "TimeType".equalsIgnoreCase(this.type) ? "00:00:00" : ("DateType".equalsIgnoreCase(this.type) ? "01-01" : "01-01 00:00:00");
        return ret;
    }

    public void setInputFormat(String formatName) {
        this.inputFormat = formatName = formatName.trim();
    }

    public void setValueFormat(String formatName) {
        this.valueFormat = formatName = formatName.trim();
    }

    public void setInputAmPm(String value) {
        value = value.trim();
        int idx = value.indexOf("|");
        this.inputAmPm[0] = value.substring(0, idx);
        this.inputAmPm[1] = value.substring(idx + 1);
    }

    public void setValueAmPm(String value) {
        value = value.trim();
        int idx = value.indexOf("|");
        this.valueAmPm[0] = value.substring(0, idx);
        this.valueAmPm[1] = value.substring(idx + 1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public String getInputAmPm() {
        String ret = this.inputAmPm[0];
        ret = ret + "|" + this.inputAmPm[1];
        return ret;
    }

    public String getValueAmPm() {
        String ret = this.valueAmPm[0];
        ret = ret + "|" + this.valueAmPm[1];
        return ret;
    }

    public String getType() {
        return this.type;
    }

    public String getJavaTypeName() {
        return this.type;
    }
}

