/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.component.factory;

import com.ecc.emp.component.ComponentNotDefinedException;
import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.xml.ComponentParser;
import com.ecc.emp.component.xml.ServletContextParser;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.jmx.support.EMPMBeanExportor;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.EMPRequestDispatcher;
import com.ecc.emp.web.servlet.mvc.Controller;
import com.ecc.emp.web.util.FactoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletContextFactory
extends ComponentFactory {
    private static Map contexts = new HashMap();
    private String actionSubDir = "actions";
    private ArrayList actionDocs;

    public ServletContextFactory() {
        ServletContextParser parser = new ServletContextParser();
        parser.setComponentFactory((ComponentFactory)this);
        this.setComponentParser((ComponentParser)parser);
    }

    public static void addContext(String ctxName, Object ctx) {
        contexts.put(ctxName, ctx);
    }

    public static Object getContext(String ctxName) {
        return contexts.get(ctxName);
    }

    public static void removeContext(String ctxName) {
        contexts.remove(ctxName);
    }

    private void addActionDocument(Document doc) {
        if (this.actionDocs == null) {
            this.actionDocs = new ArrayList();
        }
        this.actionDocs.add(doc);
    }

    public ComponentFactory initializeComponentFactory(String name, String fileName) {
        this.setFileName(fileName);
        this.setName(name);
        try {
            this.document = this.loadXMLDocument(fileName);
            ComponentFactory.addComponentFactory((String)name, (ComponentFactory)this);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_COMP_FACTORY, (int)EMPLog.ERROR, (int)0, (String)("ComponentFactory [" + name + "]failed to initialize from [" + fileName + "]!"), (Throwable)e);
        }
        int index = fileName.lastIndexOf("/");
        String actionDirName = fileName.substring(0, index + 1) + this.actionSubDir;
        this.loadAllActions(name, actionDirName);
        return this;
    }

    private void loadAllActions(String ComponentFactoryName, String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File tmpFile = fileList[i];
            if (tmpFile.isDirectory()) {
                this.loadAllActions(ComponentFactoryName, tmpFile.getPath());
                continue;
            }
            try {
                Document tempDocument = this.loadXMLDocument(tmpFile.getPath());
                this.addActionDocument(tempDocument);
                continue;
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_COMP_FACTORY, (int)EMPLog.ERROR, (int)0, (String)("ComponentFactory [" + ComponentFactoryName + "]failed to initialize from [" + tmpFile.getName() + "]!"), (Throwable)e);
            }
        }
    }

    private void parseTheComponent(Object bean, Document doc) throws Exception {
        Element element = doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object aBean;
            Node node = nodeList.item(i);
            if ("classMap".equals(node.getNodeName()) || "mbeanExportor".equals(node.getNodeName()) || node.getNodeType() != 1 || (aBean = this.getComponentParser().parseTheElement(doc, node)) == null) continue;
            this.getComponentParser().addComponentToBean(bean, aBean, node.getNodeName(), this.getNodeAttributeValue("name", node));
            String id = this.getNodeAttributeValue("id", node);
            if (id == null || "false".equals(this.getNodeAttributeValue("singleton", node))) continue;
            this.componentCache.put(id, aBean);
        }
    }

    public void parseTheContext(Object bean) throws Exception {
        if (this.document == null) {
            return;
        }
        if (this.findElementNode(this.document, "mbeanExportor", MBEAN_EXPORTOR) != null) {
            this.mbeanExportor = (EMPMBeanExportor)this.getComponent(MBEAN_EXPORTOR);
        }
        this.parseTheComponent(bean, this.document);
        if (this.actionDocs != null && this.actionDocs.size() > 0) {
            for (int i = 0; i < this.actionDocs.size(); ++i) {
                Document tempDoc = (Document)this.actionDocs.get(i);
                if (tempDoc == null) continue;
                this.parseTheComponent(bean, tempDoc);
            }
        }
    }

    public Object getComponent(Document document, String name) throws ComponentNotDefinedException, Exception {
        if (document == this.document) {
            return super.getComponent(name);
        }
        Node aNode = this.findElementNode(document, name);
        if (aNode == null) {
            return super.getComponent(name);
        }
        if (this.componentParser != null) {
            Object bean = this.componentParser.parseTheElement(document, aNode);
            return bean;
        }
        return null;
    }

    public Node findElementNode(Document doc, String id) {
        Node node;
        int i;
        Element element = doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1 || !id.equals(this.getNodeAttributeValue("id", node))) continue;
            return node;
        }
        if (doc != this.document && this.document != null) {
            element = this.document.getDocumentElement();
            nodeList = element.getChildNodes();
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1 || !id.equals(this.getNodeAttributeValue("id", node))) continue;
                return node;
            }
        }
        return null;
    }

    public String getActionSubDir() {
        return this.actionSubDir;
    }

    public void setActionSubDir(String actionSubDir) {
        this.actionSubDir = actionSubDir;
    }

    public void addToActionsDoc(Document doc, Object obj) throws Exception {
        if (!this.actionDocs.contains(doc)) {
            this.addActionDocument(doc);
        }
        this.parseAndUninstallTheComponent(doc, obj);
    }

    private void parseAndUninstallTheComponent(Document doc, Object bean) throws Exception {
        Element element = doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object aBean;
            Node node = nodeList.item(i);
            if ("classMap".equals(node.getNodeName()) || "mbeanExportor".equals(node.getNodeName()) || node.getNodeType() != 1 || (aBean = this.getComponentParser().parseTheElement(doc, node)) == null) continue;
            EMPRequestDispatcher dispatcher = (EMPRequestDispatcher)FactoryUtil.getFactory(EMPRequestDispatcher.class.getName());
            if (aBean instanceof Controller) {
                dispatcher.removeController((Controller)aBean);
            }
            this.getComponentParser().addComponentToBean(bean, aBean, node.getNodeName(), this.getNodeAttributeValue("name", node));
            String id = this.getNodeAttributeValue("id", node);
            if (id == null || "false".equals(this.getNodeAttributeValue("singleton", node))) continue;
            this.componentCache.put(id, aBean);
        }
    }
}

