/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class UNIDProducer {
    private SecureRandom seeder = new SecureRandom();

    public String getUNID() {
        StringBuffer buf = new StringBuffer();
        long time = System.currentTimeMillis();
        int timeLow = (int)time & 0xFFFFFFFF;
        int node = this.seeder.nextInt();
        String midString = null;
        try {
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            String hexAddress = this.hexFormat(this.getInt(bytes), 8);
            String hash = this.hexFormat(System.identityHashCode(this), 8);
            midString = String.valueOf(hexAddress) + hash;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (midString == null) {
            midString = "0000000000000000";
        }
        buf.append(midString).append(this.hexFormat(timeLow, 8)).append(this.hexFormat(node, 8));
        return buf.toString();
    }

    private String hexFormat(int number, int digits) {
        String hex = Integer.toHexString(number).toUpperCase();
        if (hex.length() >= digits) {
            return hex.substring(0, digits);
        }
        int padding = digits - hex.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < padding) {
            buf.append("0");
            ++i;
        }
        buf.append(hex);
        return buf.toString();
    }

    private int getInt(byte[] bytes) {
        int size = bytes.length > 32 ? 32 : bytes.length;
        int result = 0;
        int i = size - 1;
        while (i >= 0) {
            result = i == size - 1 ? (result += bytes[i]) : (result += bytes[i] << 4 * (size - 1 - i));
            --i;
        }
        return result;
    }
}

