/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dic;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.dic.CMISDataDicMapService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CMISDataDicService
extends EMPService {
    public static String ATTR_ENNAME = "enname";
    public static String ATTR_CNNAME = "cnname";
    private String enNameColumn = "enname";
    private String cnNameColumn = "cnname";
    private String typeColumn = "opttype";
    private String orderByColumn = "orderid";
    private String tableName = "S_DIC";
    private List dataDicMaps;

    public void loadDicData(Context context, Connection connection) throws Exception {
        KeyedCollection dictColl = null;
        try {
            dictColl = (KeyedCollection)context.getDataElement("dictColl");
            dictColl.clear();
        }
        catch (ObjectNotFoundException e) {
            dictColl = new KeyedCollection();
            dictColl.setName("dictColl");
            context.addDataElement((DataElement)dictColl);
        }
        String sqlStr = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            try {
                state = connection.createStatement();
                sqlStr = this.orderByColumn != null ? "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.typeColumn + " from " + this.tableName + " order by " + this.orderByColumn + " , " + this.enNameColumn : "select " + this.enNameColumn + "," + this.cnNameColumn + "," + this.typeColumn + " from " + this.tableName + " order by " + this.enNameColumn;
                rs = state.executeQuery(sqlStr);
                while (rs.next()) {
                    KeyedCollection kColl;
                    String enName = rs.getString(1);
                    String cnName = rs.getString(2);
                    String type = rs.getString(3);
                    if (type.indexOf(".") != -1) {
                        type = type.replace('.', '_');
                    }
                    IndexedCollection iColl = null;
                    if (dictColl.containsKey((Object)type)) {
                        iColl = (IndexedCollection)dictColl.getDataElement(type);
                    } else {
                        iColl = new IndexedCollection();
                        iColl.setName(type);
                        dictColl.addDataElement((DataElement)iColl);
                        kColl = new KeyedCollection();
                        kColl.addDataField(ATTR_ENNAME, null);
                        kColl.addDataField(ATTR_CNNAME, null);
                        iColl.setDataElement((DataElement)kColl);
                    }
                    kColl = (KeyedCollection)iColl.getDataElement().clone();
                    kColl.setName(enName);
                    kColl.setDataValue(ATTR_ENNAME, (Object)enName);
                    kColl.setDataValue(ATTR_CNNAME, (Object)cnName);
                    iColl.addDataElement((DataElement)kColl);
                }
                rs.close();
                rs = null;
                state.close();
                state = null;
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)0, (int)EMPLog.ERROR, (String)("The DataDicService occur an error:" + e.getMessage()));
                throw e;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.dataDicMaps != null && this.dataDicMaps.size() > 0) {
            int i = 0;
            while (i < this.dataDicMaps.size()) {
                CMISDataDicMapService service = (CMISDataDicMapService)((Object)this.dataDicMaps.get(i));
                service.loadDicData(dictColl, connection);
                ++i;
            }
        }
    }

    public List getDataDicMaps() {
        return this.dataDicMaps;
    }

    public void setDataDicMaps(List dataDicMaps) {
        this.dataDicMaps = dataDicMaps;
    }

    public void addCMISDataDicMapService(CMISDataDicMapService service) {
        if (this.dataDicMaps == null) {
            this.dataDicMaps = new ArrayList();
        }
        this.dataDicMaps.add(service);
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getTypeColumn() {
        return this.typeColumn;
    }

    public void setTypeColumn(String typeColumn) {
        this.typeColumn = typeColumn;
    }
}

