/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.web.servlet;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.RequestInterceptor;
import com.ecc.emp.web.servlet.mvc.Controller;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class EMPRequestDispatcher {
    private final List requestInterceptors = new ArrayList();
    private final Map controllers = new HashMap();

    public Controller getController(HttpServletRequest request) {
        int idx;
        String reqURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String reqStr = reqURI;
        if (reqURI.startsWith(contextPath)) {
            reqStr = reqURI.substring(contextPath.length());
        }
        if ((idx = reqStr.lastIndexOf(46)) != -1) {
            reqStr = reqStr.substring(0, idx);
        }
        if (reqStr.startsWith("/")) {
            reqStr = reqStr.substring(1);
        }
        request.setAttribute(EMPConstance.ATTR_ACTIONID, (Object)reqStr);
        return (Controller)this.controllers.get(reqStr);
    }

    public Controller getController(String actionId) {
        return (Controller)this.controllers.get(actionId);
    }

    public List getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public void addController(Controller controller) {
        String controllerName = controller.getName();
        if (this.controllers.get(controllerName) != null) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Duplicated MVC id for [" + controllerName + "]!"));
        }
        this.controllers.put(controller.getName(), controller);
    }

    public void removeController(Controller controller) {
        String controllerName = controller.getName();
        if (this.controllers.get(controllerName) != null) {
            this.controllers.remove(controller.getName());
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Unstall MVC id for [" + controllerName + "]!"));
        }
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    public void setControllerMonitorStarted(boolean value) {
        Object[] keys = this.controllers.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Controller controller = (Controller)this.controllers.get(keys[i]);
            if (value) {
                controller.startMonitor();
            } else {
                controller.stopMonitor();
            }
            ++i;
        }
    }
}

