/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.session;

import com.alibaba.fastjson.JSON;
import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.session.EMPSession;
import com.ecc.emp.session.RedisEMPSessionUtil;
import com.yucheng.cmis.pub.CMISDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisEMPSession
extends EMPSession {
    private String contextNameKey;
    private String keySpecialCharacter;
    private String factoryName;
    private boolean useCache = false;
    private Map<String, Object> attrCache = new HashMap<String, Object>();

    public RedisEMPSession(String sessionId, boolean useCache, String factoryName, String contextNameKey, String keySpecialCharacter) {
        this.setSessionId(sessionId);
        this.useCache = useCache;
        this.factoryName = factoryName;
        this.contextNameKey = contextNameKey;
        this.keySpecialCharacter = keySpecialCharacter;
        this.syncCache(null);
    }

    public void setAttribute(String paramString, Object paramObject) {
        String redisVal = this.object2Str(paramString, paramObject);
        RedisEMPSessionUtil.setSessionAttr(this.getSessionId(), paramString, redisVal);
        this.syncCache(paramString);
    }

    public Object getAttribute(String paramString) {
        if (paramString == null) {
            return null;
        }
        Object attrData = null;
        if (this.useCache) {
            attrData = this.attrCache.get(paramString);
        } else {
            String redisAttrVal = RedisEMPSessionUtil.getSessionAttr(this.getSessionId(), paramString);
            attrData = this.str2Object(paramString, redisAttrVal);
        }
        return attrData;
    }

    public void removeAttribute(String paramString) {
        if (paramString != null) {
            this.attrCache.remove(paramString);
            RedisEMPSessionUtil.removeSessionAttr(this.getSessionId(), paramString);
        }
    }

    public Enumeration getAttributeNames() {
        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)"----", (Throwable)new Exception("Deprecated getAttributeNames()"));
        return null;
    }

    private void syncCache(String paramString) {
        Map<Object, Object> redisAttrs = new HashMap();
        if (paramString != null) {
            String value = RedisEMPSessionUtil.getSessionAttr(this.getSessionId(), paramString);
            redisAttrs.put(paramString, value);
        } else {
            redisAttrs = RedisEMPSessionUtil.getSessionAttrs(this.getSessionId());
        }
        Set<Map.Entry<Object, Object>> entrySet = redisAttrs.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            Object objVal = this.str2Object(key, val);
            this.attrCache.put(key, objVal);
        }
    }

    private String object2Str(String paramString, Object paramObject) {
        String strData = null;
        if (EMPConstance.ATTR_CONTEXT.equals(paramString)) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            Context context = (Context)paramObject;
            this.attrCache.put(EMPConstance.ATTR_CONTEXT, context);
            Set keySet = context.keySet();
            for (Object key : keySet) {
                try {
                    if (key.toString().indexOf(this.keySpecialCharacter) < 0) {
                        Object value = context.getDataValue(key.toString());
                        if (value == null) {
                            valMap.put(key.toString(), value);
                            continue;
                        }
                        Class<?> clazz = value.getClass();
                        if (this.isBasicType(value) || RedisEMPSession.isTypeOf(clazz, List.class) || RedisEMPSession.isTypeOf(clazz, Map.class)) {
                            valMap.put(key.toString(), value);
                            continue;
                        }
                        if (RedisEMPSession.isTypeOf(clazz, CMISDomain.class)) {
                            CMISDomain domain = (CMISDomain)value;
                            valMap.put(key + this.keySpecialCharacter + clazz.getName(), domain.getDataMap());
                            continue;
                        }
                        EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.INFO, (int)0, (String)("----Context[" + key + "=" + value + "] value is not valid type " + this.getId()));
                        continue;
                    }
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)("----Special character '" + this.keySpecialCharacter + "' cannot be used[" + key + "]"));
                }
                catch (Exception e) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)("----Context[" + key + "] getDataValue error " + this.getId()), (Throwable)e);
                }
            }
            valMap.put(this.contextNameKey, context.getName());
            strData = JSON.toJSONString(valMap);
        } else {
            strData = paramObject.toString();
        }
        return strData;
    }

    private Object str2Object(String paramString, String valueString) {
        if (valueString != null && EMPConstance.ATTR_CONTEXT.equals(paramString)) {
            Map<String, Object> contextMapData = this.parseJson2Map(valueString);
            Context context = this.getSessionContext(contextMapData.get(this.contextNameKey).toString());
            context.clear();
            Set<Map.Entry<String, Object>> entrySet = contextMapData.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                context.put((Object)entry.getKey(), entry.getValue());
            }
            return context;
        }
        return valueString;
    }

    private Map<String, Object> parseJson2Map(String jsonData) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        Map dataMap = (Map)JSON.parseObject((String)jsonData, HashMap.class);
        Set keySet = dataMap.keySet();
        for (Object objKey : keySet) {
            String key = objKey.toString();
            Object value = dataMap.get(objKey);
            int indexOf = key.indexOf(":");
            if (indexOf > 0) {
                try {
                    String realKey = key.substring(0, indexOf);
                    String type = key.substring(indexOf + 1);
                    Class<?> clazz = Class.forName(type);
                    if (RedisEMPSession.isTypeOf(clazz, CMISDomain.class)) {
                        CMISDomain domain = (CMISDomain)clazz.newInstance();
                        domain.putData((Map)value);
                        contextData.put(realKey, domain);
                        continue;
                    }
                    contextData.put(realKey, value);
                }
                catch (Exception e) {
                    EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)("----Data convert error " + key), (Throwable)e);
                }
                continue;
            }
            contextData.put(key, value);
        }
        return contextData;
    }

    private Context getSessionContext(String sessionContextName) {
        Context context = (Context)this.attrCache.get(EMPConstance.ATTR_CONTEXT);
        try {
            if (context == null) {
                EMPFlowComponentFactory factory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)this.factoryName);
                context = factory.getContext(null, sessionContextName);
                this.attrCache.put(EMPConstance.ATTR_CONTEXT, context);
                EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.DEBUG, (int)0, (String)("----Create new context[" + sessionContextName + "] " + this.getId()));
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_SESSION_MGR, (int)EMPLog.ERROR, (int)0, (String)("----Create context[" + sessionContextName + "] error " + this.getId()), (Throwable)e);
        }
        return context;
    }

    private boolean isBasicType(Object obj) {
        boolean isBasic = false;
        if (obj instanceof String) {
            isBasic = true;
        } else if (obj instanceof Byte) {
            isBasic = true;
        } else if (obj instanceof Boolean) {
            isBasic = true;
        } else if (obj instanceof Short) {
            isBasic = true;
        } else if (obj instanceof Integer) {
            isBasic = true;
        } else if (obj instanceof Integer) {
            isBasic = true;
        } else if (obj instanceof Long) {
            isBasic = true;
        } else if (obj instanceof Float) {
            isBasic = true;
        } else if (obj instanceof Double) {
            isBasic = true;
        }
        return isBasic;
    }

    private static boolean isTypeOf(Class<?> clazz, Class<?> baseType) {
        return baseType.isAssignableFrom(clazz);
    }
}

