/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.util;

import com.ecc.emp.core.Context;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DuplicatedDataNameException;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.yucheng.cmis.dao.util.PageInfo;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.annotation.CMISDomainAnnotation;
import com.yucheng.cmis.pub.util.StringUtil;
import com.yucheng.cmis.util.DataObjectSwitch;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EUIUtil {
    public static final String RequestParamSearchType = "searchType";
    public static final String SearchType_Quick = "quickquery";
    public static final String QueryListCountType_Every = "every";
    public static final String QueryListCountType_Never = "never";
    public static final int QueryParamMatchType_Equal = 0;
    public static final int QueryParamMatchType_Like = 1;
    public static final int QueryParamMatchType_StartWith = 2;
    public static final int QueryParamMatchType_EndWith = 3;
    public static final int QueryParamMatchType_Array = 4;
    public static final String CTX_KEY_OP_SUCCESS_IND = "CTX_KEY_OP_SUCCESS_IND";
    public static final String CTX_KEY_OP_TOGGLE = "CTX_KEY_OP_TOGGLE";

    public static void putTableData2Context(Context context, List data, PageInfo pageInfo) throws Exception {
        IndexedCollection iColl = DataObjectSwitch.domain2IColl(data, "rows");
        try {
            context.addDataElement((DataElement)iColl);
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (DuplicatedDataNameException e) {
            context.removeDataElement(iColl.getName());
            context.addDataElement((DataElement)iColl);
        }
        if (pageInfo != null) {
            context.put((Object)"total", (Object)pageInfo.recordSize);
            context.put((Object)"page", (Object)pageInfo.pageSize);
        }
    }

    public static void putData2Context(Context context, List<? extends CMISDomain> data, PageInfo pageInfo) throws Exception {
        IndexedCollection iColl = DataObjectSwitch.domain2IColl(data, "rows");
        try {
            context.addDataElement((DataElement)iColl);
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (DuplicatedDataNameException e) {
            context.removeDataElement(iColl.getName());
            context.addDataElement((DataElement)iColl);
        }
        if (pageInfo != null) {
            context.put((Object)"total", (Object)pageInfo.recordSize);
            context.put((Object)"page", (Object)pageInfo.pageSize);
        }
    }

    public static void putData2Context(Context context, CMISDomain data, String kCollName) throws Exception {
        KeyedCollection kcoll = DataObjectSwitch.domain2KColl(data, kCollName);
        try {
            context.addDataElement((DataElement)kcoll);
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (DuplicatedDataNameException e) {
            context.removeDataElement(kcoll.getName());
            try {
                context.addDataElement((DataElement)kcoll);
            }
            catch (DuplicatedDataNameException duplicatedDataNameException) {
                // empty catch block
            }
        }
    }

    public static Object getPojoFromContext(Context context, Object domain) {
        KeyedCollection kCol = null;
        try {
            String namespace = domain.getClass().getName();
            namespace = namespace.substring(namespace.lastIndexOf(".") + 1);
            kCol = (KeyedCollection)context.getDataElement(namespace);
        }
        catch (ObjectNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InvalidArgumentException e1) {
            e1.printStackTrace();
        }
        if (kCol == null) {
            return null;
        }
        Iterator it = kCol.keySet().iterator();
        while (it.hasNext()) {
            Method method;
            Object value;
            block17: {
                String fieldName = it.next().toString();
                value = null;
                try {
                    value = kCol.getDataValue(fieldName);
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                String methodName = "set" + StringUtil.transDBField2MethodNm((String)fieldName);
                method = null;
                Method[] methods = null;
                try {
                    methods = domain.getClass().getMethods();
                    if (methods == null || methods.length <= 0) break block17;
                    int i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equalsIgnoreCase(methodName)) {
                            method = methods[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            if (method == null) continue;
            CMISDomainAnnotation annotation = method.getAnnotation(CMISDomainAnnotation.class);
            String parameterType = annotation.parameterType();
            if (parameterType == null || "".equalsIgnoreCase(parameterType)) {
                parameterType = "1";
            }
            try {
                method.invoke(domain, EUIUtil.tranfserParamType(value, parameterType));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return domain;
    }

    public static Object getPojoFromContext(Context context, String namespace, Object domain) {
        KeyedCollection kCol = null;
        try {
            kCol = (KeyedCollection)context.getDataElement(namespace);
        }
        catch (ObjectNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InvalidArgumentException e1) {
            e1.printStackTrace();
        }
        if (kCol == null) {
            return null;
        }
        Iterator it = kCol.keySet().iterator();
        while (it.hasNext()) {
            Method method;
            Object value;
            block17: {
                String fieldName = it.next().toString();
                value = null;
                try {
                    value = kCol.getDataValue(fieldName);
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                String methodName = "set" + StringUtil.transDBField2MethodNm((String)fieldName);
                method = null;
                Method[] methods = null;
                try {
                    methods = domain.getClass().getMethods();
                    if (methods == null || methods.length <= 0) break block17;
                    int i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equalsIgnoreCase(methodName)) {
                            method = methods[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            if (method == null) continue;
            CMISDomainAnnotation annotation = method.getAnnotation(CMISDomainAnnotation.class);
            String parameterType = annotation.parameterType();
            if (parameterType == null || "".equalsIgnoreCase(parameterType)) {
                parameterType = "1";
            }
            try {
                method.invoke(domain, EUIUtil.tranfserParamType(value, parameterType));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return domain;
    }

    public static Object getPojoListFromContext(Context context, String namespace, Object domain) {
        KeyedCollection kColl = (KeyedCollection)context.getDataElement();
        return EUIUtil.getPojoListFromKColl(kColl, namespace, domain);
    }

    public static Object getPojoListFromContext(Context context, Object domain) {
        KeyedCollection kColl = (KeyedCollection)context.getDataElement();
        return EUIUtil.getPojoListFromKColl(kColl, domain);
    }

    public static Object setLastChgInfo(Context context, CMISDomain domain) throws Exception {
        Date date = new Date();
        SimpleDateFormat sfm = new SimpleDateFormat("HH:mm:ss");
        String time = sfm.format(date);
        domain.getDataMap().put("last_chg_usr", (String)context.getDataValue("currentUserId"));
        domain.getDataMap().put("last_chg_dt", String.valueOf((String)context.getDataValue("OPENDAY")) + " " + time);
        return domain;
    }

    private static Object tranfserParamType(Object paramValue, String paramType) {
        Object result = null;
        if (paramValue != null) {
            if ("1".equalsIgnoreCase(paramType)) {
                result = paramValue;
            } else if ("2".equalsIgnoreCase(paramType)) {
                result = paramValue.toString().trim().equals("") ? null : Integer.valueOf(Integer.parseInt(paramValue.toString()));
            } else if ("3".equalsIgnoreCase(paramType)) {
                result = paramValue.toString().trim().equals("") ? null : Float.valueOf(Float.parseFloat(paramValue.toString()));
            } else if ("4".equalsIgnoreCase(paramType)) {
                result = paramValue.toString().trim().equals("") ? null : Double.valueOf(Double.parseDouble(paramValue.toString()));
            } else if ("5".equalsIgnoreCase(paramType)) {
                result = paramValue.toString().trim().equals("") ? null : new BigDecimal(paramValue.toString());
            } else if ("6".equalsIgnoreCase(paramType)) {
                result = paramValue.toString().trim().equals("") ? null : Boolean.valueOf(Boolean.parseBoolean(paramValue.toString()));
            } else if (!"7".equalsIgnoreCase(paramType)) {
                result = "1".equalsIgnoreCase(paramType) ? paramValue : paramValue;
            }
        }
        return result;
    }

    public static PageInfo assemblePageInfo(Context context, int maxLine) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageSize(String.valueOf(maxLine));
        try {
            String pageSize = (String)context.getDataValue("rows");
            pageInfo.setPageSize(pageSize);
        }
        catch (Exception pageSize) {
            // empty catch block
        }
        try {
            String pageIdx = (String)context.getDataValue("page");
            pageInfo.setPageIdx(pageIdx);
        }
        catch (Exception pageIdx) {
            // empty catch block
        }
        try {
            String recordSize = (String)context.getDataValue("total");
            pageInfo.setRecordSize(recordSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pageInfo.beginIdx = pageInfo.pageSize * (pageInfo.pageIdx - 1) + 1;
        pageInfo.endIdx = pageInfo.pageSize * pageInfo.pageIdx;
        return pageInfo;
    }

    public static Object getPojoListFromKColl(KeyedCollection kColl, String namespace, Object domain) {
        IndexedCollection iCol = null;
        ArrayList<Object> result = null;
        try {
            iCol = (IndexedCollection)kColl.getDataElement(namespace);
        }
        catch (InvalidArgumentException e1) {
            e1.printStackTrace();
        }
        if (iCol == null || iCol.size() <= 0) {
            return null;
        }
        result = new ArrayList<Object>();
        int i = 0;
        while (i < iCol.size()) {
            Object valueObj = null;
            try {
                valueObj = domain.getClass().newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            KeyedCollection kCol = (KeyedCollection)iCol.get(i);
            Iterator it = kCol.keySet().iterator();
            while (it.hasNext()) {
                Method method;
                Object value;
                block20: {
                    String fieldName = it.next().toString();
                    value = null;
                    try {
                        value = kCol.getDataValue(fieldName);
                    }
                    catch (ObjectNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidArgumentException e) {
                        e.printStackTrace();
                    }
                    String methodName = "set" + StringUtil.transDBField2MethodNm((String)fieldName);
                    method = null;
                    Method[] methods = null;
                    try {
                        methods = domain.getClass().getMethods();
                        if (methods == null || methods.length <= 0) break block20;
                        int j = 0;
                        while (j < methods.length) {
                            if (methods[j].getName().equalsIgnoreCase(methodName)) {
                                method = methods[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (method == null) continue;
                CMISDomainAnnotation annotation = method.getAnnotation(CMISDomainAnnotation.class);
                String parameterType = annotation.parameterType();
                if (parameterType == null || "".equalsIgnoreCase(parameterType)) {
                    parameterType = "1";
                }
                try {
                    method.invoke(valueObj, EUIUtil.tranfserParamType(value, parameterType));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            result.add(valueObj);
            ++i;
        }
        return result;
    }

    public static Object getPojoListFromiColl(IndexedCollection iCol, String namespace, Object domain) {
        ArrayList<Object> result = null;
        if (iCol == null || iCol.size() <= 0) {
            return null;
        }
        result = new ArrayList<Object>();
        int i = 0;
        while (i < iCol.size()) {
            Object valueObj = null;
            try {
                valueObj = domain.getClass().newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            KeyedCollection kCol = (KeyedCollection)iCol.get(i);
            Iterator it = kCol.keySet().iterator();
            while (it.hasNext()) {
                Method method;
                Object value;
                block18: {
                    String fieldName = it.next().toString();
                    value = null;
                    try {
                        value = kCol.getDataValue(fieldName);
                    }
                    catch (ObjectNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidArgumentException e) {
                        e.printStackTrace();
                    }
                    String methodName = "set" + StringUtil.transDBField2MethodNm((String)fieldName);
                    method = null;
                    Method[] methods = null;
                    try {
                        methods = domain.getClass().getMethods();
                        if (methods == null || methods.length <= 0) break block18;
                        int j = 0;
                        while (j < methods.length) {
                            if (methods[j].getName().equalsIgnoreCase(methodName)) {
                                method = methods[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (method == null) continue;
                CMISDomainAnnotation annotation = method.getAnnotation(CMISDomainAnnotation.class);
                String parameterType = annotation.parameterType();
                if (parameterType == null || "".equalsIgnoreCase(parameterType)) {
                    parameterType = "1";
                }
                try {
                    method.invoke(valueObj, EUIUtil.tranfserParamType(value, parameterType));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            result.add(valueObj);
            ++i;
        }
        return result;
    }

    public static Object getPojoListFromKColl(KeyedCollection KColl, Object domain) {
        ArrayList<Object> result = null;
        IndexedCollection iCol = null;
        try {
            String namespace = domain.getClass().getName();
            namespace = namespace.substring(namespace.lastIndexOf(".") + 1);
            iCol = (IndexedCollection)KColl.getDataElement(namespace);
        }
        catch (InvalidArgumentException e1) {
            e1.printStackTrace();
        }
        if (iCol == null || iCol.size() <= 0) {
            return null;
        }
        result = new ArrayList<Object>();
        int i = 0;
        while (i < iCol.size()) {
            Object valueObj = null;
            try {
                valueObj = domain.getClass().newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            KeyedCollection kCol = (KeyedCollection)iCol.get(i);
            Iterator it = kCol.keySet().iterator();
            while (it.hasNext()) {
                Method method;
                Object value;
                block20: {
                    String fieldName = it.next().toString();
                    value = null;
                    try {
                        value = kCol.getDataValue(fieldName);
                    }
                    catch (ObjectNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidArgumentException e) {
                        e.printStackTrace();
                    }
                    String methodName = "set" + StringUtil.transDBField2MethodNm((String)fieldName);
                    method = null;
                    Method[] methods = null;
                    try {
                        methods = domain.getClass().getMethods();
                        if (methods == null || methods.length <= 0) break block20;
                        int j = 0;
                        while (j < methods.length) {
                            if (methods[j].getName().equalsIgnoreCase(methodName)) {
                                method = methods[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (method == null) continue;
                CMISDomainAnnotation annotation = method.getAnnotation(CMISDomainAnnotation.class);
                String parameterType = annotation.parameterType();
                if (parameterType == null || "".equalsIgnoreCase(parameterType)) {
                    parameterType = "1";
                }
                try {
                    method.invoke(valueObj, EUIUtil.tranfserParamType(value, parameterType));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            result.add(valueObj);
            ++i;
        }
        return result;
    }

    public static void assembleSearchMapParameter(Context context, Map paramMap) {
        KeyedCollection qryKColl = null;
        KeyedCollection likeKColl = null;
        try {
            if (context.containsKey((Object)"qry")) {
                qryKColl = (KeyedCollection)context.getDataElement("qry");
            }
            if (context.containsKey((Object)"like")) {
                likeKColl = (KeyedCollection)context.getDataElement("like");
            }
            if (qryKColl != null) {
                for (String key : qryKColl.keySet()) {
                    if (qryKColl.get((Object)key) == null || "".equalsIgnoreCase(qryKColl.get((Object)key).toString())) continue;
                    paramMap.put(key, qryKColl.get((Object)key));
                }
            }
            if (likeKColl != null) {
                for (String key : likeKColl.keySet()) {
                    if (likeKColl.get((Object)key) == null || "".equalsIgnoreCase(likeKColl.get((Object)key).toString())) continue;
                    paramMap.put(key, "%" + likeKColl.get((Object)key) + "%");
                }
            }
        }
        catch (ObjectNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void assembleSearchParamerter(Context context, String queryKey, int queryModel, Map paramMap) {
        KeyedCollection kCol = null;
        try {
            kCol = (KeyedCollection)context.getDataElement(queryKey);
            if (kCol != null) {
                for (String key : kCol.keySet()) {
                    if (kCol.get((Object)key) == null || "".equalsIgnoreCase(kCol.get((Object)key).toString().trim())) continue;
                    if (queryModel == 0) {
                        paramMap.put(key, kCol.get((Object)key));
                        continue;
                    }
                    if (queryModel == 1) {
                        paramMap.put(key, "%" + kCol.get((Object)key) + "%");
                        continue;
                    }
                    if (queryModel == 2) {
                        paramMap.put(key, kCol.get((Object)key) + "%");
                        continue;
                    }
                    if (queryModel == 3) {
                        paramMap.put(key, "%" + kCol.get((Object)key));
                        continue;
                    }
                    if (queryModel != 4) continue;
                    String[] arr = kCol.get((Object)key).toString().split(",");
                    paramMap.put(key, arr);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            kCol = null;
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
    }

    public static PageInfo assemblePageInfo(Context context, String countType, int defLine) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageSize(String.valueOf(defLine));
        try {
            String pageSize = (String)context.getDataValue("rows");
            pageInfo.setPageSize(pageSize);
        }
        catch (Exception pageSize) {
            // empty catch block
        }
        try {
            String pageIdx = (String)context.getDataValue("page");
            pageInfo.setPageIdx(pageIdx);
        }
        catch (Exception pageIdx) {
            // empty catch block
        }
        if (QueryListCountType_Never.equals(countType)) {
            pageInfo.setRecordSize("0");
        } else if (QueryListCountType_Every.equals(countType)) {
            pageInfo.setRecordSize("-1");
        } else {
            try {
                String recordSize = (String)context.getDataValue("pageInfo.recordSize");
                pageInfo.setRecordSize(recordSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pageInfo.beginIdx = pageInfo.recordSize * (pageInfo.pageIdx - 1) + 1;
        pageInfo.endIdx = pageInfo.recordSize * pageInfo.pageIdx;
        return pageInfo;
    }

    public static void parsePageInfo(Context context, PageInfo pageInfo) {
        try {
            context.addDataField("total", (Object)String.valueOf(pageInfo.recordSize));
        }
        catch (Exception e) {
            try {
                context.addDataField("total", (Object)String.valueOf(-1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }

    public static void assembleOrderParamerter(Context context, Map paramMap) {
        String order = "";
        String sort = "";
        try {
            order = (String)context.getDataValue("order");
        }
        catch (ObjectNotFoundException ex) {
            order = "asc";
        }
        catch (InvalidArgumentException ex) {
            order = "asc";
        }
        try {
            sort = (String)context.getDataValue("sort");
            if (sort.endsWith("_displayname")) {
                sort = sort.substring(0, sort.indexOf("_displayname"));
            }
        }
        catch (ObjectNotFoundException ex) {
            sort = "";
        }
        catch (InvalidArgumentException ex) {
            sort = "";
        }
        paramMap.put("sort_fields", String.valueOf(sort) + " " + order);
    }

    public static void assembleOrderParamerterForOperModual(Context context, Map paramMap) {
        String order = "";
        String sort = "";
        try {
            order = (String)context.getDataValue("order");
        }
        catch (ObjectNotFoundException ex) {
            order = "desc";
        }
        catch (InvalidArgumentException ex) {
            order = "desc";
        }
        try {
            sort = (String)context.getDataValue("sort");
        }
        catch (ObjectNotFoundException ex) {
            sort = "last_chg_dt";
        }
        catch (InvalidArgumentException ex) {
            sort = "last_chg_dt";
        }
        paramMap.put("sort_fields", String.valueOf(sort) + " " + order);
    }
}

