/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.util;

import com.ecc.emp.core.Context;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.dic.CMISDataDicService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataObjectSwitch {
    public static IndexedCollection domain2IColl(List<? extends CMISDomain> list, String iCollName) throws Exception {
        IndexedCollection retIColl = new IndexedCollection();
        retIColl.setName(iCollName);
        for (CMISDomain cMISDomain : list) {
            retIColl.addDataElement((DataElement)DataObjectSwitch.domain2KColl(cMISDomain, ""));
        }
        return retIColl;
    }

    public static KeyedCollection domain2KColl(CMISDomain domain, String kCollName) throws Exception {
        KeyedCollection retKColl = new KeyedCollection(kCollName);
        if (domain != null) {
            Map map = domain.getDataMap();
            for (String key : map.keySet()) {
                retKColl.put((Object)key, map.get(key));
            }
        }
        return retKColl;
    }

    public static List<CMISDomain> iColl2Domain(IndexedCollection iColl, CMISDomain domain) throws Exception {
        ArrayList<CMISDomain> retList = new ArrayList<CMISDomain>();
        if (iColl == null || domain == null) {
            return retList;
        }
        for (DataElement de : iColl) {
            if (!(de instanceof KeyedCollection)) continue;
            KeyedCollection kColl = (KeyedCollection)de;
            retList.add(DataObjectSwitch.kColl2Domain(kColl, domain));
        }
        return retList;
    }

    public static CMISDomain kColl2Domain(KeyedCollection kColl, CMISDomain domain) throws Exception {
        if (kColl == null || domain == null) {
            return null;
        }
        CMISDomain domain2 = (CMISDomain)domain.getClass().newInstance();
        for (Object obj : kColl.keySet()) {
            if (!(obj instanceof String)) continue;
            String key = (String)obj;
            Object value = kColl.getDataValue(key);
            domain.getDataMap().put(key, value);
        }
        domain2.putData(domain.getDataMap());
        return domain2;
    }

    public static KeyedCollection map2KColl(Map map, String kCollName) throws Exception {
        KeyedCollection retKColl = new KeyedCollection(kCollName);
        if (map == null) {
            return null;
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            retKColl.put((Object)key, value);
        }
        return retKColl;
    }

    public static IndexedCollection map2IColl(List<Map> list, String iCollName) throws Exception {
        IndexedCollection retIColl = new IndexedCollection(iCollName);
        if (list == null) {
            return retIColl;
        }
        for (Map map : list) {
            retIColl.add(DataObjectSwitch.map2KColl(map, ""));
        }
        return retIColl;
    }

    public static List<Map> iColl2Map(IndexedCollection iColl) throws Exception {
        ArrayList<Map> retList = new ArrayList<Map>();
        for (DataElement df : iColl) {
            if (!(df instanceof KeyedCollection)) continue;
            KeyedCollection kColl = (KeyedCollection)df;
            retList.add(DataObjectSwitch.kColl2Map(kColl));
        }
        return retList;
    }

    public static Map kColl2Map(KeyedCollection kColl) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (Object obj : kColl.keySet()) {
            if (!(obj instanceof String)) continue;
            String key = (String)obj;
            Object value = kColl.getDataValue(key);
            retMap.put(key, value);
        }
        return retMap;
    }

    public static void transEnname2Cnname(Context context, List<? extends CMISDomain> domainList, String dicTyp, String columnEnname, String columnCnname) throws Exception {
        if (domainList != null && domainList.size() > 0) {
            for (CMISDomain cMISDomain : domainList) {
                Map dataMap = cMISDomain.getDataMap();
                if (!dataMap.containsKey(columnEnname)) continue;
                if (columnCnname == null || "".equals(columnCnname)) {
                    dataMap.put(String.valueOf(columnEnname) + "_dispalyname", DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(dataMap.get(columnEnname))));
                    continue;
                }
                dataMap.put(columnCnname, DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(dataMap.get(columnEnname))));
            }
        }
    }

    public static void transEnname2Cnname(Context context, CMISDomain domain, String dicTyp, String columnEnname, String columnCnname) throws Exception {
        Map dataMap = domain.getDataMap();
        if (dataMap.containsKey(columnEnname)) {
            if (columnCnname == null || "".equals(columnCnname)) {
                dataMap.put(String.valueOf(columnEnname) + "_dispalyname", DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(dataMap.get(columnEnname))));
            } else {
                dataMap.put(columnCnname, DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(dataMap.get(columnEnname))));
            }
        }
    }

    public static void transEnname2Cnname(Context context, IndexedCollection iColl, String dicTyp, String columnEnname, String columnCnname) throws Exception {
        if (iColl != null && iColl.size() > 0) {
            int i = 0;
            while (i < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(i);
                if (kColl.containsKey((Object)columnEnname)) {
                    if (columnCnname == null || "".equals(columnCnname)) {
                        kColl.put((Object)(String.valueOf(columnEnname) + "_dispalyname"), (Object)DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(kColl.get((Object)columnEnname))));
                    } else {
                        kColl.put((Object)columnCnname, (Object)DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(kColl.get((Object)columnEnname))));
                    }
                }
                ++i;
            }
        }
    }

    public static void transEnname2Cnname(Context context, KeyedCollection kColl, String dicTyp, String columnEnname, String columnCnname) throws Exception {
        if (kColl.containsKey((Object)columnEnname)) {
            if (columnCnname == null || "".equals(columnCnname)) {
                kColl.put((Object)(String.valueOf(columnEnname) + "_dispalyname"), (Object)DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(kColl.get((Object)columnEnname))));
            } else {
                kColl.put((Object)columnCnname, (Object)DataObjectSwitch.getCnnameByEnname(context, dicTyp, String.valueOf(kColl.get((Object)columnEnname))));
            }
        }
    }

    public static String getCnnameByEnname(Context context, String dicTyp, String enname) throws Exception {
        String cnname = "";
        if (enname == null) {
            return null;
        }
        KeyedCollection dictColl = null;
        try {
            dictColl = (KeyedCollection)context.getDataElement("dictColl");
        }
        catch (Exception e) {
            return null;
        }
        IndexedCollection iColl = null;
        if (dictColl.containsKey((Object)dicTyp)) {
            iColl = (IndexedCollection)dictColl.getDataElement(dicTyp);
            int i = 0;
            while (i < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(i);
                if (enname.equals((String)kColl.getDataValue(CMISDataDicService.ATTR_ENNAME))) {
                    cnname = (String)kColl.getDataValue(CMISDataDicService.ATTR_CNNAME);
                    break;
                }
                ++i;
            }
        }
        return cnname;
    }
}

