/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.base;

import com.ecc.emp.core.Context;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.util.FactoryUtil;
import com.yucheng.cmis.base.BusinessInitializer;
import com.yucheng.cmis.base.CMISConstance;
import com.yucheng.cmis.dao.config.SqlConfigLoader;
import com.yucheng.cmis.pub.CMISAgentFactory;
import com.yucheng.cmis.pub.CMISComponentFactory;
import com.yucheng.cmis.pub.CMISDaoFactory;
import com.yucheng.cmis.pub.CMISModuleServiceFactory;
import com.yucheng.cmis.pub.msg.CMISMessageLoader;
import com.yucheng.cmis.pub.util.CMISPropertyManager;
import com.yucheng.cmis.pub.util.ResourceUtils;
import com.yucheng.cmis.pub.util.SetSysInfo;
import com.yucheng.cmis.pub.util.XMLFileUtil;
import java.sql.Connection;
import java.util.Map;
import java.util.MissingResourceException;
import javax.sql.DataSource;

public class CMISBusinessInitializer
implements BusinessInitializer {
    private void loadModuleInitializerCfg(Context rootCtx, Connection connection) throws Exception {
        String dir = CMISPropertyManager.getInstance().getModuleInitializerConfigFileDir();
        dir = ResourceUtils.getFile((String)dir).getAbsolutePath();
        XMLFileUtil xmlFile = new XMLFileUtil();
        Map classMap = xmlFile.loadModuleInitializerCfgFiles(dir);
        EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.DEBUG, (int)0, (String)"\u6a21\u5757\u521d\u59cb\u5316\u673a\u5236\u88ab\u8c03\u7528,\u5f00\u59cb\u89e3\u6790\u5e76\u6267\u884c\u5404\u6a21\u5757\u7684\u521d\u59cb\u5316\u64cd\u4f5c...");
        for (String className : classMap.keySet()) {
            String moudalName = (String)classMap.get(className);
            try {
                BusinessInitializer obj = (BusinessInitializer)Class.forName(className).newInstance();
                obj.initialize(rootCtx, connection);
                EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.DEBUG, (int)0, (String)("\u6267\u884c" + moudalName + "\u7684\u521d\u59cb\u5316\u7c7b\uff1a" + className + " \u6210\u529f!"));
            }
            catch (Exception e) {
                EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.ERROR, (int)0, (String)("\u6267\u884c" + moudalName + "\u7684\u521d\u59cb\u5316\u7c7b\uff1a" + className + " \u5931\u8d25!"), (Throwable)e);
            }
        }
    }

    @Override
    public void initialize(Context rootCtx, Connection connection) throws Exception {
        try {
            CMISConstance.PERMISSIONFILE_PATH = CMISPropertyManager.getInstance().getPermissionFilePath();
            SqlConfigLoader sc = new SqlConfigLoader();
            sc.loadSqlConfig();
            CMISMessageLoader.init(connection);
            CMISComponentFactory.init();
            CMISAgentFactory.init();
            CMISDaoFactory.init();
            CMISModuleServiceFactory.init();
            this.loadModuleInitializerCfg(rootCtx, connection);
            FactoryUtil.addToMap(rootCtx);
            SetSysInfo.init(rootCtx, connection);
        }
        catch (MissingResourceException e) {
            throw new IllegalStateException("cmis.properties\u914d\u7f6e\u51fa\u9519\uff01", e);
        }
    }

    public void addInitAndExec(String dir) throws Exception {
        Context rootCtx = (Context)FactoryUtil.getFactory(Context.class.getName());
        DataSource dataSource = (DataSource)rootCtx.getService("dataSource");
        Connection connection = null;
        connection = ConnectionManager.getConnection((DataSource)dataSource);
        XMLFileUtil xmlFile = new XMLFileUtil();
        Map classMap = xmlFile.loadModuleInitializerCfgFiles(dir);
        if (classMap.keySet().size() == 0) {
            return;
        }
        EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.DEBUG, (int)0, (String)"\u6a21\u5757\u521d\u59cb\u5316\u673a\u5236\u88ab\u8c03\u7528,\u5f00\u59cb\u89e3\u6790\u5e76\u6267\u884c\u5404\u6a21\u5757\u7684\u521d\u59cb\u5316\u64cd\u4f5c...");
        for (String className : classMap.keySet()) {
            String moudalName = (String)classMap.get(className);
            try {
                BusinessInitializer obj = (BusinessInitializer)Class.forName(className).newInstance();
                obj.initialize(rootCtx, connection);
                EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.DEBUG, (int)0, (String)("\u6267\u884c" + moudalName + "\u7684\u521d\u59cb\u5316\u7c7b\uff1a" + className + " \u6210\u529f!"));
            }
            catch (Exception e) {
                EMPLog.log((String)"CMIS_MOD_INIT", (int)EMPLog.ERROR, (int)0, (String)("\u6267\u884c" + moudalName + "\u7684\u521d\u59cb\u5316\u7c7b\uff1a" + className + " \u5931\u8d25!"), (Throwable)e);
            }
        }
    }
}

