/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.base.CMISException;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.util.NewStringUtils;
import com.yucheng.cmis.pub.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComponentHelper {
    public IndexedCollection domain2icol(List list, String modeId) throws CMISException {
        return this.domain2icol(list, modeId, "");
    }

    public IndexedCollection domain2icol(List list, String modeId, String listInd) throws CMISException {
        ArrayList arrlist = (ArrayList)list;
        IndexedCollection icol = new IndexedCollection();
        if ("listInd" == listInd) {
            icol.setName(String.valueOf(modeId) + "List");
        } else {
            icol.setName(modeId);
        }
        CMISDomain domain = null;
        KeyedCollection kcol = null;
        if (arrlist != null) {
            int i = 0;
            while (i < arrlist.size()) {
                if (arrlist.get(i) != null && arrlist.get(i) instanceof CMISDomain) {
                    domain = (CMISDomain)arrlist.get(i);
                    kcol = this.domain2kcol(domain, modeId);
                    icol.add(kcol);
                }
                ++i;
            }
        }
        return icol;
    }

    public List<CMISDomain> icol2domainlist(CMISDomain domain, IndexedCollection icol) throws CMISException {
        KeyedCollection kcol = new KeyedCollection();
        ArrayList<CMISDomain> arrlist = new ArrayList<CMISDomain>();
        if (icol != null || domain != null) {
            int i = 0;
            while (i < icol.size()) {
                kcol = (KeyedCollection)icol.get(i);
                try {
                    domain = this.kcolTOdomain((CMISDomain)domain.getClass().newInstance(), kcol);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                arrlist.add(domain);
                ++i;
            }
        }
        return arrlist;
    }

    public List<CMISDomain> icol2domainlist(String className, IndexedCollection icol) throws CMISException {
        KeyedCollection kcol = new KeyedCollection();
        ArrayList<CMISDomain> arrlist = new ArrayList<CMISDomain>();
        if (icol != null) {
            int i = 0;
            while (i < icol.size()) {
                kcol = (KeyedCollection)icol.get(i);
                try {
                    Class<?> domainClass = Class.forName(className);
                    CMISDomain domain = (CMISDomain)domainClass.newInstance();
                    domain = this.kcolTOdomain((CMISDomain)domain.getClass().newInstance(), kcol);
                    arrlist.add(domain);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return arrlist;
    }

    public KeyedCollection domain2kcol(CMISDomain domain, String modeId) throws CMISException {
        if (domain == null || modeId == null) {
            return null;
        }
        KeyedCollection kCol = null;
        try {
            Class[] returnType = new Class[1];
            kCol = new KeyedCollection();
            kCol.setName(modeId);
            Field[] fields = domain.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                BigDecimal bvalue;
                String str = fields[i].getName();
                StringUtil.getInstance();
                String formatName = StringUtil.AddUnderlineByUppercase((String)str);
                DataField df = new DataField();
                df.setName(formatName);
                String sq = "get" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                Method md = domain.getClass().getDeclaredMethod(sq, new Class[0]);
                returnType[0] = md.getReturnType();
                if (returnType[0].getName().endsWith("String")) {
                    String svalue = (String)md.invoke((Object)domain, new Object[0]);
                    if (svalue != null) {
                        df.setValue(svalue);
                        kCol.addDataField(df);
                    }
                } else if (returnType[0].getName().endsWith("int")) {
                    int ivalue = (Integer)md.invoke((Object)domain, new Object[0]);
                    df.setValue("" + ivalue);
                    kCol.addDataField(df);
                } else if (returnType[0].getName().endsWith("double")) {
                    double dvalue = (Double)md.invoke((Object)domain, new Object[0]);
                    df.setValue("" + dvalue);
                    kCol.addDataField(df);
                } else if (returnType[0].getName().endsWith("BigDecimal") && (bvalue = (BigDecimal)md.invoke((Object)domain, new Object[0])) != null) {
                    df.setValue("" + bvalue);
                    kCol.addDataField(df);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EMPLog.log((String)this.getClass().getName(), (int)EMPLog.INFO, (int)0, (String)e.toString());
            throw new CMISException((Throwable)e);
        }
        return kCol;
    }

    public CMISDomain kcolTOdomain(CMISDomain domain, KeyedCollection kCol) throws CMISException {
        if (kCol.isEmpty() || kCol == null) {
            return null;
        }
        if (domain == null) {
            return null;
        }
        Class[] returnType = new Class[1];
        Field[] fields = domain.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            String str = fields[i].getName();
            StringUtil.getInstance();
            String formatName = StringUtil.AddUnderlineByUppercase((String)str);
            try {
                String sq1 = "get" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                Method md1 = domain.getClass().getDeclaredMethod(sq1, new Class[0]);
                if (md1 != null) {
                    Method md;
                    String sq;
                    returnType[0] = md1.getReturnType();
                    if (returnType[0].getName().endsWith("String")) {
                        sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                        md = domain.getClass().getDeclaredMethod(sq, String.class);
                        String kValue = (String)kCol.getDataValue(formatName);
                        md.invoke((Object)domain, kValue);
                    } else if (returnType[0].getName().endsWith("int")) {
                        sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                        md = domain.getClass().getDeclaredMethod(sq, Integer.TYPE);
                        md.invoke((Object)domain, Integer.parseInt((String)kCol.getDataValue(formatName)));
                    } else if (returnType[0].getName().endsWith("double")) {
                        sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                        md = domain.getClass().getDeclaredMethod(sq, Double.TYPE);
                        md.invoke((Object)domain, Double.parseDouble((String)kCol.getDataValue(formatName)));
                    } else if (returnType[0].getName().endsWith("BigDecimal")) {
                        sq = "set" + str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
                        md = domain.getClass().getDeclaredMethod(sq, BigDecimal.class);
                        String _val = (String)kCol.getDataValue(formatName);
                        if (_val == null || _val.trim().equals("")) {
                            _val = "0";
                        }
                        BigDecimal bv = new BigDecimal((String)kCol.getDataValue(formatName));
                        md.invoke((Object)domain, bv);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return domain;
    }

    public Object kcolTodomain(String className, KeyedCollection kCol) throws ObjectNotFoundException, InvalidArgumentException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Class<?> domainClass = Class.forName(className);
        Object domain = domainClass.newInstance();
        ArrayList<String> datanames = new ArrayList<String>();
        ArrayList<String> methodnames = new ArrayList<String>();
        HashMap<String, String> datanameMap = new HashMap<String, String>();
        HashMap<String, Method> methodnameMap = new HashMap<String, Method>();
        Iterator it = kCol.keySet().iterator();
        while (it.hasNext()) {
            String dataname = it.next().toString();
            String tmpstring = null;
            int t = 0;
            while (t < dataname.length()) {
                if (dataname.charAt(t) != '_') {
                    tmpstring = String.valueOf(tmpstring) + dataname.charAt(t);
                }
                ++t;
            }
            datanames.add(tmpstring.toLowerCase());
            datanameMap.put(tmpstring, dataname);
        }
        Method[] methods = domain.getClass().getDeclaredMethods();
        int j = domain.getClass().getDeclaredMethods().length;
        int i = 0;
        while (i < j) {
            String methodname = methods[i].getName();
            if (methodname.charAt(0) == 's') {
                methodname = methodname.substring(3);
                methodnames.add(methodname.toLowerCase());
                methodnameMap.put(methodname, methods[i]);
            }
            ++i;
        }
        int k = 0;
        while (k < methodnames.size()) {
            String s1 = ((String)datanames.get(k)).toString();
            int l = 0;
            while (l < methodnames.size()) {
                String s2 = ((String)methodnames.get(l)).toString();
                if (s1.equals(s2)) {
                    String s3 = ((String)datanameMap.get(s1)).toString();
                    Method tmpMethod = (Method)methodnameMap.get(s2);
                    tmpMethod.invoke(domain, kCol.getDataValue(s3));
                }
                ++l;
            }
            ++k;
        }
        return domain;
    }

    private Map<String, String> koc2Map(KeyedCollection kcol) {
        HashMap<String, String> toMap = new HashMap<String, String>();
        String key = null;
        String value = null;
        int i = 0;
        while (i < kcol.size()) {
            try {
                key = ((DataField)kcol.getDataElement(i)).getName();
                value = (String)((DataField)kcol.getDataElement(i)).getValue();
            }
            catch (InvalidArgumentException invalidArgumentException) {
                // empty catch block
            }
            toMap.put(key, value);
            ++i;
        }
        return toMap;
    }

    private Map<String, List<Map<String, String>>> kol2Map(KeyedCollection kcol) {
        HashMap<String, List<Map<String, String>>> toMap = new HashMap<String, List<Map<String, String>>>();
        IndexedCollection icol = null;
        KeyedCollection kCol = null;
        String key = null;
        String value = null;
        ArrayList list = new ArrayList();
        String kName = kcol.getName();
        int m = 0;
        while (m < kcol.size()) {
            String subName = String.valueOf(kName.substring(0, kName.length() - 1)) + m;
            icol = (IndexedCollection)kcol.get((Object)subName);
            int i = 0;
            while (i < icol.size()) {
                HashMap<String, String> map = new HashMap<String, String>();
                kCol = (KeyedCollection)icol.get(i);
                int j = 0;
                while (j < kCol.size()) {
                    try {
                        key = ((DataField)kCol.getDataElement(j)).getName();
                        value = (String)((DataField)kCol.getDataElement(j)).getValue();
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        // empty catch block
                    }
                    map.put(key, value);
                    ++j;
                }
                list.add(map);
                ++i;
            }
            toMap.put(subName, list);
            ++m;
        }
        return toMap;
    }

    private List<Map<String, String>> icol2List(IndexedCollection icol) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String key = null;
        String value = null;
        KeyedCollection kCol = new KeyedCollection();
        int i = 0;
        while (i < icol.size()) {
            HashMap<String, String> map = new HashMap<String, String>();
            kCol = (KeyedCollection)icol.get(i);
            int j = 0;
            while (j < kCol.size()) {
                try {
                    key = ((DataField)kCol.getDataElement(j)).getName();
                    value = (String)((DataField)kCol.getDataElement(j)).getValue();
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
                map.put(key, value);
                ++j;
            }
            list.add(map);
            ++i;
        }
        return list;
    }

    private Map<String, Map<String, String>> icol2Map(IndexedCollection icol) {
        HashMap<String, Map<String, String>> toMap = new HashMap<String, Map<String, String>>();
        String key = null;
        String value = null;
        String name = null;
        KeyedCollection kCol = null;
        int i = 0;
        while (i < icol.size()) {
            HashMap<String, String> map = new HashMap<String, String>();
            kCol = (KeyedCollection)icol.get(i);
            name = kCol.getName();
            int j = 0;
            while (j < kCol.size()) {
                try {
                    key = ((DataField)kCol.getDataElement(j)).getName();
                    value = (String)((DataField)kCol.getDataElement(j)).getValue();
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
                map.put(key, value);
                ++j;
            }
            toMap.put(name, map);
            ++i;
        }
        return toMap;
    }

    private IndexedCollection list2Icol(List list) {
        IndexedCollection icol = new IndexedCollection();
        KeyedCollection kc = null;
        DataField df = null;
        List subList = null;
        Map subMap = null;
        try {
            int i = 0;
            while (i < list.size()) {
                subList = (List)list.get(i);
                kc = new KeyedCollection();
                kc.setName("" + i);
                int j = 0;
                while (j < subList.size()) {
                    subMap = (Map)subList.get(j);
                    for (Object k : subMap.keySet()) {
                        df = new DataField();
                        df.setName((String)k);
                        df.setValue(subMap.get(k));
                        kc.addDataField(df);
                    }
                    ++j;
                }
                icol.add(kc);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icol;
    }

    public static int searchArr(String[] rec, String key) {
        int i = 0;
        while (i < rec.length) {
            if (rec[i].equalsIgnoreCase(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isBaseType(String type) {
        boolean bool = false;
        String[] baseTypeStr = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void", "["};
        int i = 0;
        while (i < baseTypeStr.length) {
            if (type.indexOf(baseTypeStr[i]) != -1) {
                bool = true;
            }
            ++i;
        }
        return bool;
    }

    public Object clone() throws CloneNotSupportedException {
        Object result = this.clone();
        return result;
    }

    public List<CMISDomain> icol2domainList4One(CMISDomain domain, IndexedCollection iCol) {
        CMISDomain tempDomain;
        List rtList = null;
        KeyedCollection tempKcol = null;
        try {
            tempDomain = (CMISDomain)domain.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        int i = 0;
        while (i < iCol.size()) {
            if (iCol.get(i) != null && iCol.get(i) instanceof KeyedCollection) {
                tempKcol = (KeyedCollection)iCol.get(i);
                try {
                    tempDomain = this.kcolTOdomain((CMISDomain)domain.clone(), tempKcol);
                    if (tempDomain != null) {
                        rtList.add(tempDomain);
                    }
                }
                catch (CMISException cMISException) {
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return iCol;
    }

    private void fatherToChild(Object father, Object child) throws Exception {
        if (child.getClass().getSuperclass() != father.getClass()) {
            throw new Exception("child\u4e0d\u662ffather\u7684\u5b50\u7c7b");
        }
        Class<?> fatherClass = father.getClass();
        Field[] ff = fatherClass.getDeclaredFields();
        int i = 0;
        while (i < ff.length) {
            Field f = ff[i];
            Class<?> type = f.getType();
            Method m = fatherClass.getMethod("get" + this.upperHeadChar(f.getName()), new Class[0]);
            Object obj = m.invoke(father, new Object[0]);
            f.set(child, obj);
            ++i;
        }
    }

    private String upperHeadChar(String in) {
        String head = in.substring(0, 1);
        String out = String.valueOf(head.toUpperCase()) + in.substring(1, in.length());
        return out;
    }

    public String tabName2modId(String tabName) {
        String modId = "";
        String[] temp = NewStringUtils.split((String)tabName, (String)"_");
        int t = 0;
        while (t < temp.length) {
            modId = String.valueOf(modId) + temp[t].charAt(0) + temp[t].substring(1);
            ++t;
        }
        return modId;
    }

    public String modId2tabName(String modId) {
        return StringUtil.AddUnderlineByUppercase((String)modId);
    }
}

