/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.dbmodel.EMPRestrictException;
import com.ecc.emp.dbmodel.service.TableModelDAO;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.dao.restriction.RecordRestrict;
import com.yucheng.cmis.pub.CMISAgent;
import com.yucheng.cmis.pub.CMISAgentFactory;
import com.yucheng.cmis.pub.CMISComponentFactory;
import com.yucheng.cmis.pub.CMISDao;
import com.yucheng.cmis.pub.CMISDaoFactory;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.exception.AgentException;
import com.yucheng.cmis.pub.exception.ComponentException;
import com.yucheng.cmis.pub.util.TimeUtil;
import com.yucheng.cmis.util.SessionUtil;
import java.sql.Connection;
import java.util.HashMap;
import javax.sql.DataSource;

public class CMISComponent {
    private String id;
    private String describe;
    private Context context;
    private Connection connection;
    private HashMap<String, String> configTable = new HashMap();
    private RecordRestrict restrict = new RecordRestrict();
    private String usrBchId;
    private String usrId;
    private String curTimestamp;
    private String curDate;
    private String openDay;

    public String getUsrBchId() throws ComponentException {
        String tmp_orgid = null;
        tmp_orgid = SessionUtil.getOrganNo();
        return tmp_orgid;
    }

    public void setUsrBchId(String usrBchId) {
        this.usrBchId = usrBchId;
    }

    public String getUsrId() throws ComponentException {
        String tmp_currentuserid = null;
        tmp_currentuserid = SessionUtil.getCurrentUserId();
        return tmp_currentuserid;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setUsrId(String usrId) {
        this.usrId = usrId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public CMISComponent getComponent(String comId) {
        CMISComponent component = null;
        try {
            component = CMISComponentFactory.getComponentFactoryInstance().getComponentInstance(comId, this.context, false, this.connection);
            component.setConnection(this.connection);
        }
        catch (ComponentException e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)("\u7ec4\u4ef6\u5185\u8c03\u7528\u7ec4\u4ef6\u5bf9\u8c61\u751f\u6210\u53d1\u751f\u5f02\u5e38\n" + e.toString()));
        }
        return component;
    }

    public CMISComponent getComponentByClassName(String className) {
        CMISComponent component = null;
        try {
            component = CMISComponentFactory.getComponentFactoryInstance().getComponentByClassName(className, this.context, this.connection);
            component.setConnection(this.connection);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
        return component;
    }

    public CMISComponent getInterfaceWithOldCon(String interfaceId) throws ComponentException {
        CMISComponent interf = CMISComponentFactory.getComponentFactoryInstance().getComponentInterfaceWithOldConnection(interfaceId, this.context, this.connection);
        interf.setConnection(this.connection);
        return interf;
    }

    public void setParameter(HashMap<String, String> configs) {
        this.configTable = configs;
    }

    public String getParameter(String parameterid, String defvalue) {
        String st_val = null;
        st_val = this.configTable != null ? this.configTable.get(parameterid) : null;
        if (st_val == null) {
            st_val = defvalue;
        }
        return st_val;
    }

    public String getParameter(String parameterid) {
        return this.getParameter(parameterid, null);
    }

    protected Connection getConnection() throws ComponentException {
        if (this.connection == null) {
            throw new ComponentException("datasource_error", "\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a");
        }
        return this.connection;
    }

    public CMISAgent getAgentInstance(String agentId) throws AgentException {
        CMISAgent agent = CMISAgentFactory.getAgentFactoryInstance().getAgentInstance(agentId);
        agent.setContext(this.context);
        agent.setConnection(this.connection);
        return agent;
    }

    public CMISComponent getComponentInterface(String interfaceId) throws ComponentException {
        CMISComponent interf = CMISComponentFactory.getComponentFactoryInstance().getComponentInterface(interfaceId, this.context, false, this.connection);
        interf.setConnection(this.connection);
        return interf;
    }

    public CMISComponent getOtherComponentInstance(String componentId) throws ComponentException {
        CMISComponent cmp = CMISComponentFactory.getComponentFactoryInstance().getComponentInstance(componentId, this.context, false, this.getConnection());
        cmp.setConnection(this.connection);
        return cmp;
    }

    public CMISComponent getOtherComponentInstanceWithOldCon(String componentId) throws ComponentException {
        CMISComponent cmp = CMISComponentFactory.getComponentFactoryInstance().getComponentInstanceWithOldCon(componentId, this.context, this.connection);
        cmp.setConnection(this.connection);
        return cmp;
    }

    public String getCurDate() {
        TimeUtil.getInstance();
        return TimeUtil.getCurDate();
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public String getCurTimestamp() {
        TimeUtil.getInstance();
        return TimeUtil.getCurTimeStamp();
    }

    public void setCurTimestamp(String curTimestamp) {
        this.curTimestamp = curTimestamp;
    }

    protected Connection getConnectionFromContext() throws ComponentException {
        try {
            DataSource dataSource = null;
            if (this.context == null) {
                throw new EMPJDBCException("\u7cfb\u7edf\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u6ca1\u6709\u5f97\u5230Context");
            }
            if (dataSource == null) {
                dataSource = (DataSource)this.context.getService("dataSource");
            }
            if (dataSource == null) {
                throw new EMPJDBCException("dataSource is null in :" + this.toString());
            }
            this.connection = ConnectionManager.getConnection(dataSource);
            return this.connection;
        }
        catch (EMPJDBCException e) {
            e.printStackTrace();
            EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.DEBUG, (int)0, (String)e.toString());
            throw new ComponentException("connection_error", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
    }

    public CMISDao getDaoInstance(String daoId) throws ComponentException {
        CMISDao dao = CMISDaoFactory.getDaoFactoryInstance().getDaoInstance(daoId);
        dao.setContext(this.context);
        dao.setConnection(this.connection);
        return dao;
    }

    protected TableModelDAO getTableModelDAO() {
        return (TableModelDAO)((Object)this.context.getService("tableModelDAO"));
    }

    public String[] judgeQueryRestrict(CMISDomain qryParam, Connection conn) throws EMPRestrictException {
        return this.restrict.judgeQueryRestrict(qryParam, conn);
    }

    public boolean judgeUpdateRestrict(CMISDomain updData, boolean autoLoad, Connection conn) throws EMPRestrictException {
        return this.restrict.judgeUpdateRestrict(updData, autoLoad, conn);
    }

    public boolean judgeDeleteRestrict(CMISDomain delData, boolean autoLoad, Connection conn) throws EMPRestrictException {
        return this.restrict.judgeDeleteRestrict(delData, autoLoad, conn);
    }
}

