/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.web.servlet;

import com.ecc.emp.accesscontrol.AccessInfo;
import com.ecc.emp.accesscontrol.AccessManager;
import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.component.factory.ServletContextFactory;
import com.ecc.emp.component.xml.XMLDocumentLoader;
import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.jmx.support.EMPJMXManager;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.session.EMPHttpSession;
import com.ecc.emp.session.Session;
import com.ecc.emp.session.SessionManager;
import com.ecc.emp.web.jsptags.ResourceDefine;
import com.ecc.emp.web.multipart.MultipartHttpServletRequest;
import com.ecc.emp.web.multipart.MultipartResolver;
import com.ecc.emp.web.multipart.UploadStatusListener;
import com.ecc.emp.web.servlet.EMPRequestDispatcher;
import com.ecc.emp.web.servlet.EMPUploadListener;
import com.ecc.emp.web.servlet.Initializer;
import com.ecc.emp.web.servlet.LocaleResolver;
import com.ecc.emp.web.servlet.ModelAndView;
import com.ecc.emp.web.servlet.mvc.BizLogicException;
import com.ecc.emp.web.servlet.mvc.Controller;
import com.ecc.emp.web.servlet.mvc.EMPController;
import com.ecc.emp.web.servlet.mvc.ExceptionHandler;
import com.ecc.emp.web.servlet.view.ExceptionView;
import com.ecc.emp.web.util.FactoryUtil;
import com.yuchenglicense.LicenseVerify;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EMPRequestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String rootPath;
    private Map resources;
    private Initializer initializer;
    private EMPFlowComponentFactory componentFactory;
    private String factoryName;
    private String empIniFileName;
    private ArrayList requestDispatchers;
    private EMPRequestDispatcher defaultDispatcher;
    private String sessionManagerName;
    private SessionManager sessionManager;
    private ExceptionHandler exceptionHandler;
    private AccessManager accessManager;
    private String state = "normal";
    private boolean monitorStarted = false;
    private final AccessInfo accessInfo = new AccessInfo();
    private long alarmResponseTime = 20000L;
    private String licName = "ytec-cmis-plat.lic";
    private String jspRootPath;
    private LocaleResolver localeResolver;
    private MultipartResolver multipartResolver;

    public EMPRequestServlet() {
        this.defaultDispatcher = new EMPRequestDispatcher();
    }

    protected long getLastModified(HttpServletRequest request) {
        String reqURI = request.getRequestURI();
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Get last modify for: " + reqURI));
        try {
            Controller controller = this.defaultDispatcher.getController(request);
            long lastModify = controller.getLastModified(request);
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("last modify for: " + reqURI + "is:" + lastModify));
            return lastModify;
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Get last modify for: " + reqURI + " failed!"), (Throwable)e);
            return -1L;
        }
    }

    protected void addRequiredAttributes(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(EMPConstance.ATTR_RESOURCE, (Object)this.resources);
        request.setAttribute(EMPConstance.ATTR_ROOTPATH, (Object)this.rootPath);
        request.setAttribute(EMPConstance.ATTR_DATA_TYPE, (Object)this.componentFactory.getDataTypeDefine());
        request.setAttribute(EMPConstance.ATTR_SESSION_MGR, (Object)this.sessionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInitialize() {
        if (this.componentFactory == null || this.componentFactory.isClosed()) {
            EMPRequestServlet eMPRequestServlet = this;
            synchronized (eMPRequestServlet) {
                block13: {
                    block12: {
                        block11: {
                            if (this.componentFactory == null || this.componentFactory.isClosed()) break block11;
                            return true;
                        }
                        this.componentFactory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)this.factoryName);
                        if (this.componentFactory != null) break block12;
                        return false;
                    }
                    try {
                        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Share EMP flow Context from: " + this.factoryName));
                        this.componentFactory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)this.factoryName);
                        if (this.componentFactory == null) break block13;
                        try {
                            SessionManager sm;
                            Context context = this.componentFactory.getContextNamed(this.componentFactory.getRootContextName());
                            this.sessionManager = sm = (SessionManager)context.getService(this.sessionManagerName);
                            if (this.initializer != null) {
                                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)"Invoker the Initializer...");
                                this.initializer.initialize(this.componentFactory);
                            }
                        }
                        catch (Exception e) {
                            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to get sessionManager!", (Throwable)e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        block59: {
            long beginTimeStamp;
            Object accessObj;
            ModelAndView mv;
            Controller controller;
            HttpServletRequest theRequest;
            String reqURI;
            block57: {
                reqURI = request.getRequestURI();
                request.setAttribute("emp_request_servlet", (Object)this);
                if (request.getCharacterEncoding() == null) {
                    try {
                        request.setCharacterEncoding("UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.checkInitialize()) {
                    try {
                        this.inInitializing(request, response);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Accept request: " + reqURI));
                theRequest = request;
                controller = null;
                mv = null;
                accessObj = null;
                beginTimeStamp = System.currentTimeMillis();
                if (this.monitorStarted) {
                    this.accessInfo.newAccess();
                }
                controller = this.defaultDispatcher.getController(request);
                if (controller != null) break block57;
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.WARNING, (int)0, (String)("Handler for request " + request.getRequestURI() + " not found!"));
                this.noHandlerFound(request, response);
                if (theRequest instanceof MultipartHttpServletRequest) {
                    MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                    this.multipartResolver.cleanup(mr);
                }
                if (this.accessManager != null && accessObj != null) {
                    this.accessManager.endAccess(accessObj, beginTimeStamp);
                }
                if (controller != null) {
                    controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
                }
                if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                    EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
                }
                if (this.monitorStarted) {
                    this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
                }
                return;
            }
            try {
                Locale locale;
                if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
                    Session session = null;
                    if (this.sessionManager != null) {
                        session = this.sessionManager.getSession((Object)request, (Object)response, false);
                    }
                    if (session == null) {
                        HttpSession hSession = request.getSession(true);
                        session = new EMPHttpSession(hSession);
                    }
                    EMPUploadListener listener = new EMPUploadListener(session);
                    theRequest = this.multipartResolver.resolverMultipart(request, (UploadStatusListener)listener);
                } else {
                    theRequest = request;
                }
                if (this.accessManager != null) {
                    Context sessionContext = null;
                    Session session = null;
                    if (this.sessionManager != null) {
                        session = this.sessionManager.getSession((Object)theRequest, (Object)response, false);
                    }
                    if (session != null) {
                        sessionContext = (Context)session.getAttribute(EMPConstance.ATTR_CONTEXT);
                    }
                    if ((accessObj = this.accessManager.checkAccess(sessionContext, (Object)theRequest, controller.getName())) != null) {
                        this.accessManager.beginAccess(accessObj);
                    }
                }
                this.addRequiredAttributes(theRequest, response);
                if (this.localeResolver != null) {
                    locale = this.localeResolver.resolveLocale(request, response, this.sessionManager);
                    theRequest.setAttribute(EMPConstance.ATTR_LOCALE, (Object)locale);
                }
                mv = controller.doRequest(theRequest, response);
                if (this.localeResolver != null) {
                    locale = this.localeResolver.resolveLocale(request, response, this.sessionManager);
                    theRequest.setAttribute(EMPConstance.ATTR_LOCALE, (Object)locale);
                }
                if (mv != null) {
                    mv.getView().render(mv.getModel(), theRequest, response, this.jspRootPath);
                }
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Process request: " + reqURI + " finished!"));
            }
            catch (Exception e) {
                block58: {
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Process request: " + reqURI + " throws Exception:"), (Throwable)e);
                    Map<String, Object> model = new HashMap<String, void>();
                    if (e instanceof BizLogicException) {
                        model = ((BizLogicException)e).getModel();
                        e = ((BizLogicException)e).getException();
                    }
                    model.put(EMPConstance.ATTR_EXCEPTION, (void)e);
                    if (controller != null && (mv = controller.handleException(request, response, e)) != null) {
                        mv.getView().render(model, request, response, this.jspRootPath);
                        if (theRequest instanceof MultipartHttpServletRequest) {
                            MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                            this.multipartResolver.cleanup(mr);
                        }
                        if (this.accessManager != null && accessObj != null) {
                            this.accessManager.endAccess(accessObj, beginTimeStamp);
                        }
                        if (controller != null) {
                            controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
                        }
                        if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                            EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
                        }
                        if (this.monitorStarted) {
                            this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
                        }
                        return;
                    }
                    try {
                        ExceptionView view;
                        if (this.exceptionHandler == null || (view = this.exceptionHandler.getExceptionView(e)) == null) break block58;
                        view.render(model, request, response, this.jspRootPath);
                    }
                    catch (Throwable throwable) {
                        if (theRequest instanceof MultipartHttpServletRequest) {
                            MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                            this.multipartResolver.cleanup(mr);
                        }
                        if (this.accessManager != null && accessObj != null) {
                            this.accessManager.endAccess(accessObj, beginTimeStamp);
                        }
                        if (controller != null) {
                            controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
                        }
                        if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                            EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
                        }
                        if (this.monitorStarted) {
                            this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
                        }
                        throw throwable;
                    }
                    if (theRequest instanceof MultipartHttpServletRequest) {
                        MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                        this.multipartResolver.cleanup(mr);
                    }
                    if (this.accessManager != null && accessObj != null) {
                        this.accessManager.endAccess(accessObj, beginTimeStamp);
                    }
                    if (controller != null) {
                        controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
                    }
                    if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                        EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
                    }
                    if (this.monitorStarted) {
                        this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
                    }
                    return;
                }
                this.renderException(request, response, e);
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Process request: " + reqURI + " failed!"), (Throwable)e);
                if (theRequest instanceof MultipartHttpServletRequest) {
                    MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                    this.multipartResolver.cleanup(mr);
                }
                if (this.accessManager != null && accessObj != null) {
                    this.accessManager.endAccess(accessObj, beginTimeStamp);
                }
                if (controller != null) {
                    controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
                }
                if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                    EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
                }
                if (this.monitorStarted) {
                    this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
                }
                break block59;
            }
            if (theRequest instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest mr = (MultipartHttpServletRequest)theRequest;
                this.multipartResolver.cleanup(mr);
            }
            if (this.accessManager != null && accessObj != null) {
                this.accessManager.endAccess(accessObj, beginTimeStamp);
            }
            if (controller != null) {
                controller.endRequest(mv, request, System.currentTimeMillis() - beginTimeStamp);
            }
            if (System.currentTimeMillis() - beginTimeStamp > this.alarmResponseTime) {
                EMPJMXManager.sendNotification((Object)((Object)this), (String)this.getServletName(), (String)"error", (String)("Response too low in execute " + reqURI + " used time as:" + (System.currentTimeMillis() - beginTimeStamp)));
            }
            if (this.monitorStarted) {
                this.accessInfo.endAccess(System.currentTimeMillis() - beginTimeStamp);
            }
        }
    }

    protected void renderException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        request.setAttribute(EMPConstance.ATTR_EXCEPTION, (Object)e);
        try {
            String url = "error.jsp";
            RequestDispatcher dispatcher = request.getRequestDispatcher(String.valueOf(this.jspRootPath) + "/" + url);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ee) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to render the Exception!", (Throwable)ee);
        }
    }

    public void addController(Controller controller) {
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Add new Controller " + controller));
        this.defaultDispatcher.addController(controller);
        if (controller instanceof EMPController) {
            EMPController empController = (EMPController)controller;
            empController.setEMPFlowComponentFactory(this.componentFactory);
            empController.setSessionManager(this.sessionManager);
            empController.setRootPath(this.rootPath);
            empController.setJspRootPath(this.jspRootPath);
        }
    }

    public void addRequestDispatcher(RequestDispatcher dispatcher) {
        this.requestDispatchers.add(dispatcher);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String jarPath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
            JarFile jarFile = new JarFile(jarPath);
            Manifest manifest = jarFile.getManifest();
            String version = manifest.getMainAttributes().getValue("Bundle-Version");
            String bundleName = manifest.getMainAttributes().getValue("Bundle-Name");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("The Current " + bundleName + " Version is " + version + "!"));
        }
        catch (IOException e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not find the version info! " + e.getMessage()));
        }
        this.doInit();
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Start up servlet " + config.getServletName() + "OK"));
    }

    private void doInit() throws ServletException {
        this.componentFactory = null;
        String svInfo = this.getServletContext().getServerInfo();
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Server Info: " + svInfo));
        this.rootPath = this.getServletContext().getInitParameter(EMPConstance.SETTINGS_ROOT);
        if (this.rootPath != null && this.rootPath.startsWith("./")) {
            this.rootPath = this.getServletContext().getRealPath("/");
        }
        if (this.rootPath == null) {
            this.rootPath = this.getServletContext().getRealPath("/");
        }
        this.rootPath = this.rootPath.replace('\\', '/');
        this.doCheckLic(this.rootPath);
        if (!this.rootPath.endsWith("/")) {
            this.rootPath = String.valueOf(this.rootPath) + "/";
        }
        this.jspRootPath = this.getInitParameter("jspRootPath");
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Start up servlet " + this.getServletName() + " from rootPath: " + this.rootPath));
        this.factoryName = this.getInitParameter("factoryName");
        this.empIniFileName = this.getInitParameter("iniFile");
        this.sessionManagerName = this.getInitParameter("sessionManager");
        String rootContextName = this.getInitParameter("rootContextName");
        try {
            if (this.empIniFileName != null) {
                this.componentFactory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)this.factoryName);
                if (this.componentFactory != null) {
                    try {
                        SessionManager sm;
                        Context context = this.componentFactory.getContextNamed(rootContextName);
                        this.sessionManager = sm = (SessionManager)context.getService(this.sessionManagerName);
                    }
                    catch (Exception e) {
                        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to get sessionManager!", (Throwable)e);
                    }
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Flow Context from " + this.empIniFileName + "haven been done!"));
                } else {
                    this.componentFactory = new EMPFlowComponentFactory();
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Flow Context from " + this.empIniFileName), null);
                    this.componentFactory.setName(this.factoryName);
                    this.componentFactory.setRootContextName(rootContextName);
                    this.componentFactory.initializeComponentFactory(this.factoryName, String.valueOf(this.rootPath) + this.empIniFileName);
                    try {
                        SessionManager sm;
                        Context context = this.componentFactory.getContextNamed(rootContextName);
                        this.sessionManager = sm = (SessionManager)context.getService(this.sessionManagerName);
                    }
                    catch (Exception e) {
                        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to get sessionManager!", (Throwable)e);
                    }
                }
            } else {
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Share EMP flow Context from: " + this.factoryName));
                this.componentFactory = (EMPFlowComponentFactory)ComponentFactory.getComponentFactory((String)this.factoryName);
                if (this.componentFactory != null) {
                    try {
                        SessionManager sm;
                        Context context = this.componentFactory.getContextNamed(this.componentFactory.getRootContextName());
                        this.sessionManager = sm = (SessionManager)context.getService(this.sessionManagerName);
                    }
                    catch (Exception e) {
                        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to get sessionManager!", (Throwable)e);
                    }
                }
            }
            this.initMVCContext();
            if (this.componentFactory != null && this.initializer != null) {
                EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)"Invoker the Initializer...");
                this.initializer.initialize(this.componentFactory);
            }
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Request Servlet from " + this.empIniFileName + " failed!"), (Throwable)e);
            throw new ServletException("Failed to initialize the EMP context ", (Throwable)e);
        }
        this.resources = (Map)this.getServletContext().getAttribute("resources");
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Request Servlet from " + this.empIniFileName + " OK!"), null);
    }

    private void doCheckLic(String rootPath) {
        String path = String.valueOf(rootPath) + "/" + this.getLicName();
        try {
            LicenseVerify licenseVerify = new LicenseVerify(path);
            if (!licenseVerify.licenseValid()) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"\u4fe1\u8d37\u4e1a\u52a1\u5f00\u53d1\u5e73\u53f0License\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\u4ee5\u514d\u5f71\u54cd\u4f7f\u7528");
                Thread.sleep(5000L);
            }
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)"*************************************************************************************");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)"*\u4fe1\u8d37\u4e1a\u52a1\u5f00\u53d1\u5e73\u53f0\u6388\u6743\u4fe1\u606f\u5982\u4e0b:");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u8bb8\u53ef\u8bc1\u7f16\u53f7:" + licenseVerify.getLicenseCode()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u7f16\u53f7:" + licenseVerify.getProductCode()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u8bb8\u53ef\u8bc1\u7c7b\u578b:" + licenseVerify.getLicenseType()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u4e3b\u7248\u672c\u53f7:" + licenseVerify.getVersionMajor()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u5b50\u7248\u672c\u53f7:" + licenseVerify.getVersionSub()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u53d1\u5e03\u53f7:" + licenseVerify.getVersionPublish()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1\u7f16\u8bd1\u65e5\u671f:" + licenseVerify.getComplieDate()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1License\u8bb8\u53ef\u8bc1\u6709\u6548\u8d77\u59cb\u65e5\u671f:" + licenseVerify.getLicenseStartTime()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)("*    \u4ea7\u54c1License\u8bb8\u53ef\u8bc1\u6709\u6548\u7ec8\u6b62\u65e5\u671f:" + licenseVerify.getLicenseEndTime()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.FATAL, (int)0, (String)"*************************************************************************************");
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"*************************************************************************************");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"*                                                                                    ");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"*\u4fe1\u8d37\u4e1a\u52a1\u5f00\u53d1\u5e73\u53f0License\u6587\u4ef6\u672a\u68c0\u6d4b\u5230\uff0c\u4e3a\u4e86\u4e0d\u5f71\u54cd\u6b63\u5e38\u4f7f\u7528\u786e\u8bc1\u8be5\u6587\u4ef6\u5b58\u5728!!!");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("*\u8bf7\u68c0\u67e5\u76ee\u5f55" + rootPath + "\u4e0b\u662f\u5426\u5b58\u5728\u8bb8\u53ef\u6587\u4ef6" + this.getLicName()));
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"*                                                                                    ");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"*************************************************************************************");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initMVCContext() {
        String servletContextFile = this.getInitParameter("servletContextFile");
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Servlet Context from " + servletContextFile), null);
        ServletContextFactory ctxFactory = new ServletContextFactory();
        ctxFactory.initializeComponentFactory(String.valueOf(this.getServletName()) + "CtxFactory", String.valueOf(this.rootPath) + servletContextFile);
        FactoryUtil.addToMap((Object)ctxFactory);
        FactoryUtil.addToMap(this.defaultDispatcher);
        try {
            ctxFactory.parseTheContext((Object)this);
            ctxFactory.exportMBean((Object)this, this.getServletName());
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Servlet Context from " + servletContextFile + " OK!"), null);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Initialize EMP Servlet Context from " + servletContextFile + " Failed"), (Throwable)e);
        }
    }

    private void initializeExternResource(String fileName) {
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize external resource from " + fileName + " ..."));
        try {
            this.resources = new HashMap();
            XMLDocumentLoader loader = new XMLDocumentLoader();
            Document document = loader.loadXMLDocument(fileName);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && "resource".equals(node.getNodeName())) {
                    try {
                        String resourceId = node.getAttributes().getNamedItem("id").getNodeValue();
                        ResourceDefine res = new ResourceDefine();
                        res.setResourceId(resourceId);
                        this.resources.put(resourceId, res);
                        NodeList childs = node.getChildNodes();
                        int k = 0;
                        while (k < childs.getLength()) {
                            Node childNode = childs.item(k);
                            if (childNode.getNodeType() == 1 && "resourceValue".equals(childNode.getNodeName())) {
                                String lId = childNode.getAttributes().getNamedItem("id").getNodeValue();
                                String value = childNode.getFirstChild().getNodeValue();
                                res.addResource(lId, value);
                            }
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Some thing wrong with externalresource file: " + fileName + " of " + node));
                    }
                }
                ++i;
            }
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Initialize external resource from " + fileName + " OK!"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Initialize external resource from " + fileName + " failed."), (Throwable)e);
        }
    }

    protected void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, request.getRequestURI());
    }

    protected void inInitializing(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(403, "Server in initializing please try again for minutes later.");
    }

    public void destroy() {
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Destory the servlet: " + this.getServletName()));
        if (this.sessionManager != null) {
            this.sessionManager.terminate();
        }
        if (this.empIniFileName != null) {
            this.componentFactory.close();
        }
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    public void setAccessManager(AccessManager accessManager) {
        this.accessManager = accessManager;
    }

    public void restart() {
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Restart [" + this.getServletName() + "] ..."));
        try {
            if (this.componentFactory != null) {
                this.componentFactory.close();
            }
            this.componentFactory = null;
            this.doInit();
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Restart [" + this.getServletName() + "] OK."));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Restart [" + this.getServletName() + "] Failed."), (Throwable)e);
        }
    }

    public void reloadMVCContext() {
        EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Reload MVC context for [" + this.getServletName() + "] ..."));
        try {
            Map sessionMaps = null;
            if (this.getSessionManager() != null) {
                sessionMaps = this.getSessionManager().getSessions();
            }
            this.defaultDispatcher = new EMPRequestDispatcher();
            this.initMVCContext();
            if (this.getSessionManager() != null && sessionMaps != null) {
                this.getSessionManager().setSessions(sessionMaps);
            }
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.INFO, (int)0, (String)("Reload MVC context for [" + this.getServletName() + "] OK."));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Reload MVC context for [" + this.getServletName() + "] Failed."), (Throwable)e);
        }
    }

    public void reloadServlet() {
        if (this.componentFactory != null) {
            this.componentFactory.reloadAllFlow();
        }
        this.reloadMVCContext();
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isMonitorStarted() {
        return this.monitorStarted;
    }

    public void setMonitorStarted(boolean monitorStarted) {
        this.monitorStarted = monitorStarted;
        this.defaultDispatcher.setControllerMonitorStarted(monitorStarted);
    }

    public void startControllerMonitor(String actionId) {
        Controller controller = this.defaultDispatcher.getController(actionId);
        if (controller != null) {
            controller.startMonitor();
        }
    }

    public void stopControllerMonitor(String actionId) {
        Controller controller = this.defaultDispatcher.getController(actionId);
        if (controller != null) {
            controller.stopMonitor();
        }
    }

    public boolean getControllerMonitorState(String actionId) {
        Controller controller = this.defaultDispatcher.getController(actionId);
        if (controller == null) {
            return false;
        }
        return controller.getMonitorState();
    }

    public AccessInfo getControllerAccessInfo(String actionId) {
        Controller controller = this.defaultDispatcher.getController(actionId);
        if (controller == null) {
            return null;
        }
        return controller.getAccessInfo();
    }

    public long getAlarmResponseTime() {
        return this.alarmResponseTime;
    }

    public void setAlarmResponseTime(long alarmResponseTime) {
        this.alarmResponseTime = alarmResponseTime;
    }

    public AccessInfo getAccessInfo() {
        return this.accessInfo;
    }

    public String getLicName() {
        return this.licName;
    }

    public void setLicName(String licName) {
        this.licName = licName;
    }
}

