/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.util;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.log.EMPLog;
import com.yuchenglicense.LicenseVerify;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisLicenseUtil {
    public static final String PLAT_LIC_NAME = "classpath:ytec-cmis-plat.lic";
    public static final String[] MAC_KEYS = new String[]{"MAC", "MAC\u5730\u5740"};
    public static final String MAC_SEPARATOR = "-";
    public static final String LIC_MACS_SPLIT_REGEX = "\\|";

    public static LicenseVerify getLicense(String path) {
        return new LicenseVerify(path);
    }

    public static boolean checkLicenseTime(LicenseVerify licenseVerify) {
        return licenseVerify.licenseValid();
    }

    public static boolean checkLicenseMAC(List<String> licMacList, List<String> serverMacList) {
        if (licMacList == null || licMacList.size() == 0) {
            return true;
        }
        if (serverMacList == null || serverMacList.size() == 0) {
            return false;
        }
        for (String licMac : licMacList) {
            if (!serverMacList.contains(licMac)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getLicenseMAC(LicenseVerify licenseVerify) throws EMPException {
        ArrayList<String> macList = new ArrayList<String>();
        HashMap expendInfo = licenseVerify.getExpendInfo();
        String macRealKey = null;
        Set expendKeySet = expendInfo.keySet();
        for (Object expendKey : expendKeySet) {
            for (String macKey : MAC_KEYS) {
                if (!macKey.equalsIgnoreCase(expendKey.toString().trim())) continue;
                macRealKey = expendKey.toString();
            }
        }
        if (macRealKey == null) {
            return macList;
        }
        Object configMacs = expendInfo.get(macRealKey);
        if (configMacs != null) {
            String[] macs = configMacs.toString().split(LIC_MACS_SPLIT_REGEX);
            for (String mac : macs) {
                macList.add(mac);
            }
        }
        return macList;
    }

    public static List<String> getLocalMAC() throws EMPException {
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresss = ni.getInetAddresses();
                while (addresss.hasMoreElements()) {
                    InetAddress ip = addresss.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    String mac = CmisLicenseUtil.getMACByIp(ip);
                    EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("Local Server MAC: " + ip.getHostAddress() + " -> " + mac));
                    if (mac == null || "".equals(mac.trim())) continue;
                    macs.add(mac);
                }
            }
        }
        catch (Exception e) {
            throw new EMPException((Throwable)e);
        }
        return macs;
    }

    private static String getMACByIp(InetAddress ip) throws SocketException {
        byte[] mac = NetworkInterface.getByInetAddress(ip).getHardwareAddress();
        if (mac == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append(MAC_SEPARATOR);
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().toUpperCase();
    }
}

