/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.restriction;

import com.ecc.emp.dbmodel.EMPRestrictException;
import com.yucheng.cmis.dao.SqlClient;
import com.yucheng.cmis.dao.restriction.ArbitrateRuleInterface;
import com.yucheng.cmis.dao.restriction.CRTemplateInfo;
import com.yucheng.cmis.dao.restriction.CRTemplateInfoLoad;
import com.yucheng.cmis.dao.restriction.CheckTemplate;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.util.SessionUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordRestrict {
    public static final String QUERY_RESTRICT = "query";
    public static final String DELETE_RESTRICT = "delete";
    public static final String UPDATE_RESTRICT = "update";
    private String tableName = null;
    private String moduleId = null;
    private String currentUser = null;
    private String[] currentDutyList = null;
    private String[] currentRoleList = null;
    private String currentOrg = null;
    private String currentMenu = null;
    private String instuCde = null;
    private String managInd = null;
    private String extInd = null;

    public RecordRestrict() {
        this.setCurrentUser(SessionUtil.getCurrentUserId());
        this.setCurrentMenu(SessionUtil.getMenuId());
        this.setCurrentOrg(SessionUtil.getOrganNo());
        this.setCurrentDutyList(SessionUtil.getDutyNoList());
        this.setCurrentRoleList(SessionUtil.getRoleNoList());
        this.setInstuCde(SessionUtil.getInstuCde());
        this.setManagInd(SessionUtil.getManagInd());
        this.setExtInd(SessionUtil.getExtInd());
    }

    public String[] judgeQueryRestrict(CMISDomain qryParam, Connection conn) throws EMPRestrictException {
        this.loadSession2Domain(qryParam);
        this.loadDomain(qryParam);
        String resultSqlCondiId = (String)this.doJudageRestrict(qryParam, QUERY_RESTRICT, conn);
        if (resultSqlCondiId != null) {
            return resultSqlCondiId.split(",");
        }
        return null;
    }

    public boolean judgeUpdateRestrict(CMISDomain updData, boolean autoLoad, Connection conn) throws EMPRestrictException {
        this.loadSession2Domain(updData);
        this.loadDomain(updData);
        if (autoLoad) {
            try {
                CMISDomain _resData = (CMISDomain)SqlClient.queryAuto(updData, conn);
                if (_resData != null) {
                    updData.putData(_resData.getDataMap());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EMPRestrictException(e.getMessage());
            }
        }
        Boolean result = (Boolean)this.doJudageRestrict(updData, UPDATE_RESTRICT, conn);
        return result;
    }

    public boolean judgeDeleteRestrict(CMISDomain delData, boolean autoLoad, Connection conn) throws EMPRestrictException {
        this.loadSession2Domain(delData);
        this.loadDomain(delData);
        if (autoLoad) {
            try {
                CMISDomain _resData = (CMISDomain)SqlClient.queryAuto(delData, conn);
                if (_resData != null) {
                    delData.putData(_resData.getDataMap());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EMPRestrictException(e.getMessage());
            }
        }
        Boolean result = (Boolean)this.doJudageRestrict(delData, DELETE_RESTRICT, conn);
        return result;
    }

    private Object doJudageRestrict(CMISDomain data, String opType, Connection conn) throws EMPRestrictException {
        List<CRTemplateInfo> templateList = this.seekTemplate(data.getModuleId(), opType);
        ArrayList<CheckTemplate> resultList = new ArrayList<CheckTemplate>();
        for (CRTemplateInfo tmp : templateList) {
            if (tmp == null) continue;
            String tmpClass = tmp.getTemplateImplClass();
            try {
                if (tmpClass == null || tmpClass.trim().equals("")) continue;
                CheckTemplate implCheck = (CheckTemplate)Class.forName(tmpClass).newInstance();
                implCheck.doCheck(data, opType, tmp.getBCHField(), tmp.getUSRField(), conn);
                resultList.add(implCheck);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.arbirate(data, opType, resultList);
    }

    private void loadSession2Domain(CMISDomain data) {
        if (data == null) {
            return;
        }
        data.getDataMap().put("currentUserId", this.getCurrentUser());
        data.getDataMap().put("menuId", this.getCurrentMenu());
        data.getDataMap().put("organNo", this.getCurrentOrg());
        data.getDataMap().put("roleNoList", this.getCurrentRoleList());
        data.getDataMap().put("dutyNoList", this.getCurrentDutyList());
        data.getDataMap().put("instuCde", this.getInstuCde());
        data.getDataMap().put("managInd", this.getManagInd());
        data.getDataMap().put("extInd", this.getExtInd());
    }

    private void loadDomain(CMISDomain data) {
        if (data != null) {
            this.setTableName(data.getTableName());
            this.setModuleId(data.getModuleId());
        }
    }

    public List<CRTemplateInfo> seekTemplate(String moduleId, String optype) {
        String _user = this.getCurrentUser();
        String[] _dutyList = this.getCurrentDutyList();
        String[] _roleList = this.getCurrentRoleList();
        String _menu = this.getCurrentMenu();
        String _org = this.getCurrentOrg();
        ArrayList<CRTemplateInfo> selectedTemplate = new ArrayList<CRTemplateInfo>();
        List<CRTemplateInfo> templist = CRTemplateInfoLoad.getTemplateInfoCfgByModuleId(moduleId);
        for (CRTemplateInfo tInfo : templist) {
            String _optype = tInfo.getOpType();
            if (!_optype.equalsIgnoreCase(optype)) continue;
            String _relate = tInfo.getRelationType();
            boolean canforduty = true;
            boolean canforrole = true;
            boolean canformenu = true;
            boolean canfororgn = true;
            boolean canforuser = true;
            if (_relate.equals(CRTemplateInfo.RelationType_OR)) {
                canforduty = false;
                canforrole = false;
                canformenu = false;
                canfororgn = false;
                canforuser = false;
            } else {
                canforduty = true;
                canforrole = true;
                canformenu = true;
                canfororgn = true;
                canforuser = true;
            }
            String _forduty = tInfo.getForDuty();
            String _forrole = tInfo.getForRole();
            String _formenu = tInfo.getForMenu();
            String _forOrgn = tInfo.getForOrgan();
            String _foruser = tInfo.getForUser();
            if (_forduty != null && !_forduty.trim().equals("")) {
                canforduty = false;
                for (String d : _dutyList) {
                    if (d == null || d.trim().equals("") || _forduty.indexOf(d + ",") < 0) continue;
                    canforduty = true;
                    break;
                }
            }
            if (_forrole != null && !_forrole.trim().equals("")) {
                canforrole = false;
                for (String r : _roleList) {
                    if (r == null || r.trim().equals("") || _forrole.indexOf(r + ",") < 0) continue;
                    canforrole = true;
                    break;
                }
            }
            if (_formenu != null && !_formenu.trim().equals("")) {
                canformenu = false;
                if (_formenu.indexOf(_menu + ",") >= 0) {
                    canformenu = true;
                }
            }
            if (_forOrgn != null && !_forOrgn.trim().equals("")) {
                canfororgn = false;
                if (_forOrgn.indexOf(_org + ",") >= 0) {
                    canfororgn = true;
                }
            }
            if (_foruser != null && !_foruser.trim().equals("")) {
                canforuser = false;
                if (_foruser.indexOf(_user + ",") >= 0) {
                    canforuser = true;
                }
            }
            if (_relate.equals(CRTemplateInfo.RelationType_OR)) {
                if (!canforduty && !canforrole && !canformenu && !canfororgn && !canforuser) continue;
                selectedTemplate.add(tInfo);
                continue;
            }
            if (!canforduty || !canforrole || !canformenu || !canfororgn || !canforuser) continue;
            selectedTemplate.add(tInfo);
        }
        if (selectedTemplate.size() > 1) {
            this.removeDefaultRange(selectedTemplate);
        }
        return selectedTemplate;
    }

    private void removeDefaultRange(List<CRTemplateInfo> selectedTemplate) {
        int rIdx = 0;
        for (CRTemplateInfo tInfo : selectedTemplate) {
            if (tInfo.isDefaultRange()) {
                selectedTemplate.remove(rIdx);
                break;
            }
            ++rIdx;
        }
        if (rIdx == selectedTemplate.size()) {
            return;
        }
        this.removeDefaultRange(selectedTemplate);
    }

    private Object arbirate(CMISDomain data, String opType, List<CheckTemplate> resultList) {
        if (resultList == null || resultList.size() <= 0) {
            System.err.println("\u6ca1\u6709\u83b7\u53d6\u6267\u884c\u7ed3\u679c\uff0c\u65e0\u6cd5\u6267\u884c\u4ef2\u88c1");
            return null;
        }
        if (resultList.size() == 1) {
            return resultList.get(0).getCheckResult();
        }
        Object arbirateResult = null;
        String arbirateRule = CRTemplateInfoLoad.getArbitrateRule(data.getModuleId());
        try {
            ArbitrateRuleInterface arbirateImpl;
            if (arbirateRule != null && !arbirateRule.trim().equals("") && CRTemplateInfoLoad.isExtArbitrateRule(arbirateRule) && (arbirateImpl = (ArbitrateRuleInterface)Class.forName(arbirateRule).newInstance()) != null) {
                arbirateResult = arbirateImpl.doArbitrate(data, opType, resultList);
            }
        }
        catch (InstantiationException e) {
            arbirateResult = null;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            arbirateResult = null;
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            arbirateResult = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            arbirateResult = null;
            e.printStackTrace();
        }
        if (arbirateResult == null) {
            System.err.print("\u4f7f\u7528\u7f3a\u7701\u4ef2\u88c1\u89c4\u5219:");
            if (arbirateRule.equals("FIRST")) {
                arbirateResult = resultList.get(0).getCheckResult();
                System.err.println(" FIRST");
            } else if (arbirateRule.equals("LAST")) {
                int lastIdx = resultList.size() - 1;
                arbirateResult = resultList.get(lastIdx).getCheckResult();
                System.err.println(" LAST");
            } else {
                arbirateResult = resultList.get(0).getCheckResult();
                System.err.println(" FIRST");
            }
        }
        return arbirateResult;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public String[] getCurrentDutyList() {
        return this.currentDutyList;
    }

    public void setCurrentDutyList(String[] currentDutyList) {
        this.currentDutyList = currentDutyList;
    }

    public String[] getCurrentRoleList() {
        return this.currentRoleList;
    }

    public void setCurrentRoleList(String[] currentRoleList) {
        this.currentRoleList = currentRoleList;
    }

    public String getCurrentOrg() {
        return this.currentOrg;
    }

    public void setCurrentOrg(String currentOrg) {
        this.currentOrg = currentOrg;
    }

    public String getCurrentMenu() {
        return this.currentMenu;
    }

    public void setCurrentMenu(String currentMenu) {
        this.currentMenu = currentMenu;
    }

    public String getInstuCde() {
        return this.instuCde;
    }

    public void setInstuCde(String instuCde) {
        this.instuCde = instuCde;
    }

    public String getManagInd() {
        return this.managInd;
    }

    public void setManagInd(String managInd) {
        this.managInd = managInd;
    }

    public String getExtInd() {
        return this.extInd;
    }

    public void setExtInd(String extInd) {
        this.extInd = extInd;
    }
}

