/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.config;

import com.yucheng.cmis.dao.builder.SqlBuilderFactory;
import com.yucheng.cmis.dao.config.SqlConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParser {
    private static final String REP_LEFT_Exp = "${";
    private static final String REP_RIGHT_Exp = "}";
    private static final String PARAM_VALUE_REPLACE_FLAG = "?";
    private static final String SORT_FIELD = "sort_fields";
    private static final String SORT_DEFAULT_METHOD = "asc";

    public static String getSql(SqlConfig sqlConfig, Map paramValues, String[] conditionId, String[] pubConditionId) throws SQLException {
        if (sqlConfig == null) {
            return null;
        }
        String configSql = conditionId != null && conditionId.length > 0 ? SqlParser.getOriginSql(sqlConfig, conditionId) : SqlParser.getOriginSql(sqlConfig, paramValues);
        List<HashMap> pubCondiList = sqlConfig.getPubGroupCondition();
        configSql = SqlParser._getOriginSql(configSql, pubCondiList, pubConditionId);
        if (paramValues != null && paramValues.size() > 0) {
            for (String key : paramValues.keySet()) {
                Object value = paramValues.get(key);
                if (value == null) continue;
                if (key.equals(SORT_FIELD) && !value.toString().trim().equals(SORT_DEFAULT_METHOD)) {
                    configSql = SqlBuilderFactory.getBuilder().generateSortSql(configSql, value);
                }
                String keyStr = REP_LEFT_Exp + key + REP_RIGHT_Exp;
                StringBuffer replaceStr = new StringBuffer();
                int iLength = 0;
                if (value.getClass().isArray()) {
                    iLength = ((Object[])value).length;
                }
                if (value instanceof Map) {
                    iLength = ((Map)value).size();
                }
                if (value instanceof List) {
                    iLength = ((List)value).size();
                }
                if (iLength == 0) {
                    replaceStr.append(PARAM_VALUE_REPLACE_FLAG);
                } else if (iLength > 0) {
                    for (int i = 0; i < iLength; ++i) {
                        replaceStr.append(PARAM_VALUE_REPLACE_FLAG);
                        if (i == iLength - 1) continue;
                        replaceStr.append(",");
                    }
                }
                configSql = configSql.replace(keyStr, replaceStr.toString());
            }
        }
        return configSql;
    }

    public static List getParamList(SqlConfig sqlConfig, Map paramValues, String[] conditionId, String[] pubConditionId) throws SQLException {
        ArrayList paramList = new ArrayList();
        String configSql = conditionId != null && conditionId.length > 0 ? SqlParser.getOriginSql(sqlConfig, conditionId) : SqlParser.getOriginSql(sqlConfig, paramValues);
        List<HashMap> pubCondiList = sqlConfig.getPubGroupCondition();
        configSql = SqlParser._getOriginSql(configSql, pubCondiList, pubConditionId);
        int start = 0;
        int end = 0;
        while (start >= 0 && (start = configSql.indexOf(REP_LEFT_Exp, start)) >= 0) {
            end = configSql.indexOf(REP_RIGHT_Exp, start + 1);
            String _field = configSql.substring(start + 2, end);
            Object value = paramValues.get(_field);
            if (value == null) {
                throw new SQLException("\u3010" + sqlConfig.getSqlid() + "\u3011\u5bf9\u5e94\u7684SQL\u53c2\u6570\u3010" + _field + "\u3011\u4f20\u5165\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u66ff\u6362\uff01");
            }
            int iLength = 0;
            if (value.getClass().isArray()) {
                iLength = ((Object[])value).length;
            }
            if (value instanceof Map) {
                iLength = ((Map)value).size();
            }
            if (value instanceof List) {
                iLength = ((List)value).size();
            }
            if (iLength == 0) {
                paramList.add(value);
            } else if (iLength > 0) {
                SqlParser.handleInParamValue(paramList, value);
            }
            start = end;
        }
        return paramList;
    }

    private static void handleInParamValue(List paramList, Object value) {
        int i;
        Object values;
        if (paramList == null) {
            return;
        }
        if (value.getClass().isArray()) {
            values = (Object[])value;
            for (i = 0; i < ((Object)values).length; ++i) {
                paramList.add(values[i]);
            }
        }
        if (value instanceof Map) {
            values = (Map)value;
            for (String key : values.keySet()) {
                paramList.add(values.get(key));
            }
        }
        if (value instanceof List) {
            values = (List)value;
            for (i = 0; i < values.size(); ++i) {
                paramList.add(values.get(i));
            }
        }
    }

    private static List getParamNames(String configSql) {
        ArrayList<String> paramList = new ArrayList<String>();
        int start = 0;
        int end = 0;
        while (start >= 0 && (start = configSql.indexOf(REP_LEFT_Exp, start)) >= 0) {
            end = configSql.indexOf(REP_RIGHT_Exp, start + 1);
            paramList.add(configSql.substring(start + 2, end));
            start = end;
        }
        return paramList;
    }

    private static String _getOriginSql(String sql, List<HashMap> condiGroup, String[] conditionId) {
        String result = sql;
        if (condiGroup != null) {
            for (HashMap group : condiGroup) {
                int suitableCount = 0;
                int firstCondiIdx = 999999;
                int firstSuitCondiIdx = 999999;
                String firstCondiId = "";
                String firstSuitCondiId = "";
                for (String condiId : group.keySet()) {
                    int _cIdx = result.indexOf(REP_LEFT_Exp + condiId + REP_RIGHT_Exp);
                    if (_cIdx != -1 && _cIdx < firstCondiIdx) {
                        firstCondiIdx = _cIdx;
                        firstCondiId = condiId;
                    }
                    if (conditionId == null) continue;
                    for (int n = 0; n < conditionId.length; ++n) {
                        if (!conditionId[n].equals(condiId)) continue;
                        ++suitableCount;
                        if (_cIdx == -1 || _cIdx >= firstSuitCondiIdx) continue;
                        firstSuitCondiIdx = _cIdx;
                        firstSuitCondiId = condiId;
                    }
                }
                String defCondi = (String)group.get("defaultCondition");
                if (suitableCount == 0) {
                    for (String condiId : group.keySet()) {
                        if (firstCondiId != null && firstCondiId.trim().equals(condiId) && defCondi != null) {
                            result = result.replace(REP_LEFT_Exp + condiId + REP_RIGHT_Exp, defCondi);
                            continue;
                        }
                        result = result.replace(REP_LEFT_Exp + condiId + REP_RIGHT_Exp, "");
                    }
                    continue;
                }
                for (String condiId : group.keySet()) {
                    boolean inGroup = false;
                    for (int n = 0; n < conditionId.length; ++n) {
                        if (!conditionId[n].equals(condiId)) continue;
                        inGroup = true;
                        String optCondi = (String)group.get(condiId);
                        if (firstSuitCondiId != null && firstSuitCondiId.trim().equals(condiId) && defCondi != null) {
                            optCondi = optCondi.substring(3);
                        }
                        result = result.replace(REP_LEFT_Exp + condiId + REP_RIGHT_Exp, optCondi);
                    }
                    if (inGroup) continue;
                    result = result.replace(REP_LEFT_Exp + condiId + REP_RIGHT_Exp, "");
                }
            }
        }
        return result;
    }

    private static boolean isMatchOptCondition(String condiId, String[] conditionId) {
        boolean result = false;
        if (conditionId != null && condiId != null) {
            for (int n = 0; n < conditionId.length; ++n) {
                if (!conditionId[n].equals(condiId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getOriginSql(SqlConfig sqlConfig, String[] conditionId) throws SQLException {
        if (sqlConfig == null) {
            return null;
        }
        String result = "";
        result = new String(sqlConfig.getSql());
        List<HashMap> condiGroup = sqlConfig.getGroupCondition();
        result = SqlParser._getOriginSql(result, condiGroup, conditionId);
        return result;
    }

    public static String getOriginSql(SqlConfig sqlConfig, Map paramsContainer) throws SQLException {
        if (sqlConfig == null) {
            return null;
        }
        String result = "";
        result = new String(sqlConfig.getSql());
        List<HashMap> condiGroup = sqlConfig.getGroupCondition();
        for (HashMap group : condiGroup) {
            Iterator itr = group.keySet().iterator();
            int firstCondiIdx = 999999;
            String firstCondiId = "";
            ArrayList<String> selectCondiIdList = new ArrayList<String>();
            ArrayList<String> noSelectCondiIdList = new ArrayList<String>();
            while (itr.hasNext()) {
                String optCondi;
                String condiId = (String)itr.next();
                if (condiId.trim().equals("defaultCondition")) continue;
                int _cIdx = SqlParser.getPositionOfCondiId(result, condiId);
                if (_cIdx != -1 && _cIdx < firstCondiIdx) {
                    firstCondiIdx = _cIdx;
                    firstCondiId = condiId;
                }
                if (SqlParser.isMatchOptCondi(optCondi = (String)group.get(condiId), paramsContainer)) {
                    selectCondiIdList.add(condiId);
                    continue;
                }
                noSelectCondiIdList.add(condiId);
            }
            firstCondiIdx = 99999;
            String firstSuitCondiId = "";
            for (String _condiId : selectCondiIdList) {
                int _cIdx = SqlParser.getPositionOfCondiId(result, _condiId);
                if (_cIdx == -1 || _cIdx >= firstCondiIdx) continue;
                firstCondiIdx = _cIdx;
                firstSuitCondiId = _condiId;
            }
            String defCondi = (String)group.get("defaultCondition");
            for (String _condiId : selectCondiIdList) {
                String optCondi = (String)group.get(_condiId);
                if (firstSuitCondiId != null && firstSuitCondiId.trim().equals(_condiId) && defCondi != null) {
                    optCondi = optCondi.substring(3);
                }
                result = result.replace(REP_LEFT_Exp + _condiId + REP_RIGHT_Exp, optCondi);
            }
            for (String _condiId : noSelectCondiIdList) {
                if (selectCondiIdList.size() == 0 && firstCondiId != null && firstCondiId.trim().equals(_condiId) && defCondi != null) {
                    result = result.replace(REP_LEFT_Exp + _condiId + REP_RIGHT_Exp, defCondi);
                    continue;
                }
                result = result.replace(REP_LEFT_Exp + _condiId + REP_RIGHT_Exp, "");
            }
        }
        return result;
    }

    private static boolean isMatchOptCondi(String optCondition, Map paramsContainer) {
        if (optCondition == null || optCondition.trim().equals("")) {
            return true;
        }
        if (paramsContainer == null || paramsContainer.keySet().size() <= 0) {
            return false;
        }
        boolean result = true;
        ArrayList optParamList = (ArrayList)SqlParser.getParamNames(optCondition);
        for (String optParam : optParamList) {
            if (paramsContainer.containsKey(optParam)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static int getPositionOfCondiId(String orginSql, String condiId) {
        int _cIdx = orginSql.indexOf(REP_LEFT_Exp + condiId + REP_RIGHT_Exp);
        return _cIdx;
    }
}

