/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.builder;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.dao.builder.SqlBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonSqlBuilder
implements SqlBuilder {
    public String generateSelectByIdSql(Object entity) {
        return "";
    }

    public String generatePaginateSql(String sql, int pageNumber, int pageSize) {
        int startRow = (pageNumber - 1) * pageSize + 1;
        int endRow = pageNumber * pageSize;
        StringBuffer pagingSelect = new StringBuffer(2560);
        pagingSelect.append("select * from (  select T.*, rownum  rownum_ from ( ");
        pagingSelect.append(sql);
        pagingSelect.append("  ) T ) where rownum_ <= ").append(endRow).append(" and rownum_ >= ").append(startRow);
        return pagingSelect.toString();
    }

    public String generateSortSql(String sql, Object value) {
        StringBuffer pagingSelect = new StringBuffer(2560);
        pagingSelect.append(sql);
        if (this.orderByValidate(value.toString())) {
            sql = sql.replaceAll(" +", " ");
            int i = sql.lastIndexOf("order by ");
            int j = sql.lastIndexOf("\\)");
            if (j != -1 && i != -1) {
                if (i < j) {
                    pagingSelect.append(" , ").append(value);
                }
            } else if (i != -1 && j == -1) {
                pagingSelect.append(" , ").append(value);
            } else {
                pagingSelect.append(" order by ").append(value);
            }
            EMPLog.log((String)"SQL", (int)EMPLog.DEBUG, (int)0, (String)("----->>\u6dfb\u52a0\u6392\u5e8f\u5b57\u6bb5\u524d\uff0cSQL\u8bed\u53e5\u4e3a\u3010" + sql + "\u3011"));
            EMPLog.log((String)"SQL", (int)EMPLog.DEBUG, (int)0, (String)("----->>\u6dfb\u52a0\u6392\u5e8f\u5b57\u6bb5\u540e\uff0cSQL\u8bed\u53e5\u4e3a\u3010" + pagingSelect + "\u3011"));
        } else {
            EMPLog.log((String)"SQL", (int)EMPLog.ERROR, (int)0, (String)("----->>\u6dfb\u52a0\u7684\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5408\u6cd5\uff0c\u4e0d\u8fdb\u884c\u62fc\u63a5: " + value));
        }
        return pagingSelect.toString();
    }

    public boolean orderByValidate(String orderBy) {
        String[] orders;
        if (orderBy == null || "".equals(orderBy.trim())) {
            return true;
        }
        for (String order : orders = orderBy.split(",")) {
            String type;
            String field;
            String[] items = order.trim().split("\\s+|\\t+");
            if (items.length > 2) {
                return false;
            }
            if (items.length >= 1 && ("and".equalsIgnoreCase((field = items[0]).trim()) || "or".equalsIgnoreCase(field.trim()))) {
                return false;
            }
            if (items.length < 2 || "asc".equalsIgnoreCase(type = items[1]) || "desc".equals(type)) continue;
            return false;
        }
        return true;
    }

    public String generateCountSql(String sql) {
        StringBuffer pagingSelect = new StringBuffer(2560);
        pagingSelect.append(" select count(*) qty from (").append(sql).append(") p");
        return pagingSelect.toString();
    }

    public String generateInsertSql(Object entity) {
        return "";
    }

    public String generateUpdateByIdSql(Object entity) {
        return "";
    }

    public String generateDeleteByIdSql(Object entity) {
        return "";
    }

    public BigDecimal transSequeneValueTyp(Object seqVal) {
        if (seqVal == null) {
            return null;
        }
        return (BigDecimal)seqVal;
    }

    private class SQL {
        private static final int DELETE = 3;
        private static final int INSERT = 2;
        private static final int SELECT = 1;
        private static final int UPDATE = 0;
        private int statementType = 4;
        private List sets = new ArrayList();
        private List select = new ArrayList();
        private List tables = new ArrayList();
        private List where = new ArrayList();
        private List columns = new ArrayList();
        private List values = new ArrayList();

        private SQL() {
        }

        private void sqlClause(StringBuffer buffer, String keyword, List parts, String open, String close, String conjunction) {
            if (!parts.isEmpty()) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(keyword);
                buffer.append(" ");
                buffer.append(open);
                int n = parts.size();
                for (int i = 0; i < n; ++i) {
                    String part = (String)parts.get(i);
                    if (i > 0 && !"".equals(conjunction)) {
                        buffer.append(conjunction);
                    }
                    buffer.append(part);
                }
                buffer.append(close);
            }
        }

        private String selectSQL() {
            StringBuffer buffer = new StringBuffer();
            this.sqlClause(buffer, "SELECT", this.select, "", "", ", ");
            this.sqlClause(buffer, "FROM", this.tables, "", "", ", ");
            this.sqlClause(buffer, "WHERE", this.where, "(", ")", "");
            return buffer.toString();
        }

        private String insertSQL() {
            StringBuffer buffer = new StringBuffer();
            this.sqlClause(buffer, "INSERT INTO", this.tables, "", "", "");
            this.sqlClause(buffer, "", this.columns, "(", ")", ", ");
            this.sqlClause(buffer, "VALUES", this.values, "(", ")", ", ");
            return buffer.toString();
        }

        private String deleteSQL() {
            StringBuffer buffer = new StringBuffer();
            this.sqlClause(buffer, "DELETE FROM", this.tables, "", "", "");
            this.sqlClause(buffer, "WHERE", this.where, "(", ")", "");
            return buffer.toString();
        }

        private String updateSQL() {
            StringBuffer buffer = new StringBuffer();
            this.sqlClause(buffer, "UPDATE", this.tables, "", "", "");
            this.sqlClause(buffer, "SET", this.sets, "", "", ", ");
            this.sqlClause(buffer, "WHERE", this.where, "(", ")", "");
            return buffer.toString();
        }

        private String createSql() {
            String answer;
            switch (this.statementType) {
                case 3: {
                    answer = this.deleteSQL();
                    break;
                }
                case 2: {
                    answer = this.insertSQL();
                    break;
                }
                case 1: {
                    answer = this.selectSQL();
                    break;
                }
                case 0: {
                    answer = this.updateSQL();
                    break;
                }
                default: {
                    answer = null;
                }
            }
            return answer;
        }
    }
}

