/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.cache.util;

import com.yucheng.cmis.cache.taskqueue.domain.QueueQueryDomain;
import com.yucheng.cmis.dao.test.SUser;
import com.yucheng.cmis.pub.CMISDomain;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueueUtil {
    public static <T extends CMISDomain> List<T> sort(List<T> srcList, String sortField, String sortType) {
        Collections.sort(srcList, new QueueCompare(sortField));
        if (sortType.equals("ASC")) {
            return srcList;
        }
        LinkedList<T> retList = new LinkedList<T>();
        for (int i = srcList.size() - 1; i >= 0; --i) {
            retList.add(srcList.get(i));
        }
        srcList = retList;
        return retList;
    }

    public static <T extends CMISDomain> List<T> filter(List<T> srcList, List<QueueQueryDomain> queryList) {
        LinkedList<CMISDomain> retList = new LinkedList<CMISDomain>();
        boolean flag = true;
        for (CMISDomain domain : srcList) {
            for (QueueQueryDomain queryDomaon : queryList) {
                Object val = domain.getDataMap().get(queryDomaon.getQueryFieldName());
                if (val == null) {
                    flag = false;
                    continue;
                }
                String queryType = queryDomaon.getQueryType();
                Object filterValue = queryDomaon.getQueryFieldValue();
                if (queryType.equals("IN") && !String.valueOf(val).contains(filterValue.toString())) {
                    flag = false;
                    continue;
                }
                if (queryType.equals("=")) {
                    if (TaskQueueUtil.compare(val, filterValue) == 0) continue;
                    flag = false;
                    continue;
                }
                if (queryType.equals("<")) {
                    if (TaskQueueUtil.compare(val, filterValue) < 0) continue;
                    flag = false;
                    continue;
                }
                if (!queryType.equals(">") || TaskQueueUtil.compare(val, filterValue) > 0) continue;
                flag = false;
            }
            if (flag) {
                retList.add(domain);
            }
            flag = true;
        }
        srcList.clear();
        srcList.addAll(retList);
        return srcList;
    }

    private static int compare(Object v1, Object v2) {
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 != null && v2 == null) {
            return 1;
        }
        if (v1 instanceof String && v2 instanceof String) {
            String i1 = (String)v1;
            String i2 = (String)v2;
            return i1.compareTo(i2);
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            Integer i1 = (Integer)v1;
            Integer i2 = (Integer)v2;
            return i1.compareTo(i2);
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            Double i1 = (Double)v1;
            Double i2 = (Double)v2;
            return i1.compareTo(i2);
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            BigDecimal i1 = (BigDecimal)v1;
            BigDecimal i2 = (BigDecimal)v2;
            return i1.compareTo(i2);
        }
        String str1 = v1.toString();
        String str2 = v2.toString();
        return str1.compareTo(str2);
    }

    public static void main(String[] args) {
        Date date = new Date();
        LinkedList<SUser> l = new LinkedList<SUser>();
        SUser u = new SUser();
        u.setBirthday("2016-12-19");
        u.setOrgid("\u4e0a\u6d77");
        u.setInteger(12);
        u.setFloat(Float.valueOf(13.0f));
        u.setDouble(14.0);
        u.setBigDecimal(new BigDecimal(16));
        u.setBoolean(true);
        u.setDate(date);
        l.add(u);
        u = new SUser();
        u.setBirthday("2016-03-19");
        u.setOrgid("\u5317\u4eac");
        u.setInteger(13);
        u.setFloat(Float.valueOf(13.0f));
        u.setDouble(14.0);
        u.setBigDecimal(new BigDecimal(16));
        u.setBoolean(true);
        u.setDate(date);
        l.add(u);
        u = new SUser();
        u.setBirthday("2016-06-20");
        u.setOrgid("\u5e7f\u5dde");
        u.setInteger(11);
        u.setFloat(Float.valueOf(15.0f));
        u.setDouble(14.0);
        u.setBigDecimal(new BigDecimal(16));
        u.setBoolean(false);
        u.setDate(date);
        l.add(u);
        TaskQueueUtil.sort(l, "integer", "DESC");
        for (int i = 0; i < l.size(); ++i) {
            u = (SUser)((Object)l.get(i));
            System.out.println(u.getDataMap());
        }
        ArrayList<QueueQueryDomain> queryLis = new ArrayList<QueueQueryDomain>();
        QueueQueryDomain domain = new QueueQueryDomain();
        domain.setQueryType(">");
        domain.setQueryFieldName("float");
        domain.setQueryFieldValue(Float.valueOf(14.0f));
        queryLis.add(domain);
        TaskQueueUtil.filter(l, queryLis);
        System.out.println("===============");
        for (int i = 0; i < l.size(); ++i) {
            u = (SUser)((Object)l.get(i));
            System.out.println(u.getDataMap());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueueCompare
    implements Comparator<CMISDomain> {
        private String sortField = null;

        QueueCompare(String sortField) {
            this.sortField = sortField;
        }

        @Override
        public int compare(CMISDomain o1, CMISDomain o2) {
            Object v1 = o1.getDataMap().get(this.sortField);
            Object v2 = o2.getDataMap().get(this.sortField);
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            return TaskQueueUtil.compare(v1, v2);
        }
    }
}

