/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.cache.util;

import com.yucheng.cmis.cache.taskqueue.domain.TaskPoolDomain;
import com.yucheng.cmis.cache.taskqueue.domain.UserQueueDomain;
import com.yucheng.cmis.exception.CmisDaoException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISDaoPropertyManager {
    private static Map<String, UserQueueDomain> userQueueConfMap = new HashMap<String, UserQueueDomain>();
    private static Map<String, TaskPoolDomain> taskPoolConfMap = new HashMap<String, TaskPoolDomain>();
    private static ResourceBundle res = null;
    private static String FILE_NAME = "cmis-dao";
    private static String SEPARATOR = "\\|";
    private static Map<String, String> cfgMap = new HashMap<String, String>();
    private static Map<String, List<String>> flagMap = new HashMap<String, List<String>>();
    private static CMISDaoPropertyManager confObj = null;

    private CMISDaoPropertyManager() {
    }

    public static CMISDaoPropertyManager getInstance() throws CmisDaoException {
        if (confObj == null) {
            confObj = new CMISDaoPropertyManager();
            confObj.loadConfigOnce();
        }
        return confObj;
    }

    public void loadConfigOnce() throws CmisDaoException {
        res = ResourceBundle.getBundle(FILE_NAME);
        Set<String> keySet = res.keySet();
        for (String proKey : keySet) {
            cfgMap.put(proKey, res.getString(proKey));
        }
        int i = 1;
        while (this.loadUserQueue(i)) {
            ++i;
        }
        int j = 1;
        while (this.loadTaskPool(j)) {
            ++j;
        }
    }

    public String getPropertyValue(String key) {
        return cfgMap.get(key);
    }

    public List<String> getPoolFlagList(String poolType) {
        return flagMap.get(poolType);
    }

    public Map<String, UserQueueDomain> getUserQueues() {
        return userQueueConfMap;
    }

    public UserQueueDomain getUserQueue(String queueType) {
        return userQueueConfMap.get(queueType);
    }

    public Map<String, TaskPoolDomain> getTaskPools() {
        return taskPoolConfMap;
    }

    public TaskPoolDomain getTaskPool(String poolType) {
        return taskPoolConfMap.get(poolType);
    }

    private boolean loadUserQueue(int i) throws CmisDaoException {
        try {
            String userQueueName = "user.queue.type" + String.valueOf(i);
            String queue = res.getString(userQueueName);
            if (queue == null || queue.trim().equals("")) {
                return false;
            }
            String[] strs = queue.split(SEPARATOR);
            if (strs.length != 6) {
                throw new CmisDaoException("\u7528\u6237\u961f\u5217\u5b9a\u4e49\u4e0d\u6b63\u786e:user.queue.type" + String.valueOf(i) + "=" + queue);
            }
            UserQueueDomain domain = new UserQueueDomain();
            domain.setUserQueueName(queue);
            domain.setQueueName(strs[0]);
            domain.setQueueType(strs[1]);
            domain.setQueueDeep(Integer.parseInt(strs[2]));
            domain.setSort(Boolean.parseBoolean(strs[3]));
            domain.setWarningDeep(Integer.parseInt(strs[4]));
            domain.setStatus(strs[5]);
            userQueueConfMap.put(userQueueName, domain);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean loadTaskPool(int i) throws CmisDaoException {
        try {
            String userQueueName = "task.pool.type" + String.valueOf(i);
            String queue = res.getString(userQueueName);
            if (queue == null || queue.trim().equals("")) {
                return false;
            }
            String[] strs = queue.split(SEPARATOR);
            if (strs.length != 7) {
                throw new CmisDaoException("\u4efb\u52a1\u6c60\u5b9a\u4e49\u4e0d\u6b63\u786e:user.queue.type" + String.valueOf(i) + "=" + queue);
            }
            TaskPoolDomain domain = new TaskPoolDomain();
            domain.setTaskPoolName(queue);
            domain.setPoolName(strs[0]);
            domain.setPoolType(strs[1]);
            domain.setPoolDeep(Integer.parseInt(strs[2]));
            domain.setClaimType(strs[3]);
            domain.setSort(Boolean.parseBoolean(strs[4]));
            domain.setWarningDeep(Integer.parseInt(strs[5]));
            domain.setStatus(strs[6]);
            taskPoolConfMap.put(userQueueName, domain);
            LinkedList list = new LinkedList();
            flagMap.put(userQueueName, list);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

