/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.config;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.config.SqlConfig;
import com.yucheng.cmis.dao.config.SqlConfigBuffer;
import com.yucheng.cmis.exception.CmisDaoException;
import com.yucheng.cmis.pub.util.ResourceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConfigLoader {
    public static final String TAG_RECORD_START = "SQL";
    public static final String TAG_SELECT = "SELECT";
    public static final String TAG_UPDATE = "UPDATE";
    public static final String TAG_DELETE = "DELETE";
    public static final String TAG_INSERT = "INSERT";
    public static final String TAG_DDL = "DDL";
    public static final String TAG_OPTCONDITION = "OPT_CONDITION";
    public static final String TAG_CONDITION_GROUP = "CONDI_GROUP";
    public static final String KEY_DEFUALT_CONDITION = "defaultCondition";
    private static final String ENCODING = "UTF-8";
    private static final String DB_ALL_TYPES_KEY = "DatabaseTypes";
    private static String[] dbTypes;
    private static List<String> currentDBSqlList;

    public void addConfig(Document doc) {
        if (doc == null) {
            return;
        }
        NodeList sqlNode = doc.getElementsByTagName(TAG_RECORD_START);
        for (int i = 0; i < sqlNode.getLength(); ++i) {
            NodeList ddlNode;
            NodeList addNode;
            NodeList deleteNode;
            NodeList updateNode;
            String id = sqlNode.item(i).getAttributes().getNamedItem("id").getNodeValue();
            Node pClassNode = sqlNode.item(i).getAttributes().getNamedItem("parameterClass");
            String parameterClass = pClassNode != null ? pClassNode.getNodeValue() : "";
            Node vClassNode = sqlNode.item(i).getAttributes().getNamedItem("valueClass");
            String valueClass = vClassNode != null ? vClassNode.getNodeValue() : "";
            Node rClassNode = sqlNode.item(i).getAttributes().getNamedItem("resultClass");
            String resultClass = rClassNode != null ? rClassNode.getNodeValue() : "";
            Node rFirstNode = sqlNode.item(i).getAttributes().getNamedItem("onlyReturnFirst");
            String onlyReturnFirst = rFirstNode != null ? rFirstNode.getNodeValue() : "";
            String sql = "";
            String sqlType = "";
            String updTableName = "";
            boolean canUpdateAll = false;
            Document subdoc = sqlNode.item(i).getOwnerDocument();
            NodeList selectNode = subdoc.getElementsByTagName(TAG_SELECT);
            if (selectNode != null && selectNode.getLength() > 0) {
                sql = selectNode.item(0).getTextContent();
                sqlType = TAG_SELECT;
            }
            if ((updateNode = subdoc.getElementsByTagName(TAG_UPDATE)) != null && updateNode.getLength() > 0) {
                sql = updateNode.item(0).getTextContent();
                Node tableNmNode = updateNode.item(0).getAttributes().getNamedItem("updTableName");
                updTableName = tableNmNode != null ? tableNmNode.getNodeValue() : "";
                Node updateAllNode = updateNode.item(0).getAttributes().getNamedItem("canUpdateAll");
                canUpdateAll = updateAllNode != null ? Boolean.parseBoolean(updateAllNode.getNodeValue()) : false;
                sqlType = TAG_UPDATE;
            }
            if ((deleteNode = subdoc.getElementsByTagName(TAG_DELETE)) != null && deleteNode.getLength() > 0) {
                sql = deleteNode.item(0).getTextContent();
                sqlType = TAG_DELETE;
            }
            if ((addNode = subdoc.getElementsByTagName(TAG_INSERT)) != null && addNode.getLength() > 0) {
                sql = addNode.item(0).getTextContent();
                Node tableNmNode = addNode.item(0).getAttributes().getNamedItem("updTableName");
                updTableName = tableNmNode != null ? tableNmNode.getNodeValue() : "";
                sqlType = TAG_INSERT;
            }
            if ((ddlNode = subdoc.getElementsByTagName(TAG_DDL)) != null && ddlNode.getLength() > 0) {
                sql = ddlNode.item(0).getTextContent();
                sqlType = TAG_DDL;
            }
            if (sql == null || sql.trim().equals("")) {
                if (updTableName == null || updTableName.trim().equals("")) continue;
                sql = "";
            }
            ArrayList<HashMap> groupCondi = new ArrayList<HashMap>();
            NodeList groupCondiNodeList = subdoc.getElementsByTagName(TAG_CONDITION_GROUP);
            if (groupCondiNodeList != null && groupCondiNodeList.getLength() > 0) {
                for (int n = 0; n < groupCondiNodeList.getLength(); ++n) {
                    Node groupNode = groupCondiNodeList.item(n);
                    String defaultCondi = groupNode.getAttributes().getNamedItem(KEY_DEFUALT_CONDITION).getNodeValue();
                    NodeList optCondi = groupNode.getChildNodes();
                    HashMap<String, String> optCondition = null;
                    optCondition = new HashMap<String, String>();
                    if (defaultCondi == null || defaultCondi.trim().equals("")) {
                        defaultCondi = "";
                    }
                    optCondition.put(KEY_DEFUALT_CONDITION, defaultCondi);
                    SqlConfigLoader.loadOptConditionNode(optCondi, optCondition);
                    groupCondi.add(optCondition);
                }
            } else {
                NodeList optCondiNode = subdoc.getElementsByTagName(TAG_OPTCONDITION);
                HashMap<String, String> optCondition = null;
                if (optCondiNode != null && optCondiNode.getLength() > 0) {
                    optCondition = new HashMap<String, String>();
                    SqlConfigLoader.loadOptConditionNode(optCondiNode, optCondition);
                    groupCondi.add(optCondition);
                }
            }
            SqlConfig sqlCfg = new SqlConfig();
            sqlCfg.setSqlid(id);
            sqlCfg.setParameterClass(parameterClass);
            sqlCfg.setValueClass(valueClass);
            sqlCfg.setResultClass(resultClass);
            sqlCfg.setOnlyReturnFirst(Boolean.parseBoolean(onlyReturnFirst));
            sqlCfg.setGroupCondition(groupCondi);
            sqlCfg.setSql(sql.trim());
            sqlCfg.setSqlType(sqlType);
            sqlCfg.setUpdTableName(updTableName);
            sqlCfg.setCanUpdateAll(canUpdateAll);
            SqlConfigBuffer.setSqlConfig(id, sqlCfg);
        }
    }

    public static void loadOptConditionNode(NodeList optCondiNode, HashMap<String, String> optCondition) {
        for (int k = 0; k < optCondiNode.getLength(); ++k) {
            String tagNm = optCondiNode.item(k).getNodeName();
            if (tagNm.startsWith("#")) continue;
            String condiId = optCondiNode.item(k).getAttributes().getNamedItem("id").getNodeValue();
            String condiRel = optCondiNode.item(k).getAttributes().getNamedItem("relationType").getNodeValue();
            String condi = optCondiNode.item(k).getTextContent();
            condiRel = condiRel != null ? condiRel.trim().toUpperCase() : "AND";
            if (condi == null) continue;
            optCondition.put(condiId, condiRel + "  " + condi.trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDigestSQLFile(String filename) throws Exception {
        boolean boReturn = false;
        File file = null;
        BufferedReader br = null;
        InputStreamReader in = null;
        FileInputStream fi = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            file = new File(filename);
            fi = new FileInputStream(new File(filename));
            in = new InputStreamReader((InputStream)fi, ENCODING);
            br = new BufferedReader(in);
            String st_line = "";
            StringBuffer stb_onerec = new StringBuffer();
            while (br.ready() && (st_line = br.readLine()) != null) {
                if (st_line.trim().startsWith("<SQL ")) {
                    stb_onerec.delete(0, stb_onerec.length());
                }
                stb_onerec.append(st_line);
                if (!st_line.trim().startsWith("</SQL>") && !st_line.trim().endsWith("</SQL>")) continue;
                StringReader sr = new StringReader(stb_onerec.toString());
                InputSource is_xml = new InputSource(sr);
                Document doc = builder.parse(is_xml);
                this.addConfig(doc);
                sr.close();
                boReturn = true;
            }
        }
        catch (FileNotFoundException e) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u6587\u4ef6\u5f02\u5e38\uff1a" + filename), (Throwable)e);
            boReturn = false;
        }
        catch (IOException e) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u6587\u4ef6\u5f02\u5e38\uff1a" + filename), (Throwable)e);
            boReturn = false;
        }
        catch (ParserConfigurationException e) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u6587\u4ef6\u5f02\u5e38\uff1a" + filename), (Throwable)e);
            boReturn = false;
        }
        catch (SAXException e) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u6587\u4ef6\u5f02\u5e38\uff1a" + filename), (Throwable)e);
            boReturn = false;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return boReturn;
    }

    public void loadSqlConfig() {
        try {
            String sqlFilePath = CMISDaoPropertyManager.getInstance().getPropertyValue("sqlclient.sql.file.path");
            if (sqlFilePath == null || "".equals(sqlFilePath)) {
                sqlFilePath = "classpath:sql";
            }
            String path = ResourceUtils.getFile((String)sqlFilePath).getAbsolutePath();
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u914d\u7f6e\u6587\u4ef6\u6839\u76ee\u5f55\uff1a" + path));
            this.loadSqlConfig(path);
            this.loadCurrentDbSqlConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSqlConfigAll(String path) {
        try {
            this.loadSqlConfig(path);
            this.loadCurrentDbSqlConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadCurrentDbSqlConfig() throws Exception {
        for (String file : currentDBSqlList) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u914d\u7f6e\u6587\u4ef6\uff1a" + file));
            this.doDigestSQLFile(file);
        }
    }

    public void loadSqlConfig(String path) throws Exception {
        try {
            String databaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
            File f = new File(path);
            File[] fList = f.listFiles();
            for (int n = 0; n < fList.length; ++n) {
                boolean canLoad = true;
                String fileName = fList[n].getName();
                if (fList[n].isDirectory()) {
                    this.loadSqlConfig(fList[n].getPath());
                }
                if (!fileName.endsWith(".sql.xml")) continue;
                if (fileName.toUpperCase().endsWith("_" + databaseType.toUpperCase() + ".SQL.XML")) {
                    currentDBSqlList.add(fList[n].getAbsolutePath());
                    continue;
                }
                if (dbTypes == null) {
                    this.loadDbTypes();
                }
                for (int i = 0; i < dbTypes.length; ++i) {
                    if (dbTypes[i].equals(databaseType) || !fileName.toUpperCase().endsWith("_" + dbTypes[i].toUpperCase() + ".SQL.XML")) continue;
                    canLoad = false;
                    break;
                }
                if (!canLoad) continue;
                EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u914d\u7f6e\u6587\u4ef6\uff1a" + fList[n].getAbsolutePath()));
                this.doDigestSQLFile(fList[n].getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void loadDbTypes() throws CmisDaoException {
        String databaseTypes = CMISDaoPropertyManager.getInstance().getPropertyValue(DB_ALL_TYPES_KEY);
        if (databaseTypes == null) {
            dbTypes = new String[]{"Oracle", "MySQL", "SqlServer2012", "Db2"};
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("DatabaseTypes\u5bf9\u5e94\u7684\u914d\u7f6e\u4e0d\u5b58\u5728\u4f7f\u7528\u9ed8\u8ba4\u503c:" + Arrays.asList(dbTypes)));
        } else {
            dbTypes = databaseTypes.split("[\\s]+");
        }
    }

    static {
        currentDBSqlList = new ArrayList<String>();
    }
}

